/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.core.InitializationException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNTag
extends Tag {
    private int numComponents = 0;

    @Override
    public String getName() {
        return "DN";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    private void initializeInternal(TemplateFile templateFile, String[] stringArray, int n) throws InitializationException {
        if (stringArray.length == 0) {
            this.numComponents = 0;
        } else if (stringArray.length == 1) {
            try {
                this.numComponents = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = 10682907;
                String string = MessageHandler.getMessage(n2, stringArray[0], this.getName(), n);
                throw new InitializationException(n2, string);
            }
        } else {
            int n3 = 10682904;
            String string = MessageHandler.getMessage(n3, this.getName(), n, 0, 1, stringArray.length);
            throw new InitializationException(n3, string);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN dN = templateEntry.getDN();
        if (dN == null || dN.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.numComponents == 0) {
            dN.toString(templateValue.getValue());
        } else if (this.numComponents > 0) {
            RDN[] rDNArray = dN.getRDNComponents();
            int n = Math.min(this.numComponents, rDNArray.length);
            rDNArray[0].toString(templateValue.getValue());
            for (int i = 1; i < n; ++i) {
                templateValue.append(",");
                rDNArray[i].toString(templateValue.getValue());
            }
        } else {
            RDN[] rDNArray = dN.getRDNComponents();
            int n = Math.min(Math.abs(this.numComponents), rDNArray.length);
            rDNArray[rDNArray.length - n].toString(templateValue.getValue());
            for (int i = 1; i < n; ++i) {
                templateValue.append(",");
                rDNArray[rDNArray.length - n + i].toString(templateValue.getValue());
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

