/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.AttributeValueTag;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.DNTag;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.FileTag;
import org.opends.server.tools.makeldif.FirstNameTag;
import org.opends.server.tools.makeldif.GUIDTag;
import org.opends.server.tools.makeldif.IfAbsentTag;
import org.opends.server.tools.makeldif.IfPresentTag;
import org.opends.server.tools.makeldif.LastNameTag;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.ParentDNTag;
import org.opends.server.tools.makeldif.PresenceTag;
import org.opends.server.tools.makeldif.RDNTag;
import org.opends.server.tools.makeldif.RandomTag;
import org.opends.server.tools.makeldif.SequentialTag;
import org.opends.server.tools.makeldif.StaticTextTag;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.tools.makeldif.UnderscoreDNTag;
import org.opends.server.tools.makeldif.UnderscoreParentDNTag;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFile {
    public static final String FIRST_NAME_FILE = "first.names";
    public static final String LAST_NAME_FILE = "last.names";
    private HashMap<String, String[]> fileLines;
    private int firstNameIndex;
    private int lastNameIndex;
    private int nameLoopCounter;
    private int nameUniquenessCounter;
    private LinkedHashMap<DN, Branch> branches;
    private LinkedHashMap<String, String> constants;
    private LinkedHashMap<String, Tag> registeredTags;
    private LinkedHashMap<String, Template> templates;
    private Random random;
    private String firstName;
    private String lastName;
    private String resourcePath;
    private String templatePath;
    private String[] firstNames;
    private String[] lastNames;

    public TemplateFile(String string) {
        this(string, new Random());
    }

    public TemplateFile(String string, Random random) {
        this.resourcePath = string;
        this.random = random;
        this.fileLines = new HashMap();
        this.branches = new LinkedHashMap();
        this.constants = new LinkedHashMap();
        this.registeredTags = new LinkedHashMap();
        this.templates = new LinkedHashMap();
        this.templatePath = null;
        this.firstNames = new String[0];
        this.lastNames = new String[0];
        this.firstName = null;
        this.lastName = null;
        this.firstNameIndex = 0;
        this.lastNameIndex = 0;
        this.nameLoopCounter = 0;
        this.nameUniquenessCounter = 1;
        this.registerDefaultTags();
        try {
            this.readNameFiles();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.firstNames = new String[]{"John"};
            this.lastNames = new String[]{"Doe"};
        }
    }

    public Map<String, Tag> getTags() {
        return this.registeredTags;
    }

    public Tag getTag(String string) {
        return this.registeredTags.get(string);
    }

    public void registerTag(String string) throws MakeLDIFException {
        Tag tag;
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            int n = 10682912;
            String string2 = MessageHandler.getMessage(n, string);
            throw new MakeLDIFException(n, string2, exception);
        }
        try {
            tag = (Tag)clazz.newInstance();
        }
        catch (Exception exception) {
            int n = 10682913;
            String string3 = MessageHandler.getMessage(n, string);
            throw new MakeLDIFException(n, string3, exception);
        }
        String string4 = StaticUtils.toLowerCase(tag.getName());
        if (this.registeredTags.containsKey(string4)) {
            int n = 10682914;
            String string5 = MessageHandler.getMessage(n, string, tag.getName());
            throw new MakeLDIFException(n, string5);
        }
        this.registeredTags.put(string4, tag);
    }

    private void registerDefaultTags() {
        Class[] classArray;
        for (Class clazz : classArray = new Class[]{AttributeValueTag.class, DNTag.class, FileTag.class, FirstNameTag.class, GUIDTag.class, IfAbsentTag.class, IfPresentTag.class, LastNameTag.class, ParentDNTag.class, PresenceTag.class, RandomTag.class, RDNTag.class, SequentialTag.class, StaticTextTag.class, UnderscoreDNTag.class, UnderscoreParentDNTag.class}) {
            try {
                Tag tag = (Tag)clazz.newInstance();
                this.registeredTags.put(StaticUtils.toLowerCase(tag.getName()), tag);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public String getConstant(String string) {
        return this.constants.get(string);
    }

    public void registerConstant(String string, String string2) {
        this.constants.put(StaticUtils.toLowerCase(string), string2);
    }

    public Map<DN, Branch> getBranches() {
        return this.branches;
    }

    public Branch getBranch(DN dN) {
        return this.branches.get(dN);
    }

    public void registerBranch(Branch branch) {
        this.branches.put(branch.getBranchDN(), branch);
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    public Template getTemplate(String string) {
        return this.templates.get(string);
    }

    public void registerTemplate(Template template) {
        this.templates.put(StaticUtils.toLowerCase(template.getName()), template);
    }

    public Random getRandom() {
        return this.random;
    }

    private void readNameFiles() throws IOException {
        String string;
        File file = this.getFile(FIRST_NAME_FILE);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        this.firstNames = new String[arrayList.size()];
        arrayList.toArray(this.firstNames);
        file = this.getFile(LAST_NAME_FILE);
        arrayList = new ArrayList();
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        this.lastNames = new String[arrayList.size()];
        arrayList.toArray(this.lastNames);
    }

    public void nextFirstAndLastNames() {
        this.firstName = this.firstNames[this.firstNameIndex++];
        this.lastName = this.lastNames[this.lastNameIndex++];
        if (this.nameUniquenessCounter > 1) {
            this.lastName = this.lastName + this.nameUniquenessCounter;
        }
        if (this.firstNameIndex >= this.firstNames.length) {
            this.firstNameIndex = 0;
            if (this.firstNames.length > this.lastNames.length) {
                this.lastNameIndex = ++this.nameLoopCounter;
                if (this.lastNameIndex >= this.lastNames.length) {
                    this.lastNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        } else if (this.lastNameIndex >= this.lastNames.length) {
            this.lastNameIndex = 0;
            if (this.lastNames.length > this.firstNames.length) {
                this.firstNameIndex = ++this.nameLoopCounter;
                if (this.firstNameIndex >= this.firstNames.length) {
                    this.firstNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void parse(String string, List<String> list) throws IOException, InitializationException, MakeLDIFException {
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.templatePath = null;
        File file = this.getFile(string);
        if (file == null || !file.exists()) {
            int n = 10682960;
            String string2 = MessageHandler.getMessage(n, string);
            throw new IOException(string2);
        }
        this.templatePath = file.getParentFile().getAbsolutePath();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((stringArray = bufferedReader.readLine()) != null) {
            arrayList.add(stringArray);
        }
        bufferedReader.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.parse(stringArray, list);
    }

    public void parse(InputStream inputStream, List<String> list) throws IOException, InitializationException, MakeLDIFException {
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((stringArray = bufferedReader.readLine()) != null) {
            arrayList.add(stringArray);
        }
        bufferedReader.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.parse(stringArray, list);
    }

    public void parse(String[] stringArray, List<String> list) throws InitializationException, MakeLDIFException {
        LinkedHashMap<String, Tag> linkedHashMap = new LinkedHashMap<String, Tag>();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        LinkedHashMap<Object, Branch> linkedHashMap3 = new LinkedHashMap<Object, Branch>();
        LinkedHashMap<String, Template> linkedHashMap4 = new LinkedHashMap<String, Template>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2;
            Object object;
            int n2;
            Object object2;
            Object object3;
            int n3;
            CharSequence charSequence;
            Object object4 = stringArray[i];
            int n4 = ((String)object4).lastIndexOf(93);
            if (n4 > 0) {
                charSequence = new StringBuilder((String)object4);
                n3 = ((String)object4).lastIndexOf(91, n4);
                if (n3 >= 0) {
                    object3 = StaticUtils.toLowerCase(((String)object4).substring(n3 + 1, n4));
                    object2 = (String)linkedHashMap2.get(object3);
                    if (object2 == null) {
                        n2 = 10551843;
                        object = MessageHandler.getMessage(n2, object3, i);
                        list.add((String)object);
                    } else {
                        ((StringBuilder)charSequence).replace(n3, n4 + 1, (String)object2);
                    }
                }
                object4 = ((StringBuilder)charSequence).toString();
            }
            charSequence = StaticUtils.toLowerCase((String)object4);
            if (((String)object4).length() == 0 || ((String)object4).startsWith("#")) continue;
            if (((String)charSequence).startsWith("include ")) {
                String string3 = ((String)object4).substring(8).trim();
                try {
                    object3 = Class.forName(string3);
                }
                catch (Exception exception) {
                    n2 = 10682912;
                    object = MessageHandler.getMessage(n2, string3);
                    throw new MakeLDIFException(n2, (String)object, exception);
                }
                try {
                    object2 = (Tag)((Class)object3).newInstance();
                }
                catch (Exception exception) {
                    int n5 = 10682913;
                    string2 = MessageHandler.getMessage(n5, string3);
                    throw new MakeLDIFException(n5, string2, exception);
                }
                String string4 = StaticUtils.toLowerCase(((Tag)object2).getName());
                if (this.registeredTags.containsKey(string4) || linkedHashMap.containsKey(string4)) {
                    int n6 = 10682914;
                    string2 = MessageHandler.getMessage(n6, string3, ((Tag)object2).getName());
                    throw new MakeLDIFException(n6, string2);
                }
                linkedHashMap.put(string4, (Tag)object2);
                continue;
            }
            if (((String)charSequence).startsWith("define ")) {
                n3 = ((String)object4).indexOf(61, 7);
                if (n3 < 0) {
                    int n7 = 10682916;
                    object2 = MessageHandler.getMessage(n7, i);
                    throw new MakeLDIFException(n7, (String)object2);
                }
                object3 = ((String)object4).substring(7, n3).trim();
                if (((String)object3).length() == 0) {
                    int n8 = 10682917;
                    String string5 = MessageHandler.getMessage(n8, i);
                    throw new MakeLDIFException(n8, string5);
                }
                object2 = StaticUtils.toLowerCase(object3);
                if (linkedHashMap2.containsKey(object2)) {
                    n2 = 10682918;
                    object = MessageHandler.getMessage(n2, object3, i);
                    throw new MakeLDIFException(n2, (String)object);
                }
                String string6 = ((String)object4).substring(n3 + 1);
                if (string6.length() == 0) {
                    int n9 = 10682919;
                    string2 = MessageHandler.getMessage(n9, object3, i);
                    list.add(string2);
                }
                linkedHashMap2.put((String)object2, string6);
                continue;
            }
            if (((String)charSequence).startsWith("branch: ")) {
                n3 = i;
                object3 = new ArrayList<Object>();
                ((ArrayList)object3).add(object4);
                while (++i < stringArray.length && ((String)(object4 = stringArray[i])).length() != 0) {
                    n4 = ((String)object4).lastIndexOf(93);
                    if (n4 > 0) {
                        object2 = new StringBuilder((String)object4);
                        n2 = ((String)object4).lastIndexOf(91, n4);
                        if (n2 >= 0) {
                            object = StaticUtils.toLowerCase(((String)object4).substring(n2 + 1, n4));
                            string2 = linkedHashMap2.get(object);
                            if (string2 == null) {
                                n = 10551843;
                                string = MessageHandler.getMessage(n, object, i);
                                list.add(string);
                            } else {
                                ((StringBuilder)object2).replace(n2, n4 + 1, string2);
                            }
                        }
                        object4 = ((StringBuilder)object2).toString();
                    }
                    ((ArrayList)object3).add(object4);
                }
                object2 = new String[((ArrayList)object3).size()];
                ((ArrayList)object3).toArray((T[])object2);
                Branch branch = this.parseBranchDefinition((String[])object2, i, linkedHashMap, linkedHashMap2, list);
                object = branch.getBranchDN();
                if (linkedHashMap3.containsKey(object)) {
                    int n10 = 10682920;
                    String string7 = MessageHandler.getMessage(n10, String.valueOf(object), n3);
                    throw new MakeLDIFException(n10, string7);
                }
                linkedHashMap3.put(object, branch);
                continue;
            }
            if (((String)charSequence).startsWith("template: ")) {
                n3 = i;
                object3 = new ArrayList<Object>();
                ((ArrayList)object3).add(object4);
                while (++i < stringArray.length && ((String)(object4 = stringArray[i])).length() != 0) {
                    n4 = ((String)object4).lastIndexOf(93);
                    if (n4 > 0) {
                        object2 = new StringBuilder((String)object4);
                        n2 = ((String)object4).lastIndexOf(91, n4);
                        if (n2 >= 0) {
                            object = StaticUtils.toLowerCase(((String)object4).substring(n2 + 1, n4));
                            string2 = linkedHashMap2.get(object);
                            if (string2 == null) {
                                n = 10551843;
                                string = MessageHandler.getMessage(n, object, i);
                                list.add(string);
                            } else {
                                ((StringBuilder)object2).replace(n2, n4 + 1, string2);
                            }
                        }
                        object4 = ((StringBuilder)object2).toString();
                    }
                    ((ArrayList)object3).add(object4);
                }
                object2 = new String[((ArrayList)object3).size()];
                ((ArrayList)object3).toArray((T[])object2);
                Template template = this.parseTemplateDefinition((String[])object2, i, linkedHashMap, linkedHashMap2, list);
                object = StaticUtils.toLowerCase(template.getName());
                if (linkedHashMap4.containsKey(object)) {
                    int n11 = 10682921;
                    String string8 = MessageHandler.getMessage(n11, String.valueOf(template.getName()), n3);
                    throw new MakeLDIFException(n11, string8);
                }
                linkedHashMap4.put((String)object, template);
                continue;
            }
            n3 = 10682922;
            object3 = MessageHandler.getMessage(n3, object4, i);
            throw new MakeLDIFException(n3, (String)object3);
        }
        for (Object object4 : linkedHashMap3.values()) {
            ((Branch)object4).completeBranchInitialization(linkedHashMap4);
        }
        for (Object object4 : linkedHashMap4.values()) {
            ((Template)object4).completeTemplateInitialization(linkedHashMap4);
        }
        this.registeredTags.putAll(linkedHashMap);
        this.constants.putAll(linkedHashMap2);
        this.branches.putAll(linkedHashMap3);
        this.templates.putAll(linkedHashMap4);
    }

    private Branch parseBranchDefinition(String[] stringArray, int n, LinkedHashMap<String, Tag> linkedHashMap, LinkedHashMap<String, String> linkedHashMap2, List<String> list) throws InitializationException, MakeLDIFException {
        DN dN;
        String string = stringArray[0].substring(8).trim();
        try {
            dN = DN.decode(string);
        }
        catch (Exception exception) {
            int n2 = 10682924;
            String string2 = MessageHandler.getMessage(n2, string, n);
            throw new MakeLDIFException(n2, string2);
        }
        Branch branch = new Branch(this, dN);
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String string4 = StaticUtils.toLowerCase(string3);
            int n3 = n + i;
            if (string4.startsWith("#")) continue;
            if (string4.startsWith("subordinatetemplate: ")) {
                int n4 = string3.indexOf(58, 21);
                if (n4 <= 21) {
                    int n5 = 10682925;
                    String string5 = MessageHandler.getMessage(n5, n3, string);
                    throw new MakeLDIFException(n5, string5);
                }
                String string6 = string3.substring(21, n4).trim();
                try {
                    String string7;
                    int n6;
                    int n7 = Integer.parseInt(string3.substring(n4 + 1).trim());
                    if (n7 < 0) {
                        n6 = 10682926;
                        string7 = MessageHandler.getMessage(n6, n3, string, n7, string6);
                        throw new MakeLDIFException(n6, string7);
                    }
                    if (n7 == 0) {
                        n6 = 10551855;
                        string7 = MessageHandler.getMessage(n6, n3, string, string6);
                        list.add(string7);
                    }
                    branch.addSubordinateTemplate(string6, n7);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    int n8 = 10682928;
                    String string8 = MessageHandler.getMessage(n8, string6, n3, string);
                    throw new MakeLDIFException(n8, string8);
                }
            }
            TemplateLine templateLine = this.parseTemplateLine(string3, string4, n3, branch, null, linkedHashMap, list);
            branch.addExtraLine(templateLine);
        }
        return branch;
    }

    private Template parseTemplateDefinition(String[] stringArray, int n, LinkedHashMap<String, Tag> linkedHashMap, LinkedHashMap<String, String> linkedHashMap2, List<String> list) throws InitializationException, MakeLDIFException {
        String string;
        Object object;
        Object object2;
        int n2;
        String string2 = stringArray[0].substring(10).trim();
        String string3 = null;
        AttributeType[] attributeTypeArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            Object object3;
            int n3 = n + n2;
            object2 = stringArray[n2];
            String string4 = StaticUtils.toLowerCase((String)object2);
            if (string4.startsWith("#")) continue;
            if (string4.startsWith("extends: ")) {
                string3 = ((String)object2).substring(9).trim();
                continue;
            }
            if (string4.startsWith("rdnattr: ")) {
                object = new ArrayList();
                string = string4.substring(9).trim();
                object3 = new StringTokenizer(string, "+");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    ((ArrayList)object).add(DirectoryServer.getAttributeType(((StringTokenizer)object3).nextToken(), true));
                }
                attributeTypeArray = new AttributeType[((ArrayList)object).size()];
                ((ArrayList)object).toArray(attributeTypeArray);
                continue;
            }
            if (!string4.startsWith("subordinatetemplate: ")) break;
            int n4 = ((String)object2).indexOf(58, 21);
            if (n4 <= 21) {
                int n5 = 10682929;
                object3 = MessageHandler.getMessage(n5, n3, string2);
                throw new MakeLDIFException(n5, (String)object3);
            }
            string = ((String)object2).substring(21, n4).trim();
            try {
                String string5;
                int n6;
                int n7 = Integer.parseInt(((String)object2).substring(n4 + 1).trim());
                if (n7 < 0) {
                    n6 = 10682930;
                    string5 = MessageHandler.getMessage(n6, n3, string2, n7, string);
                    throw new MakeLDIFException(n6, string5);
                }
                if (n7 == 0) {
                    n6 = 10551859;
                    string5 = MessageHandler.getMessage(n6, n3, string2, string);
                    list.add(string5);
                }
                arrayList.add(string);
                arrayList2.add(n7);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                int n8 = 10682932;
                String string6 = MessageHandler.getMessage(n8, string, n3, string2);
                throw new MakeLDIFException(n8, string6);
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        object2 = new int[arrayList2.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = (Integer)arrayList2.get(i);
        }
        Template template = new Template(this, string2, attributeTypeArray, stringArray2, (int[])object2);
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            string = StaticUtils.toLowerCase((String)object);
            int n9 = n + n2;
            if (!string.startsWith("#")) {
                TemplateLine templateLine = this.parseTemplateLine((String)object, string, n9, null, template, linkedHashMap, list);
                template.addTemplateLine(templateLine);
            }
            ++n2;
        }
        return template;
    }

    private TemplateLine parseTemplateLine(String string, String string2, int n, Branch branch, Template template, LinkedHashMap<String, Tag> linkedHashMap, List<String> list) throws InitializationException, MakeLDIFException {
        String[] stringArray;
        int n2;
        int n3 = string2.indexOf(58);
        if (n3 < 0) {
            if (branch == null) {
                int n4 = 10682937;
                String string3 = MessageHandler.getMessage(n4, n, template.getName());
                throw new MakeLDIFException(n4, string3);
            }
            int n5 = 10682934;
            String string4 = MessageHandler.getMessage(n5, n, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(n5, string4);
        }
        if (n3 == 0) {
            if (branch == null) {
                int n6 = 10682938;
                String string5 = MessageHandler.getMessage(n6, n, template.getName());
                throw new MakeLDIFException(n6, string5);
            }
            int n7 = 10682935;
            String string6 = MessageHandler.getMessage(n7, n, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(n7, string6);
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(string2.substring(0, n3), true);
        int n8 = string.length();
        for (n2 = n3 + 1; n2 < n8 && string2.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n8) {
            String string7;
            int n9;
            if (branch == null) {
                n9 = 10551867;
                string7 = MessageHandler.getMessage(n9, n, template.getName());
                list.add(string7);
            } else {
                n9 = 10551864;
                string7 = MessageHandler.getMessage(n9, n, String.valueOf(branch.getBranchDN()));
                list.add(string7);
            }
        }
        int n10 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < n8) {
            char c = string.charAt(n2);
            block0 : switch (n10) {
                case 0: {
                    switch (c) {
                        case '<': {
                            String[] stringArray2;
                            if (stringBuilder.length() > 0) {
                                stringArray = new StaticTextTag();
                                stringArray2 = new String[]{stringBuilder.toString()};
                                stringArray.initializeForBranch(this, branch, stringArray2, n, list);
                                arrayList.add(stringArray);
                                stringBuilder = new StringBuilder();
                            }
                            n10 = 1;
                            break block0;
                        }
                        case '{': {
                            String[] stringArray2;
                            if (stringBuilder.length() > 0) {
                                stringArray = new StaticTextTag();
                                stringArray2 = new String[]{stringBuilder.toString()};
                                stringArray.initializeForBranch(this, branch, stringArray2, n, list);
                                arrayList.add(stringArray);
                                stringBuilder = new StringBuilder();
                            }
                            n10 = 2;
                            break block0;
                        }
                    }
                    stringBuilder.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '>': {
                            stringArray = this.parseReplacementTag(stringBuilder.toString(), branch, template, n, linkedHashMap, list);
                            arrayList.add(stringArray);
                            stringBuilder = new StringBuilder();
                            n10 = 0;
                            break block0;
                        }
                    }
                    stringBuilder.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '}': {
                            stringArray = this.parseAttributeTag(stringBuilder.toString(), branch, template, n, list);
                            arrayList.add(stringArray);
                            stringBuilder = new StringBuilder();
                            n10 = 0;
                            break block0;
                        }
                    }
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        if (n10 == 0) {
            if (stringBuilder.length() > 0) {
                StaticTextTag staticTextTag = new StaticTextTag();
                stringArray = new String[]{stringBuilder.toString()};
                staticTextTag.initializeForBranch(this, branch, stringArray, n, list);
                arrayList.add(staticTextTag);
            }
        } else {
            int tagArray = 10682975;
            stringArray = MessageHandler.getMessage(tagArray, n);
            throw new InitializationException(tagArray, (String)stringArray);
        }
        Tag[] tagArray = new Tag[arrayList.size()];
        arrayList.toArray(tagArray);
        return new TemplateLine(attributeType, n, tagArray);
    }

    private Tag parseReplacementTag(String string, Branch branch, Template template, int n, LinkedHashMap<String, Tag> linkedHashMap, List<String> list) throws InitializationException, MakeLDIFException {
        Tag tag;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = StaticUtils.toLowerCase(string2);
        Tag tag2 = this.getTag(string3);
        if (tag2 == null && (tag2 = linkedHashMap.get(string3)) == null) {
            int n2 = 10682940;
            String string4 = MessageHandler.getMessage(n2, string2, n);
            throw new MakeLDIFException(n2, string4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        try {
            tag = (Tag)tag2.getClass().newInstance();
        }
        catch (Exception exception) {
            int n3 = 10682941;
            String string5 = MessageHandler.getMessage(n3, string2, n, String.valueOf(exception));
            throw new MakeLDIFException(n3, string5, exception);
        }
        if (branch == null) {
            tag.initializeForTemplate(this, template, stringArray, n, list);
        } else if (tag.allowedInBranch()) {
            tag.initializeForBranch(this, branch, stringArray, n, list);
        } else {
            int n4 = 10682976;
            String string6 = MessageHandler.getMessage(n4, tag.getName(), n);
            throw new MakeLDIFException(n4, string6);
        }
        return tag;
    }

    private Tag parseAttributeTag(String string, Branch branch, Template template, int n, List<String> list) throws InitializationException, MakeLDIFException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        AttributeValueTag attributeValueTag = new AttributeValueTag();
        if (branch == null) {
            attributeValueTag.initializeForTemplate(this, template, stringArray, n, list);
        } else {
            attributeValueTag.initializeForBranch(this, branch, stringArray, n, list);
        }
        return attributeValueTag;
    }

    public File getFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        if (file.isAbsolute()) {
            return file;
        }
        String string2 = this.resourcePath + File.separator + string;
        file = new File(string2);
        if (file.exists()) {
            return file;
        }
        if (this.templatePath != null && (file = new File(string2 = (this.templatePath = File.separator + string))).exists()) {
            return file;
        }
        return null;
    }

    public String[] getFileLines(File file) throws IOException {
        String string = file.getAbsolutePath();
        String[] stringArray = this.fileLines.get(string);
        if (stringArray == null) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            bufferedReader.close();
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            arrayList.clear();
            this.fileLines.put(string, stringArray);
        }
        return stringArray;
    }

    public TagResult generateLDIF(EntryWriter entryWriter) throws IOException, MakeLDIFException {
        for (Branch branch : this.branches.values()) {
            TagResult tagResult = branch.writeEntries(entryWriter);
            if (tagResult.keepProcessingTemplateFile()) continue;
            return tagResult;
        }
        entryWriter.closeEntryWriter();
        return TagResult.SUCCESS_RESULT;
    }
}

