/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TimeZone;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupDirectory;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupInfo {
    private static final String CLASS_NAME = "org.opends.server.types.BackupInfo";
    public static final String PROPERTY_BACKUP_DATE = "backup_date";
    public static final String PROPERTY_BACKUP_ID = "backup_id";
    public static final String PROPERTY_IS_INCREMENTAL = "incremental";
    public static final String PROPERTY_IS_COMPRESSED = "compressed";
    public static final String PROPERTY_IS_ENCRYPTED = "encrypted";
    public static final String PROPERTY_UNSIGNED_HASH = "hash";
    public static final String PROPERTY_SIGNED_HASH = "signed_hash";
    public static final String PROPERTY_DEPENDENCY = "dependency";
    public static final String PROPERTY_CUSTOM_PREFIX = "property.";
    private BackupDirectory backupDirectory;
    private boolean isCompressed;
    private boolean isEncrypted;
    private boolean isIncremental;
    private byte[] signedHash;
    private byte[] unsignedHash;
    private Date backupDate;
    private HashSet<String> dependencies;
    private HashMap<String, String> backupProperties;
    private String backupID;

    public BackupInfo(BackupDirectory backupDirectory, String string, Date date, boolean bl, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, HashSet<String> hashSet, HashMap<String, String> hashMap) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(backupDirectory), String.valueOf(string), String.valueOf(date), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(byArray), String.valueOf(byArray2), String.valueOf(hashSet), String.valueOf(hashMap)));
        this.backupDirectory = backupDirectory;
        this.backupID = string;
        this.backupDate = date;
        this.isIncremental = bl;
        this.isCompressed = bl2;
        this.isEncrypted = bl3;
        this.unsignedHash = byArray;
        this.signedHash = byArray2;
        this.dependencies = hashSet == null ? new HashSet() : hashSet;
        this.backupProperties = hashMap == null ? new HashMap() : hashMap;
    }

    public BackupDirectory getBackupDirectory() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackupDirectory", new String[0]));
        return this.backupDirectory;
    }

    public String getBackupID() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackupID", new String[0]));
        return this.backupID;
    }

    public Date getBackupDate() {
        return this.backupDate;
    }

    public boolean isIncremental() {
        assert (Debug.debugEnter(CLASS_NAME, "isIncremental", new String[0]));
        return this.isIncremental;
    }

    public boolean isCompressed() {
        assert (Debug.debugEnter(CLASS_NAME, "isCompressed", new String[0]));
        return this.isCompressed;
    }

    public boolean isEncrypted() {
        assert (Debug.debugEnter(CLASS_NAME, "isEncrypted", new String[0]));
        return this.isEncrypted;
    }

    public byte[] getUnsignedHash() {
        assert (Debug.debugEnter(CLASS_NAME, "getUnsignedHash", new String[0]));
        return this.unsignedHash;
    }

    public byte[] getSignedHash() {
        assert (Debug.debugEnter(CLASS_NAME, "getSignedHash", new String[0]));
        return this.signedHash;
    }

    public HashSet<String> getDependencies() {
        assert (Debug.debugEnter(CLASS_NAME, "getDependencies", new String[0]));
        return this.dependencies;
    }

    public boolean dependsOn(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "dependsOn", String.valueOf(string)));
        return this.dependencies.contains(string);
    }

    public HashMap<String, String> getBackupProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackupProperties", new String[0]));
        return this.backupProperties;
    }

    public String getBackupProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getBackupProperty", String.valueOf(string)));
        return this.backupProperties.get(string);
    }

    public LinkedList<String> encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        LinkedList<String> linkedList = new LinkedList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        linkedList.add("backup_id=" + this.backupID);
        linkedList.add("backup_date=" + simpleDateFormat.format(this.backupDate));
        linkedList.add("incremental=" + String.valueOf(this.isIncremental));
        linkedList.add("compressed=" + String.valueOf(this.isCompressed));
        linkedList.add("encrypted=" + String.valueOf(this.isEncrypted));
        if (this.unsignedHash != null) {
            linkedList.add("hash=" + Base64.encode(this.unsignedHash));
        }
        if (this.signedHash != null) {
            linkedList.add("signed_hash=" + Base64.encode(this.signedHash));
        }
        if (!this.dependencies.isEmpty()) {
            for (String string : this.dependencies) {
                linkedList.add("dependency=" + string);
            }
        }
        if (!this.backupProperties.isEmpty()) {
            for (String string : this.backupProperties.keySet()) {
                String string2 = this.backupProperties.get(string);
                if (string2 == null) {
                    string2 = "";
                }
                linkedList.add(PROPERTY_CUSTOM_PREFIX + string + "=" + string2);
            }
        }
        return linkedList;
    }

    public static BackupInfo decode(BackupDirectory backupDirectory, LinkedList<String> linkedList) throws ConfigException {
        String string4;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(linkedList)));
        String string2 = null;
        Date date = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray = null;
        byte[] byArray2 = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = backupDirectory.getPath();
        try {
            for (String string4 : linkedList) {
                Object object;
                String string5;
                int n = string4.indexOf(61);
                if (n < 0) {
                    int n2 = 262436;
                    string5 = MessageHandler.getMessage(n2, string4, string3);
                    throw new ConfigException(n2, string5);
                }
                if (n == 0) {
                    int n3 = 262437;
                    string5 = MessageHandler.getMessage(n3, string4, string3);
                    throw new ConfigException(n3, string5);
                }
                String string6 = string4.substring(0, n);
                string5 = string4.substring(n + 1);
                if (string6.equals(PROPERTY_BACKUP_ID)) {
                    if (string2 == null) {
                        string2 = string5;
                        continue;
                    }
                    int n4 = 262438;
                    String string7 = MessageHandler.getMessage(n4, string3, string2, string5);
                    throw new ConfigException(n4, string7);
                }
                if (string6.equals(PROPERTY_BACKUP_DATE)) {
                    object = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                    ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
                    date = ((DateFormat)object).parse(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_IS_INCREMENTAL)) {
                    bl = Boolean.valueOf(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_IS_COMPRESSED)) {
                    bl2 = Boolean.valueOf(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_IS_ENCRYPTED)) {
                    bl3 = Boolean.valueOf(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_UNSIGNED_HASH)) {
                    byArray = Base64.decode(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_SIGNED_HASH)) {
                    byArray2 = Base64.decode(string5);
                    continue;
                }
                if (string6.equals(PROPERTY_DEPENDENCY)) {
                    hashSet.add(string5);
                    continue;
                }
                if (string6.startsWith(PROPERTY_CUSTOM_PREFIX)) {
                    object = string6.substring(PROPERTY_CUSTOM_PREFIX.length());
                    hashMap.put((String)object, string5);
                    continue;
                }
                int n5 = 262439;
                String string8 = MessageHandler.getMessage(n5, string3, string6, string5);
                throw new ConfigException(n5, string8);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 262440;
            String string9 = MessageHandler.getMessage(n, string3, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string9, exception);
        }
        if (string2 == null) {
            int n = 262441;
            string4 = MessageHandler.getMessage(n, string3);
            throw new ConfigException(n, string4);
        }
        if (date == null) {
            int n = 262442;
            string4 = MessageHandler.getMessage(n, string2, string3);
            throw new ConfigException(n, string4);
        }
        return new BackupInfo(backupDirectory, string2, date, bl, bl2, bl3, byArray, byArray2, hashSet, hashMap);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        LinkedList<String> linkedList = this.encode();
        for (String string : linkedList) {
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        }
    }
}

