/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.core.Operation;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateResponse {
    private static final String CLASS_NAME = "org.opends.server.types.IntermediateResponse";
    private ASN1OctetString value;
    private List<Control> controls;
    private Operation operation;
    private String oid;

    public IntermediateResponse(Operation operation, String string, ASN1OctetString aSN1OctetString, List<Control> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(operation), String.valueOf(string), String.valueOf(aSN1OctetString), String.valueOf(list)));
        this.operation = operation;
        this.oid = string;
        this.value = aSN1OctetString;
        this.controls = list == null ? new ArrayList<Control>(0) : list;
    }

    public Operation getOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperation", new String[0]));
        return this.operation;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public void setValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(aSN1OctetString)));
        this.value = aSN1OctetString;
    }

    public List<Control> getControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getControls", new String[0]));
        return this.controls;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("IntermediateResponse(operation=");
        this.operation.toString(stringBuilder);
        stringBuilder.append(",oid=");
        stringBuilder.append(String.valueOf(this.oid));
        stringBuilder.append(",value=");
        stringBuilder.append(String.valueOf(stringBuilder));
        if (!this.controls.isEmpty()) {
            stringBuilder.append(",controls={");
            Iterator<Control> iterator = this.controls.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                iterator.next().toString(stringBuilder);
            }
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
    }
}

