/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.MakeLDIFInputStream;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFImportConfig {
    private static final String CLASS_NAME = "org.opends.server.types.LDIFImportConfig";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean appendToExistingData;
    private boolean includeObjectClasses;
    private boolean invokeImportPlugins;
    private boolean isCompressed;
    private boolean isEncrypted;
    private boolean replaceExistingEntries;
    private boolean validateSchema;
    private BufferedReader reader;
    private BufferedWriter rejectWriter;
    private InputStream ldifInputStream;
    private int bufferSize;
    private Iterator<String> ldifFileIterator;
    private List<DN> excludeBranches;
    private List<DN> includeBranches;
    private List<SearchFilter> excludeFilters;
    private List<SearchFilter> includeFilters;
    private List<String> ldifFiles;
    private Set<AttributeType> excludeAttributes;
    private Set<AttributeType> includeAttributes;
    private TemplateFile templateFile;

    public LDIFImportConfig(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.ldifFiles = new ArrayList<String>(1);
        this.ldifFiles.add(string);
        this.ldifFileIterator = this.ldifFiles.iterator();
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.validateSchema = true;
        this.reader = null;
        this.rejectWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
    }

    public LDIFImportConfig(List<String> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(list)));
        this.ldifFiles = list;
        this.ldifFileIterator = list.iterator();
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.validateSchema = true;
        this.reader = null;
        this.rejectWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
    }

    public LDIFImportConfig(InputStream inputStream) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(inputStream)));
        this.ldifInputStream = inputStream;
        this.bufferSize = 8192;
        this.ldifFiles = null;
        this.ldifFileIterator = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.reader = null;
        this.rejectWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
    }

    public LDIFImportConfig(Reader reader) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(this.ldifInputStream)));
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.ldifFiles = null;
        this.ldifFileIterator = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.reader = this.getBufferedReader(reader);
        this.rejectWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
    }

    private BufferedReader getBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public LDIFImportConfig(TemplateFile templateFile) {
        this(new MakeLDIFInputStream(templateFile));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(templateFile)));
    }

    public BufferedReader getReader() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "getReader", new String[0]));
        if (this.reader == null) {
            InputStream inputStream = this.ldifInputStream == null ? (this.ldifInputStream = new FileInputStream(this.ldifFileIterator.next())) : this.ldifInputStream;
            if (this.isEncrypted) {
                // empty if block
            }
            if (this.isCompressed) {
                inputStream = new GZIPInputStream(inputStream);
            }
            this.reader = new BufferedReader(new InputStreamReader(inputStream), this.bufferSize);
        }
        return this.reader;
    }

    public BufferedReader nextReader() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "nextReader", new String[0]));
        if (this.ldifFileIterator == null || !this.ldifFileIterator.hasNext()) {
            return null;
        }
        this.reader.close();
        this.ldifInputStream = new FileInputStream(this.ldifFileIterator.next());
        InputStream inputStream = this.ldifInputStream;
        if (this.isEncrypted) {
            // empty if block
        }
        if (this.isCompressed) {
            inputStream = new GZIPInputStream(inputStream);
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream), this.bufferSize);
        return this.reader;
    }

    public BufferedWriter getRejectWriter() {
        assert (Debug.debugEnter(CLASS_NAME, "getRejectWriter", new String[0]));
        return this.rejectWriter;
    }

    public void writeRejectedEntries(String string, ExistingFileBehavior existingFileBehavior) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeRejectedEntries", String.valueOf(string), String.valueOf((Object)existingFileBehavior)));
        if (string == null) {
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rejectWriter = null;
            }
            return;
        }
        switch (existingFileBehavior) {
            case APPEND: {
                this.rejectWriter = new BufferedWriter(new FileWriter(string, true));
                break;
            }
            case OVERWRITE: {
                this.rejectWriter = new BufferedWriter(new FileWriter(string, false));
                break;
            }
            case FAIL: {
                File file = new File(string);
                if (file.exists()) {
                    throw new IOException(MessageHandler.getMessage(5505045, string));
                }
                this.rejectWriter = new BufferedWriter(new FileWriter(string));
            }
        }
    }

    public void writeRejectedEntries(OutputStream outputStream) {
        assert (Debug.debugEnter(CLASS_NAME, "writeRejectedEntries", String.valueOf(outputStream)));
        if (outputStream == null) {
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rejectWriter = null;
            }
            return;
        }
        this.rejectWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public boolean appendToExistingData() {
        assert (Debug.debugEnter(CLASS_NAME, "appendToExistingData", new String[0]));
        return this.appendToExistingData;
    }

    public void setAppendToExistingData(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setAppendToExistingData", String.valueOf(bl)));
        this.appendToExistingData = bl;
    }

    public boolean replaceExistingEntries() {
        assert (Debug.debugEnter(CLASS_NAME, "replaceExistingEntries", new String[0]));
        return this.replaceExistingEntries;
    }

    public void setReplaceExistingEntries(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setReplaceExistingEntries", String.valueOf(bl)));
        this.replaceExistingEntries = bl;
    }

    public boolean invokeImportPlugins() {
        assert (Debug.debugEnter(CLASS_NAME, "invokeImportPlugins", new String[0]));
        return this.invokeImportPlugins;
    }

    public void setInvokeImportPlugins(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setInvokeImportPlugins", String.valueOf(bl)));
        this.invokeImportPlugins = bl;
    }

    public boolean isCompressed() {
        assert (Debug.debugEnter(CLASS_NAME, "isCompressed", new String[0]));
        return this.isCompressed;
    }

    public void setCompressed(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setCompressed", String.valueOf(bl)));
        this.isCompressed = bl;
    }

    public boolean isEncrypted() {
        assert (Debug.debugEnter(CLASS_NAME, "isEncrypted", new String[0]));
        return this.isEncrypted;
    }

    public void setEncrypted(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setEncrypted", String.valueOf(bl)));
        this.isEncrypted = bl;
    }

    public boolean validateSchema() {
        assert (Debug.debugEnter(CLASS_NAME, "validateSchema", new String[0]));
        return this.validateSchema;
    }

    public void setValidateSchema(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setValidateSchema", String.valueOf(bl)));
        this.validateSchema = bl;
    }

    public List<DN> getExcludeBranches() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeBranches", new String[0]));
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeBranches", String.valueOf(list)));
        this.excludeBranches = list == null ? new ArrayList<DN>(0) : list;
    }

    public List<DN> getIncludeBranches() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeBranches", new String[0]));
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeBranches", String.valueOf(list)));
        this.includeBranches = list == null ? new ArrayList<DN>(0) : list;
    }

    public boolean includeEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "excludeDN", String.valueOf(dN)));
        if (!this.excludeBranches.isEmpty()) {
            for (DN dN2 : this.excludeBranches) {
                if (!dN2.isAncestorOf(dN)) continue;
                return false;
            }
        }
        if (!this.includeBranches.isEmpty()) {
            for (DN dN2 : this.includeBranches) {
                if (!dN2.isAncestorOf(dN)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean includeObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "includeObjectClasses", new String[0]));
        return this.includeObjectClasses;
    }

    public void setIncludeObjectClasses(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeObjectClasses", String.valueOf(bl)));
        this.includeObjectClasses = bl;
    }

    public Set<AttributeType> getExcludeAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeAttributes", new String[0]));
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(Set<AttributeType> set) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeAttributes", String.valueOf(set)));
        this.excludeAttributes = set == null ? new HashSet<AttributeType>(0) : set;
    }

    public Set<AttributeType> getIncludeAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeAttributes", new String[0]));
        return this.includeAttributes;
    }

    public void setIncludeAttributes(Set<AttributeType> set) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeAttributes", String.valueOf(set)));
        this.includeAttributes = set == null ? new HashSet<AttributeType>(0) : set;
    }

    public boolean includeAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "includeAttribute", String.valueOf(attributeType)));
        if (!this.excludeAttributes.isEmpty() && this.excludeAttributes.contains(attributeType)) {
            return false;
        }
        if (!this.includeAttributes.isEmpty()) {
            return this.includeAttributes.contains(attributeType);
        }
        return true;
    }

    public List<SearchFilter> getExcludeFilters() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeFilters", new String[0]));
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeFilters", String.valueOf(list)));
        this.excludeFilters = list == null ? new ArrayList<SearchFilter>(0) : list;
    }

    public List<SearchFilter> getIncludeFilters() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeFilters", new String[0]));
        return this.includeFilters;
    }

    public void setIncludeFilters(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeFilters", String.valueOf(list)));
        this.includeFilters = list == null ? new ArrayList<SearchFilter>(0) : list;
    }

    public boolean includeEntry(Entry entry) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "includeEntry", String.valueOf(entry)));
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter searchFilter : this.excludeFilters) {
                if (!searchFilter.matchesEntry(entry)) continue;
                return false;
            }
        }
        if (!this.includeFilters.isEmpty()) {
            for (SearchFilter searchFilter : this.includeFilters) {
                if (!searchFilter.matchesEntry(entry)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int getBufferSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getBufferSize", new String[0]));
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setBufferSize", String.valueOf(n)));
        this.bufferSize = n;
    }

    public void close() {
        block7: {
            block6: {
                assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block6;
                    throw new AssertionError();
                }
            }
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }
}

