/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameForm {
    private static final String CLASS_NAME = "org.opends.server.types.NameForm";
    private boolean isObsolete;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties;
    private ConcurrentHashMap<String, String> names;
    private CopyOnWriteArraySet<AttributeType> optionalAttributes;
    private CopyOnWriteArraySet<AttributeType> requiredAttributes;
    private ObjectClass structuralClass;
    private String description;
    private String oid;
    private String schemaFile;

    public NameForm(ConcurrentHashMap<String, String> concurrentHashMap, String string, String string2, boolean bl, ObjectClass objectClass, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2, ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(concurrentHashMap), String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(objectClass), String.valueOf(copyOnWriteArraySet), String.valueOf(copyOnWriteArraySet2), String.valueOf(concurrentHashMap2)));
        this.names = concurrentHashMap;
        this.oid = string;
        this.description = string2;
        this.isObsolete = bl;
        this.structuralClass = objectClass;
        this.requiredAttributes = copyOnWriteArraySet;
        this.optionalAttributes = copyOnWriteArraySet2;
        this.schemaFile = null;
        this.extraProperties = concurrentHashMap2;
    }

    public ConcurrentHashMap<String, String> getNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNames", new String[0]));
        return this.names;
    }

    public void setNames(ConcurrentHashMap<String, String> concurrentHashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "setNames", String.valueOf(concurrentHashMap)));
        this.names = concurrentHashMap;
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public void addName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addName", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        this.names.put(string2, string);
    }

    public void removeName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeName", String.valueOf(string)));
        this.names.remove(string);
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public String getNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrOID", new String[0]));
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.values().iterator().next();
    }

    public boolean hasNameOrOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasNameOrOID", String.valueOf(string)));
        if (this.names.containsKey(string)) {
            return true;
        }
        return string.equals(this.oid);
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaFile", String.valueOf(string)));
        this.schemaFile = string;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public void setDescription(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setDescription", String.valueOf(string)));
        this.description = string;
    }

    public ObjectClass getStructuralClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getStructuralClass", new String[0]));
        return this.structuralClass;
    }

    public void setStructuralClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "setStructuralClass", String.valueOf(objectClass)));
        this.structuralClass = objectClass;
    }

    public CopyOnWriteArraySet<AttributeType> getRequiredAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributes", new String[0]));
        return this.requiredAttributes;
    }

    public boolean isRequired(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequired", String.valueOf(attributeType)));
        return this.requiredAttributes.contains(attributeType);
    }

    public void setRequiredAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequiredAttributes", String.valueOf(copyOnWriteArraySet)));
        this.requiredAttributes = copyOnWriteArraySet;
    }

    public void addRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.add(attributeType);
    }

    public void removeRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.remove(attributeType);
    }

    public CopyOnWriteArraySet<AttributeType> getOptionalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributes", new String[0]));
        return this.optionalAttributes;
    }

    public boolean isOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isOptional", String.valueOf(attributeType)));
        return this.optionalAttributes.contains(attributeType);
    }

    public void setOptionalAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setOptionalAttributes", String.valueOf(copyOnWriteArraySet)));
        this.optionalAttributes = copyOnWriteArraySet;
    }

    public void addOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.add(attributeType);
    }

    public void removeOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.remove(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequiredOrOptional", String.valueOf(attributeType)));
        return this.requiredAttributes.contains(attributeType) || this.optionalAttributes.contains(attributeType);
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public void setObsolete(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setObsolete", String.valueOf(bl)));
        this.isObsolete = bl;
    }

    public ConcurrentHashMap<String, CopyOnWriteArrayList<String>> getExtraProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperties", new String[0]));
        return this.extraProperties;
    }

    public CopyOnWriteArrayList<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof NameForm)) {
            return false;
        }
        return this.oid.equals(((NameForm)object).oid);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.oid.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.oid.charAt(i);
        }
        return n2;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        String string2;
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            string2 = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(string2);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" OC ");
        stringBuilder.append(this.structuralClass.getNameOrOID());
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MUST ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MUST ");
                stringBuilder.append(string2);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MAY ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MAY ");
                stringBuilder.append(string2);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String string2 : this.extraProperties.keySet()) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = this.extraProperties.get(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string2);
                if (copyOnWriteArrayList.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append(copyOnWriteArrayList.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string3 : copyOnWriteArrayList) {
                    stringBuilder.append("'");
                    stringBuilder.append(string3);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        if (bl && this.schemaFile != null && !this.extraProperties.containsKey("X-SCHEMA-FILE")) {
            stringBuilder.append(" ");
            stringBuilder.append("X-SCHEMA-FILE");
            stringBuilder.append(" '");
            stringBuilder.append(this.schemaFile);
            stringBuilder.append("'");
        }
        stringBuilder.append(" )");
    }
}

