/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser {
    private Argument usageArgument;
    private ArrayList<String> trailingArguments;
    private boolean allowsTrailingArguments;
    private boolean longArgumentsCaseSensitive;
    private HashMap<Character, Argument> shortIDMap;
    private HashMap<String, Argument> argumentMap;
    private HashMap<String, Argument> longIDMap;
    private int maxTrailingArguments;
    private int minTrailingArguments;
    private LinkedList<Argument> argumentList;
    private OutputStream usageOutputStream;
    private String mainClassName;
    private String trailingArgsDisplayName;
    private String[] rawArguments;

    public ArgumentParser(String string, boolean bl) {
        this.mainClassName = string;
        this.longArgumentsCaseSensitive = bl;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.allowsTrailingArguments = false;
        this.trailingArgsDisplayName = null;
        this.maxTrailingArguments = 0;
        this.minTrailingArguments = 0;
        this.trailingArguments = new ArrayList();
        this.rawArguments = null;
        this.usageArgument = null;
        this.usageOutputStream = System.out;
    }

    public ArgumentParser(String string, boolean bl, boolean bl2, int n, int n2, String string2) {
        this.mainClassName = string;
        this.longArgumentsCaseSensitive = bl;
        this.allowsTrailingArguments = bl2;
        this.minTrailingArguments = n;
        this.maxTrailingArguments = n2;
        this.trailingArgsDisplayName = string2;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.trailingArguments = new ArrayList();
        this.rawArguments = null;
        this.usageArgument = null;
        this.usageOutputStream = System.out;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArguments;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArguments;
    }

    public LinkedList<Argument> getArgumentList() {
        return this.argumentList;
    }

    public Argument getArgument(String string) {
        return this.argumentMap.get(string);
    }

    public HashMap<Character, Argument> getArgumentsByShortID() {
        return this.shortIDMap;
    }

    public Argument getArgumentForShortID(Character c) {
        return this.shortIDMap.get(c);
    }

    public HashMap<String, Argument> getArgumentsByLongID() {
        return this.longIDMap;
    }

    public Argument getArgumentForLongID(String string) {
        return this.longIDMap.get(string);
    }

    public ArrayList<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    public String[] getRawArguments() {
        return this.rawArguments;
    }

    public void addArgument(Argument argument) throws ArgumentException {
        Character c = argument.getShortIdentifier();
        if (c != null && this.shortIDMap.containsKey(c)) {
            String string = this.shortIDMap.get(c).getName();
            int n = 5505077;
            String string2 = MessageHandler.getMessage(n, argument.getName(), String.valueOf(c), string);
            throw new ArgumentException(n, string2);
        }
        String string = argument.getLongIdentifier();
        if (string != null) {
            if (!this.longArgumentsCaseSensitive) {
                string = StaticUtils.toLowerCase(string);
            }
            if (this.longIDMap.containsKey(string)) {
                String string3 = this.longIDMap.get(string).getName();
                int n = 5505078;
                String string4 = MessageHandler.getMessage(n, argument.getName(), String.valueOf(string), string3);
                throw new ArgumentException(n, string4);
            }
        }
        if (c != null) {
            this.shortIDMap.put(c, argument);
        }
        if (string != null) {
            this.longIDMap.put(string, argument);
        }
        this.argumentList.add(argument);
    }

    public void setUsageArgument(Argument argument) {
        this.usageArgument = argument;
        this.usageOutputStream = System.out;
    }

    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    public void parseArguments(String[] stringArray) throws ArgumentException {
        this.parseArguments(stringArray, null);
    }

    public void parseArguments(String[] stringArray, String string, boolean bl) throws ArgumentException {
        Properties properties;
        block2: {
            this.rawArguments = stringArray;
            properties = null;
            try {
                Properties properties2 = new Properties();
                FileInputStream fileInputStream = new FileInputStream(string);
                properties2.load(fileInputStream);
                fileInputStream.close();
                properties = properties2;
            }
            catch (Exception exception) {
                if (!bl) break block2;
                int n = 5505079;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string), StaticUtils.stackTraceToSingleLineString(exception));
                throw new ArgumentException(n, string2, exception);
            }
        }
        this.parseArguments(stringArray, properties);
    }

    public void parseArguments(String[] stringArray, Properties properties) throws ArgumentException {
        String string;
        int n;
        this.rawArguments = stringArray;
        boolean bl = false;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            Object object;
            String object3 = stringArray[n];
            if (bl) {
                this.trailingArguments.add(object3);
                if (this.maxTrailingArguments <= 0 || this.trailingArguments.size() <= this.maxTrailingArguments) continue;
                int c2 = 5505080;
                string = MessageHandler.getMessage(c2, this.maxTrailingArguments);
                throw new ArgumentException(c2, string);
            }
            if (object3.equals("--")) {
                bl = true;
                continue;
            }
            if (object3.startsWith("--")) {
                Argument n11;
                String n17 = object3.substring(2);
                string = null;
                int n3 = n17.indexOf(61);
                if (n3 >= 0) {
                    if (n3 == 0) {
                        int exception = 5505081;
                        String n7 = MessageHandler.getMessage(exception, object3);
                        throw new ArgumentException(exception, n7);
                    }
                    string = n17.substring(n3 + 1);
                    n17 = n17.substring(0, n3);
                }
                if (!this.longArgumentsCaseSensitive) {
                    n17 = StaticUtils.toLowerCase(n17);
                }
                if ((n11 = this.longIDMap.get(n17)) == null) {
                    int stringBuilder = 5505082;
                    String string9 = MessageHandler.getMessage(stringBuilder, n17);
                    throw new ArgumentException(stringBuilder, string9);
                }
                n11.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(n11.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception n8) {
                        // empty catch block
                    }
                    return;
                }
                if (n11.needsValue()) {
                    StringBuilder string8;
                    if (string == null) {
                        if (n + 1 == n2) {
                            int string7 = 5505083;
                            String string10 = MessageHandler.getMessage(string7, n17);
                            throw new ArgumentException(string7, string10);
                        }
                        string = stringArray[++n];
                    }
                    if (!n11.valueIsAcceptable(string, string8 = new StringBuilder())) {
                        int n4 = 5505084;
                        object = MessageHandler.getMessage(n4, string, n17, string8.toString());
                        throw new ArgumentException(n4, (String)object);
                    }
                    if (n11.hasValue() && !n11.isMultiValued()) {
                        int n5 = 5505085;
                        object = MessageHandler.getMessage(n5, n17);
                        throw new ArgumentException(n5, (String)object);
                    }
                    n11.addValue(string);
                    continue;
                }
                if (string == null) continue;
                int n12 = 5505086;
                String string2 = MessageHandler.getMessage(n12, n17);
                throw new ArgumentException(n12, string2);
            }
            if (object3.startsWith("-")) {
                if (object3.equals("-")) {
                    int bl2 = 5505087;
                    string = MessageHandler.getMessage(bl2);
                    throw new ArgumentException(bl2, string);
                }
                char c = object3.charAt(1);
                string = object3.length() > 2 ? object3.substring(2) : null;
                Argument argument = this.shortIDMap.get(Character.valueOf(c));
                if (argument == null) {
                    int stringBuilder = 0x540040;
                    String n13 = MessageHandler.getMessage(stringBuilder, String.valueOf(c));
                    throw new ArgumentException(stringBuilder, n13);
                }
                argument.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(argument.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception n14) {
                        // empty catch block
                    }
                    return;
                }
                if (argument.needsValue()) {
                    StringBuilder stringBuilder;
                    if (string == null) {
                        if (n + 1 == n2) {
                            int n6 = 5505089;
                            String i = MessageHandler.getMessage(n6, String.valueOf(c));
                            throw new ArgumentException(n6, i);
                        }
                        string = stringArray[++n];
                    }
                    if (!argument.valueIsAcceptable(string, stringBuilder = new StringBuilder())) {
                        int n7 = 5505090;
                        String string3 = MessageHandler.getMessage(n7, string, String.valueOf(c), stringBuilder.toString());
                        throw new ArgumentException(n7, string3);
                    }
                    if (argument.hasValue() && !argument.isMultiValued()) {
                        int n8 = 5505091;
                        String string4 = MessageHandler.getMessage(n8, String.valueOf(c));
                        throw new ArgumentException(n8, string4);
                    }
                    argument.addValue(string);
                    continue;
                }
                if (string == null) continue;
                int n9 = string.length();
                for (int i = 0; i < n9; ++i) {
                    char string6 = string.charAt(i);
                    object = this.shortIDMap.get(Character.valueOf(string6));
                    if (object == null) {
                        int n10 = 0x540040;
                        String string5 = MessageHandler.getMessage(n10, String.valueOf(c));
                        throw new ArgumentException(n10, string5);
                    }
                    if (((Argument)object).needsValue()) {
                        int n11 = 0x540044;
                        String string7 = MessageHandler.getMessage(n11, String.valueOf(c), string, String.valueOf(string6));
                        throw new ArgumentException(n11, string7);
                    }
                    ((Argument)object).setPresent(true);
                    if (this.usageArgument == null || !this.usageArgument.getName().equals(((Argument)object).getName())) continue;
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                continue;
            }
            if (this.allowsTrailingArguments) {
                bl = true;
                this.trailingArguments.add(object3);
                continue;
            }
            int n12 = 0x540045;
            string = MessageHandler.getMessage(n12, object3);
            throw new ArgumentException(n12, string);
        }
        if (this.allowsTrailingArguments && this.minTrailingArguments > 0 && this.trailingArguments.size() < this.minTrailingArguments) {
            n = 5505094;
            String string8 = MessageHandler.getMessage(n, this.minTrailingArguments);
            throw new ArgumentException(n, string8);
        }
        for (Argument argument : this.argumentList) {
            if (argument.isPresent() || !argument.needsValue()) continue;
            boolean bl2 = false;
            if (properties != null && argument.getPropertyName() != null && (string = properties.getProperty(argument.getPropertyName())) != null) {
                argument.addValue(string);
                bl2 = true;
            }
            if (!bl2 && argument.getDefaultValue() != null) {
                argument.addValue(argument.getDefaultValue());
                bl2 = true;
            }
            if (bl2 || !argument.isRequired()) continue;
            int n13 = 5505095;
            String string9 = MessageHandler.getMessage(n13, argument.getName());
            throw new ArgumentException(n13, string9);
        }
    }

    public void getUsage(StringBuilder stringBuilder) {
        stringBuilder.append("Usage:  java ");
        stringBuilder.append(this.mainClassName);
        stringBuilder.append(" {options}");
        if (this.allowsTrailingArguments) {
            if (this.trailingArgsDisplayName == null) {
                stringBuilder.append(" {trailing-arguments}");
            } else {
                stringBuilder.append(" ");
                stringBuilder.append(this.trailingArgsDisplayName);
            }
        }
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("             where {options} include:");
        stringBuilder.append(ServerConstants.EOL);
        for (Argument argument : this.argumentList) {
            String string;
            String string2;
            if (argument.isHidden()) continue;
            Character c = argument.getShortIdentifier();
            if (c != null) {
                int n = stringBuilder.length();
                stringBuilder.append("-");
                stringBuilder.append(c.charValue());
                if (argument.needsValue()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(argument.getValuePlaceholder());
                }
                if ((string2 = argument.getLongIdentifier()) != null) {
                    int n2;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("or   --");
                    stringBuilder2.append(string2);
                    if (argument.needsValue()) {
                        stringBuilder2.append(" ");
                        stringBuilder2.append(argument.getValuePlaceholder());
                    }
                    if ((n2 = stringBuilder.length() - n + 2 + stringBuilder2.length()) > 80) {
                        stringBuilder.append(ServerConstants.EOL);
                        stringBuilder.append(stringBuilder2.toString());
                    } else {
                        stringBuilder.append("  ");
                        stringBuilder.append(stringBuilder2.toString());
                    }
                }
                stringBuilder.append(ServerConstants.EOL);
            } else {
                string = argument.getLongIdentifier();
                if (string != null) {
                    stringBuilder.append("--");
                    stringBuilder.append(string);
                    if (argument.needsValue()) {
                        stringBuilder.append(" ");
                        stringBuilder.append(argument.getValuePlaceholder());
                    }
                    stringBuilder.append(ServerConstants.EOL);
                }
            }
            string = argument.getDescription();
            if (string.length() <= 74) {
                stringBuilder.append("     ");
                stringBuilder.append(string);
                stringBuilder.append(ServerConstants.EOL);
            } else {
                string2 = string;
                while (string2.length() > 74) {
                    int n = string2.lastIndexOf(32, 74);
                    if (n > 0) {
                        stringBuilder.append("     ");
                        stringBuilder.append(string2.substring(0, n).trim());
                        string2 = string2.substring(n + 1).trim();
                        stringBuilder.append(ServerConstants.EOL);
                        continue;
                    }
                    n = string2.indexOf(32);
                    if (n > 0) {
                        stringBuilder.append("     ");
                        stringBuilder.append(string2.substring(0, n).trim());
                        string2 = string2.substring(n + 1).trim();
                        stringBuilder.append(ServerConstants.EOL);
                        continue;
                    }
                    stringBuilder.append("     ");
                    stringBuilder.append(string2);
                    string2 = "";
                    stringBuilder.append(ServerConstants.EOL);
                }
                if (string2.length() > 0) {
                    stringBuilder.append("     ");
                    stringBuilder.append(string2);
                    stringBuilder.append(ServerConstants.EOL);
                }
            }
            stringBuilder.append(ServerConstants.EOL);
        }
    }

    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getUsage(stringBuilder);
        return stringBuilder.toString();
    }

    public void getUsage(OutputStream outputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.getUsage(stringBuilder);
        outputStream.write(StaticUtils.getBytes(stringBuilder.toString()));
    }
}

