/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.HashSet;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceArgument
extends Argument {
    private boolean caseSensitive;
    private HashSet<String> allowedValues;

    public MultiChoiceArgument(String string, Character c, String string2, boolean bl, boolean bl2, String string3, HashSet<String> hashSet, boolean bl3, int n, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, false, bl2, string3, null, null, n, objectArray);
        this.allowedValues = hashSet;
        this.caseSensitive = bl3;
    }

    public MultiChoiceArgument(String string, Character c, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, HashSet<String> hashSet, boolean bl4, int n, Object ... objectArray) throws ArgumentException {
        super(string, c, string2, bl, bl2, bl3, string3, string4, string5, n, objectArray);
        this.allowedValues = hashSet;
        this.caseSensitive = bl4;
    }

    public HashSet<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean valueIsAcceptable(String string, StringBuilder stringBuilder) {
        if (this.caseSensitive) {
            if (!this.allowedValues.contains(string)) {
                int n = 5505071;
                stringBuilder.append(MessageHandler.getMessage(n, this.getName(), string));
                return false;
            }
        } else if (!this.allowedValues.contains(StaticUtils.toLowerCase(string))) {
            int n = 5505071;
            stringBuilder.append(MessageHandler.getMessage(n, this.getName(), string));
            return false;
        }
        return true;
    }
}

