/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support.finder;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.VersionConstraints;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.support.finder.PolicyCollection;
import com.sun.xacml.support.finder.PolicyReader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticRefPolicyFinderModule
extends PolicyFinderModule {
    private List policyList;
    private PolicyCollection policies;
    private File schemaFile = null;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$support$finder$StaticRefPolicyFinderModule == null ? (class$com$sun$xacml$support$finder$StaticRefPolicyFinderModule = StaticRefPolicyFinderModule.class$("com.sun.xacml.support.finder.StaticRefPolicyFinderModule")) : class$com$sun$xacml$support$finder$StaticRefPolicyFinderModule).getName());
    static /* synthetic */ Class class$com$sun$xacml$support$finder$StaticRefPolicyFinderModule;

    public StaticRefPolicyFinderModule(List policyList) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticRefPolicyFinderModule(List policyList, String schemaFile) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        Iterator it = this.policyList.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            AbstractPolicy policy = null;
            try {
                try {
                    URL url = new URL(str);
                    policy = reader.readPolicy(url);
                }
                catch (MalformedURLException murle) {
                    policy = reader.readPolicy(new File(str));
                }
                if (this.policies.addPolicy(policy) || !logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "tried to load the same policy multiple times: " + str);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy: " + str, pe);
            }
        }
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy = this.policies.getPolicy(idReference.toString(), type, constraints);
        if (policy == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

