/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.mailer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePartDataSource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.mailer.MailAuthenticator;

public class MailTag
extends BodyTagSupport {
    protected static final String TO_ADDRESS_STRING = "to";
    protected static final String CC_ADDRESS_STRING = "cc";
    protected static final String BCC_ADDRESS_STRING = "bcc";
    protected static final int TO_ADDRESS = 1;
    protected static final int CC_ADDRESS = 2;
    protected static final int BCC_ADDRESS = 3;
    private String to = null;
    private StringBuffer addTO = new StringBuffer();
    private String from = null;
    private String reset_from = null;
    private String cc = null;
    private StringBuffer addCC = new StringBuffer();
    private String bcc = null;
    private StringBuffer addBCC = new StringBuffer();
    private String subject = "";
    private String reset_subject;
    private String body = null;
    private String server = "localhost";
    private String reset_server = null;
    private String type = "text/plain";
    private String session = null;
    private String mimemessage = null;
    private String user = null;
    private String password = null;
    private Session sessionobj = null;
    private String replyto = null;
    private String reset_replyto = null;
    private ArrayList name = new ArrayList(10);
    private ArrayList value = new ArrayList(10);
    private ArrayList bodyparts = new ArrayList(10);
    private boolean attachments = false;
    private boolean error = false;
    private boolean authentication = false;

    public final int doStartTag() throws JspException {
        this.addTO.setLength(0);
        if (this.to != null) {
            this.addTO.append(this.to);
        }
        this.addCC.setLength(0);
        if (this.cc != null) {
            this.addCC.append(this.cc);
        }
        this.addBCC.setLength(0);
        if (this.bcc != null) {
            this.addBCC.append(this.bcc);
        }
        this.reset_from = null;
        this.reset_replyto = null;
        this.reset_subject = null;
        this.reset_server = null;
        this.name.clear();
        this.value.clear();
        this.bodyparts.clear();
        this.attachments = false;
        this.sessionobj = null;
        return 2;
    }

    public final int doEndTag() throws JspException {
        if (this.bodyContent.getString().trim().length() == 0) {
            return 6;
        }
        try {
            ((TagSupport)this).pageContext.getOut().write(this.bodyContent.getString());
        }
        catch (IOException ie) {
            ((TagSupport)this).pageContext.getServletContext().log("Mailer taglib: Error tag: unable to write out to jsp.");
        }
        return 5;
    }

    public final MimeMessage getMessage() throws JspException {
        MimeMessage message;
        if (this.mimemessage != null) {
            try {
                InitialContext ctx = new InitialContext();
                MimePartDataSource mds = (MimePartDataSource)ctx.lookup(this.mimemessage);
                this.sessionobj = mds.getMessageContext().getSession();
                message = new MimeMessage(this.sessionobj);
            }
            catch (NamingException ne) {
                throw new JspException("Naming Exception " + ne.getExplanation());
            }
        } else if (this.session != null) {
            try {
                InitialContext ctx = new InitialContext();
                this.sessionobj = (Session)ctx.lookup(this.session);
                message = new MimeMessage(this.sessionobj);
            }
            catch (NamingException ne) {
                throw new JspException("Naming Exception " + ne.getExplanation());
            }
        } else {
            Properties props = new Properties();
            if (this.reset_server != null) {
                ((Hashtable)props).put("mail.smtp.host", this.reset_server);
            } else {
                ((Hashtable)props).put("mail.smtp.host", this.server);
            }
            ((Hashtable)props).put("mail.smtp.sendpartial", "true");
            ((Hashtable)props).put("mail.smtp.dsn.notify", "FAILURE");
            ((Hashtable)props).put("mail.smtp.dsn.ret", "FULL");
            if (this.authentication) {
                ((Hashtable)props).put("mail.smtp.auth", "true");
                this.sessionobj = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(this.user, this.password));
            } else {
                this.sessionobj = Session.getDefaultInstance((Properties)props, null);
            }
            message = new MimeMessage(this.sessionobj);
        }
        return message;
    }

    public final ArrayList getBodyParts() {
        return this.bodyparts;
    }

    public final boolean getAttachments() {
        return this.attachments;
    }

    public final String getTo() {
        if (this.addTO.length() > 0) {
            return this.addTO.toString();
        }
        return null;
    }

    public final String getReplyTo() {
        if (this.reset_replyto != null) {
            return this.reset_replyto;
        }
        return this.replyto;
    }

    public final String getFrom() {
        if (this.reset_from != null) {
            return this.reset_from;
        }
        return this.from;
    }

    public final String getCc() {
        if (this.addCC.length() > 0) {
            return this.addCC.toString();
        }
        return null;
    }

    public final String getBcc() {
        if (this.addBCC.length() > 0) {
            return this.addBCC.toString();
        }
        return null;
    }

    public final String getSubject() {
        if (this.reset_subject != null) {
            return this.reset_subject;
        }
        return this.subject;
    }

    public final ArrayList getHeaderName() {
        return this.name;
    }

    public final ArrayList getHeaderValue() {
        return this.value;
    }

    public final String getBody() {
        return this.body;
    }

    public final Session getSessionObj() {
        return this.sessionobj;
    }

    public final String getType() {
        return this.type;
    }

    public final void setError(boolean value) {
        this.error = value;
    }

    public final void setTo(String value) {
        this.to = value;
    }

    public final void setReplyTo(String value) {
        this.replyto = value;
    }

    public final void setFrom(String value) {
        this.from = value;
    }

    public final void setCc(String value) {
        this.cc = value;
    }

    public final void setBcc(String value) {
        this.bcc = value;
    }

    public final void setSubject(String value) {
        this.subject = value;
    }

    protected final void setHeader(String name, String value) {
        this.name.add(name);
        this.value.add(value);
    }

    public final void setMessage(String value) {
        this.body = value;
    }

    public final void setBodyParts(MimeBodyPart mbp) {
        this.bodyparts.add(mbp);
        if (!this.attachments) {
            this.attachments = true;
        }
    }

    public final void setUser(String value) {
        this.user = value;
    }

    public final void setPassword(String value) {
        this.password = value;
    }

    public final void setServer(String value) {
        this.server = value;
    }

    public final void setMimeMessage(String value) {
        this.mimemessage = value;
    }

    public final void setSession(String value) {
        this.session = value;
    }

    public final void setAuthenticate(String value) {
        this.authentication = new Boolean(value);
    }

    public final void setType(String value) {
        this.type = value.equalsIgnoreCase("html") ? "text/html" : "text/plain";
    }

    protected final void addTo(String value) {
        if (this.addTO.length() > 0) {
            this.addTO.append(",");
        }
        this.addTO.append(value);
    }

    protected final void addCc(String value) {
        if (this.addCC.length() > 0) {
            this.addCC.append(",");
        }
        this.addCC.append(value);
    }

    protected final void addBcc(String value) {
        if (this.addBCC.length() > 0) {
            this.addBCC.append(",");
        }
        this.addBCC.append(value);
    }

    protected final void resetTo(String value) {
        this.addTO.setLength(0);
        this.addTO.append(value);
    }

    protected final void resetCc(String value) {
        this.addCC.setLength(0);
        this.addCC.append(value);
    }

    protected final void resetBcc(String value) {
        this.addBCC.setLength(0);
        this.addBCC.append(value);
    }

    protected final void resetFrom(String value) {
        this.reset_from = value;
    }

    protected final void resetReplyTo(String value) {
        this.reset_replyto = value;
    }

    protected final void resetSubject(String value) {
        this.reset_subject = value;
    }

    protected final void resetServer(String value) {
        this.reset_server = value;
    }
}

