/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluator;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.apache.taglibs.standard.resources.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class JstlBaseTLV
extends TagLibraryValidator {
    private final String EXP_ATT_PARAM = "expressionAttributes";
    protected static final String VAR = "var";
    protected static final String SCOPE = "scope";
    protected static final String PAGE_SCOPE = "page";
    protected static final String REQUEST_SCOPE = "request";
    protected static final String SESSION_SCOPE = "session";
    protected static final String APPLICATION_SCOPE = "application";
    protected final String JSP = "http://java.sun.com/JSP/Page";
    private final String CORE_EL = "http://java.sun.com/jstl/core";
    private final String FMT_EL = "http://java.sun.com/jstl/fmt";
    private final String SQL_EL = "http://java.sun.com/jstl/sql";
    private final String XML_EL = "http://java.sun.com/jstl/xml";
    private final String CORE_RT = "http://java.sun.com/jstl/core_rt";
    private final String FMT_RT = "http://java.sun.com/jstl/fmt_rt";
    private final String SQL_RT = "http://java.sun.com/jstl/sql_rt";
    private final String XML_RT = "http://java.sun.com/jstl/xml_rt";
    protected String prefix;
    protected Vector messageVector;
    protected Map config;
    protected boolean failed;
    protected String lastElementId;

    protected abstract DefaultHandler getHandler();

    public JstlBaseTLV() {
        this.init();
    }

    private void init() {
        this.messageVector = null;
        this.prefix = null;
        this.config = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public synchronized ValidationMessage[] validate(String prefix, String uri, PageData page) {
        try {
            this.messageVector = new Vector();
            this.prefix = prefix;
            try {
                if (this.config == null) {
                    this.configure((String)this.getInitParameters().get("expressionAttributes"));
                }
            }
            catch (NoSuchElementException ex) {
                return JstlBaseTLV.vmFromString(Resources.getMessage("TLV_PARAMETER_ERROR", "expressionAttributes"));
            }
            DefaultHandler h = this.getHandler();
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(false);
            f.setNamespaceAware(true);
            SAXParser p = f.newSAXParser();
            p.parse(page.getInputStream(), h);
            if (this.messageVector.size() == 0) {
                return null;
            }
            return JstlBaseTLV.vmFromVector(this.messageVector);
        }
        catch (SAXException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
        catch (ParserConfigurationException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
        catch (IOException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
    }

    protected String validateExpression(String elem, String att, String expr) {
        ExpressionEvaluator current;
        try {
            current = ExpressionEvaluatorManager.getEvaluatorByName("org.apache.taglibs.standard.lang.jstl.Evaluator");
        }
        catch (JspException ex) {
            return ex.getMessage();
        }
        String response = current.validate(att, expr);
        if (response == null) {
            return response;
        }
        return "tag = '" + elem + "' / attribute = '" + att + "': " + response;
    }

    protected boolean isTag(String tagUri, String tagLn, String matchUri, String matchLn) {
        if (tagUri == null || tagLn == null || matchUri == null || matchLn == null) {
            return false;
        }
        return tagUri.equals(matchUri) && tagLn.equals(matchLn);
    }

    protected boolean isJspTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/JSP/Page", target);
    }

    protected boolean isCoreTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/core", target) || this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/core_rt", target);
    }

    protected boolean isFmtTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/fmt", target) || this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/fmt_rt", target);
    }

    protected boolean isSqlTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/sql", target) || this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/sql_rt", target);
    }

    protected boolean isXmlTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/xml", target) || this.isTag(tagUri, tagLn, "http://java.sun.com/jstl/xml_rt", target);
    }

    protected boolean hasAttribute(Attributes a, String att) {
        return a.getValue(att) != null;
    }

    protected void fail(String message) {
        this.failed = true;
        this.messageVector.add(new ValidationMessage(this.lastElementId, message));
    }

    protected boolean isSpecified(TagData data, String attributeName) {
        return data.getAttribute(attributeName) != null;
    }

    protected boolean hasNoInvalidScope(Attributes a) {
        String scope = a.getValue(SCOPE);
        return scope == null || scope.equals(PAGE_SCOPE) || scope.equals(REQUEST_SCOPE) || scope.equals(SESSION_SCOPE) || scope.equals(APPLICATION_SCOPE);
    }

    protected boolean hasEmptyVar(Attributes a) {
        return "".equals(a.getValue(VAR));
    }

    protected boolean hasDanglingScope(Attributes a) {
        return a.getValue(SCOPE) != null && a.getValue(VAR) == null;
    }

    protected String getLocalPart(String qname) {
        int colon = qname.indexOf(":");
        if (colon == -1) {
            return qname;
        }
        return qname.substring(colon + 1);
    }

    private void configure(String info) {
        this.config = new HashMap();
        if (info == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(info);
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            StringTokenizer pairTokens = new StringTokenizer(pair, ":");
            String element = pairTokens.nextToken();
            String attribute = pairTokens.nextToken();
            Object atts = this.config.get(element);
            if (atts == null) {
                atts = new HashSet();
                this.config.put(element, atts);
            }
            ((Set)atts).add(attribute);
        }
    }

    static ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    static ValidationMessage[] vmFromVector(Vector v) {
        ValidationMessage[] vm = new ValidationMessage[v.size()];
        int i = 0;
        while (i < vm.length) {
            vm[i] = (ValidationMessage)v.get(i);
            ++i;
        }
        return vm;
    }

    static {
        VAR = VAR;
        SCOPE = SCOPE;
        PAGE_SCOPE = PAGE_SCOPE;
        REQUEST_SCOPE = REQUEST_SCOPE;
        SESSION_SCOPE = SESSION_SCOPE;
        APPLICATION_SCOPE = APPLICATION_SCOPE;
    }
}

