/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.adapter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.taglibs.standard.lang.jpath.adapter.CollectionAdapter;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.GregorianCalendarAdapter;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPList;

public class Convert {
    public static Double toDouble(Object o) throws ConversionException {
        Double converted = (o = Convert.performBasicConversions(o)) == null ? new Double(Double.NaN) : (o instanceof Boolean ? Convert.toDouble((Boolean)o) : (o instanceof Double ? Convert.toDouble((Double)o) : (o instanceof String ? Convert.toDouble((String)o) : (o instanceof JSPDate ? Convert.toDouble((JSPDate)o) : (o instanceof JSPList ? Convert.toDouble((JSPList)o) : Convert.toDouble(Convert.toString(o)))))));
        return converted;
    }

    private static Double toDouble(Boolean b) throws ConversionException {
        Double converted = b == true ? new Double(1.0) : new Double(0.0);
        return converted;
    }

    private static Double toDouble(Double d) throws ConversionException {
        return d;
    }

    private static Double toDouble(String s) throws ConversionException {
        Double converted;
        try {
            converted = Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            converted = new Double(Double.NaN);
        }
        return converted;
    }

    private static Double toDouble(JSPDate d) throws ConversionException {
        Double converted = d.getTime();
        return converted;
    }

    private static Double toDouble(JSPList list) throws ConversionException {
        Double converted = Convert.toDouble(Convert.toString(list));
        return converted;
    }

    public static Boolean toBoolean(Object o) throws ConversionException {
        Boolean converted = (o = Convert.performBasicConversions(o)) == null ? Boolean.FALSE : (o instanceof Boolean ? Convert.toBoolean((Boolean)o) : (o instanceof Double ? Convert.toBoolean((Double)o) : (o instanceof String ? Convert.toBoolean((String)o) : (o instanceof JSPDate ? Convert.toBoolean((JSPDate)o) : (o instanceof JSPList ? Convert.toBoolean((JSPList)o) : Convert.toBoolean(Convert.toString(o)))))));
        return converted;
    }

    private static Boolean toBoolean(Boolean b) throws ConversionException {
        return b;
    }

    private static Boolean toBoolean(Double d) throws ConversionException {
        Boolean converted = d == null ? Boolean.FALSE : (!d.isNaN() && d != 0.0 && d != 0.0 ? Boolean.TRUE : Boolean.FALSE);
        return converted;
    }

    private static Boolean toBoolean(String s) throws ConversionException {
        Boolean converted = s == null ? Boolean.FALSE : (s.length() != 0 ? Boolean.TRUE : Boolean.FALSE);
        return converted;
    }

    private static Boolean toBoolean(JSPDate d) throws ConversionException {
        Boolean converted = Convert.toBoolean(Convert.toString(d));
        return converted;
    }

    private static Boolean toBoolean(JSPList list) throws ConversionException {
        Boolean converted;
        if (list == null || !list.hasNext()) {
            converted = Boolean.FALSE;
        } else {
            if (list.getPosition() != 0) {
                throw new ConversionException("cannot convert a list to a Boolean if the list is not at the starting position");
            }
            converted = Boolean.TRUE;
        }
        return converted;
    }

    public static String toString(Object o) throws ConversionException {
        String converted = (o = Convert.performBasicConversions(o)) == null ? new String("") : (o instanceof Boolean ? Convert.toString((Boolean)o) : (o instanceof Double ? Convert.toString((Double)o) : (o instanceof String ? Convert.toString((String)o) : (o instanceof JSPDate ? Convert.toString((JSPDate)o) : (o instanceof JSPList ? Convert.toString((JSPList)o) : o.toString())))));
        return converted;
    }

    private static String toString(Boolean b) throws ConversionException {
        return b.toString();
    }

    private static String toString(Double d) throws ConversionException {
        String converted;
        if (d == null || d.isNaN()) {
            converted = new String("NaN");
        } else if (d == 0.0 || d == 0.0) {
            converted = new String("0");
        } else if (d == Double.POSITIVE_INFINITY) {
            converted = new String("Infinity");
        } else if (d == Double.NEGATIVE_INFINITY) {
            converted = new String("-Infinity");
        } else if (Math.floor(d) == d) {
            NumberFormat form = NumberFormat.getInstance();
            try {
                ((DecimalFormat)form).applyPattern("#");
                converted = form.format(d);
            }
            catch (IllegalArgumentException iae) {
                converted = new String("NaN");
            }
        } else {
            converted = d.toString();
        }
        return converted;
    }

    private static String toString(String s) throws ConversionException {
        return s;
    }

    private static String toString(JSPDate d) throws ConversionException {
        String converted = DateFormat.getDateInstance().format(new Date(d.getTime().longValue()));
        return converted;
    }

    private static String toString(JSPList list) throws ConversionException {
        String converted;
        if (list == null || !list.hasNext()) {
            converted = "";
        } else {
            if (list.getPosition() != 0) {
                throw new ConversionException("cannot convert a list to a String if the list is not at the starting position");
            }
            converted = Convert.toString(list.next());
        }
        return converted;
    }

    public static JSPDate toJSPDate(Object o) throws ConversionException {
        if ((o = Convert.performBasicConversions(o)) == null) {
            throw new ConversionException("cannot convert null to a JSPDate");
        }
        if (!(o instanceof JSPDate)) {
            throw new ConversionException("Object [" + o + "] cannot be " + "converted to a JSPList");
        }
        JSPDate converted = Convert.toJSPDate((JSPDate)o);
        return converted;
    }

    private static JSPDate toJSPDate(JSPDate date) throws ConversionException {
        return date;
    }

    private static JSPDate toJSPDate(GregorianCalendar gc) throws ConversionException {
        return (JSPDate)GregorianCalendarAdapter.adapt(gc);
    }

    public static JSPList toJSPList(Object o) throws ConversionException {
        if ((o = Convert.performBasicConversions(o)) == null) {
            throw new ConversionException("cannot convert null to a JSPList");
        }
        if (!(o instanceof JSPList)) {
            throw new ConversionException("Object [" + o + "] cannot be " + "converted to a JSPList");
        }
        JSPList converted = Convert.toJSPList((JSPList)o);
        return converted;
    }

    private static JSPList toJSPList(JSPList list) throws ConversionException {
        return list;
    }

    private static Object performBasicConversions(Object o) {
        Object converted = o == null ? null : (o instanceof Short ? new Double(((Short)o).toString()) : (o instanceof Integer ? new Double(((Integer)o).toString()) : (o instanceof Float ? new Double(((Float)o).toString()) : (o instanceof Long ? new Double(((Long)o).toString()) : (o instanceof Byte ? new String(((Byte)o).toString()) : (o instanceof Character ? new String(((Character)o).toString()) : o))))));
        converted = Convert.toJSPType(converted);
        return converted;
    }

    public static Object toJSPType(Object o) {
        Object converted = o == null ? null : (o instanceof Collection ? CollectionAdapter.adapt(o) : (o instanceof GregorianCalendar ? GregorianCalendarAdapter.adapt(o) : o));
        return converted;
    }
}

