/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.cell.TextLinkCell;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.footer.CroppedMessage;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.util.DateUtil;
import tech.grasshopper.pdf.util.TextUtil;

public class ScenarioStepDetails
extends Display {
    private PaginationData paginationData;
    private Table.TableBuilder tableBuilder;
    private static final int TABLE_X_AXIS_START = 40;
    private static final int TABLE_Y_AXIS_START = 330;
    private static final PDFont HEADER_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int HEADER_FONT_SIZE = 12;
    private static final PDFont NAME_FONT = ReportFont.ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 11;
    private static final float FEATURE_NAME_COLUMN_WIDTH = 210.0f;
    private static final float SCENARIO_NAME_COLUMN_WIDTH = 310.0f;
    private static final float HEADER_PADDING = 7.0f;
    private static final float DATA_PADDING = 6.0f;
    public static final float TABLE_SPACE = 290.0f;
    public static final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(11).availableSpace(198.0f).maxLines(2).build();
    public static final TextLengthOptimizer scenarioNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(11).availableSpace(298.0f).maxLines(2).build();
    private static final String CROPPED_MESSAGE = "* The feature name and/or scenario name has been cropped to fit in the available space.";
    private boolean nameCropped;

    public static float headerRowHeight() {
        return TextUtil.builder().font(HEADER_FONT).fontSize(12).text("Scenario Name").width(310.0f).padding(7.0f).build().tableRowHeight();
    }

    public static TextUtil featureNameTextUtil() {
        return TextUtil.builder().font(NAME_FONT).fontSize(11).text("").width(210.0f).padding(6.0f).build();
    }

    public static TextUtil scenarioNameTextUtil() {
        return TextUtil.builder().font(NAME_FONT).fontSize(11).text("").width(310.0f).padding(6.0f).build();
    }

    @Override
    public void display() {
        this.createTableBuilder();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
        this.croppedMessageDisplay();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 210.0f, 310.0f, 30.0f, 30.0f, 30.0f, 30.0f, 95.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().padding(7.0f).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE).font(HEADER_FONT).fontSize(Integer.valueOf(12)).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Scenario Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Duration").textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
    }

    private void createDataRows() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        int sNo = this.paginationData.getItemFromIndex() + 1;
        ScenarioData scenarioData = (ScenarioData)this.displayData;
        List<Scenario> scenarios = scenarioData.getScenarios();
        for (int i = 0; i < scenarios.size(); ++i) {
            Scenario scenario = scenarios.get(i);
            String featureName = sanitizer.sanitizeText(featureNameTextOptimizer.optimizeTextLines(scenario.getFeature().getName()));
            String scenarioName = sanitizer.sanitizeText(scenarioNameTextOptimizer.optimizeTextLines(scenario.getName()));
            if (featureNameTextOptimizer.isTextTrimmed() || scenarioNameTextOptimizer.isTextTrimmed()) {
                this.nameCropped = true;
            }
            Annotation featureAnnotation = Annotation.builder().title(featureName).build();
            Annotation scenarioAnnotation = Annotation.builder().title(scenarioName).build();
            this.tableBuilder.addRow(Row.builder().padding(6.0f).font(NAME_FONT).fontSize(Integer.valueOf(11)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(sNo)).fontSize(Integer.valueOf(8))).build()).add(this.createNameCell(featureName, featureAnnotation)).add(this.createNameCell(scenarioName, scenarioAnnotation)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getTotalSteps())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getPassedSteps())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getFailedSteps())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(scenario.getSkippedSteps())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.durationValue(scenario.calculatedDuration())).textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
            scenario.getFeature().addAnnotation(featureAnnotation);
            scenario.addAnnotation(scenarioAnnotation);
            ++sNo;
        }
    }

    private void drawTable() {
        Object tableDrawer = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(this.tableBuilder)).document(this.document)).startX(40.0f)).startY(330.0f)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageSupplier())).build();
        ((TableCreator)tableDrawer).displayTable();
    }

    private AbstractCell createNameCell(String title, Annotation annotation) {
        if (this.reportConfig.isDisplayScenario() && this.reportConfig.isDisplayDetailed()) {
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).text(title)).horizontalAlignment(HorizontalAlignment.LEFT)).build();
        }
        return ((TextCell.TextCellBuilder)TextCell.builder().text(title).horizontalAlignment(HorizontalAlignment.LEFT)).build();
    }

    private void croppedMessageDisplay() {
        if (this.nameCropped) {
            CroppedMessage.builder().content(this.content).message(CROPPED_MESSAGE).build().displayMessage();
        }
    }

    protected ScenarioStepDetails(ScenarioStepDetailsBuilder<?, ?> b) {
        super(b);
        this.paginationData = ((ScenarioStepDetailsBuilder)b).paginationData;
        this.tableBuilder = ((ScenarioStepDetailsBuilder)b).tableBuilder;
        this.nameCropped = ((ScenarioStepDetailsBuilder)b).nameCropped;
    }

    public static ScenarioStepDetailsBuilder<?, ?> builder() {
        return new ScenarioStepDetailsBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioStepDetails)) {
            return false;
        }
        ScenarioStepDetails other = (ScenarioStepDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nameCropped != other.nameCropped) {
            return false;
        }
        PaginationData this$paginationData = this.paginationData;
        PaginationData other$paginationData = other.paginationData;
        if (this$paginationData == null ? other$paginationData != null : !((Object)this$paginationData).equals(other$paginationData)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.tableBuilder;
        Table.TableBuilder other$tableBuilder = other.tableBuilder;
        return !(this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioStepDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nameCropped ? 79 : 97);
        PaginationData $paginationData = this.paginationData;
        result = result * 59 + ($paginationData == null ? 43 : ((Object)$paginationData).hashCode());
        Table.TableBuilder $tableBuilder = this.tableBuilder;
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        return result;
    }

    private static final class ScenarioStepDetailsBuilderImpl
    extends ScenarioStepDetailsBuilder<ScenarioStepDetails, ScenarioStepDetailsBuilderImpl> {
        private ScenarioStepDetailsBuilderImpl() {
        }

        @Override
        protected ScenarioStepDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioStepDetails build() {
            return new ScenarioStepDetails(this);
        }
    }

    public static abstract class ScenarioStepDetailsBuilder<C extends ScenarioStepDetails, B extends ScenarioStepDetailsBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private PaginationData paginationData;
        private Table.TableBuilder tableBuilder;
        private boolean nameCropped;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B paginationData(PaginationData paginationData) {
            this.paginationData = paginationData;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B nameCropped(boolean nameCropped) {
            this.nameCropped = nameCropped;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioStepDetails.ScenarioStepDetailsBuilder(super=" + super.toString() + ", paginationData=" + this.paginationData + ", tableBuilder=" + this.tableBuilder + ", nameCropped=" + this.nameCropped + ")";
        }
    }
}

