/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.footer;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import tech.grasshopper.pdf.font.ReportFont;

public class CroppedMessage {
    private PDPageContentStream content;
    private String message;

    public void displayMessage() {
        PositionedStyledText textDetails = PositionedStyledText.builder().x(50.0f).y(20.0f).text(this.message).font(ReportFont.ITALIC_FONT).fontSize(11).color(Color.LIGHT_GRAY).build();
        DrawingUtil.drawText((PDPageContentStream)this.content, (PositionedStyledText)textDetails);
    }

    CroppedMessage(PDPageContentStream content, String message) {
        this.content = content;
        this.message = message;
    }

    public static CroppedMessageBuilder builder() {
        return new CroppedMessageBuilder();
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class CroppedMessageBuilder {
        private PDPageContentStream content;
        private String message;

        CroppedMessageBuilder() {
        }

        public CroppedMessageBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public CroppedMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public CroppedMessage build() {
            return new CroppedMessage(this.content, this.message);
        }

        public String toString() {
            return "CroppedMessage.CroppedMessageBuilder(content=" + this.content + ", message=" + this.message + ")";
        }
    }
}

