/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.gherkin.messages.internal.gherkin;

import io.cucumber.shaded.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AstNode {
    private final Map<Parser.RuleType, List<Object>> subItems = new HashMap<Parser.RuleType, List<Object>>();
    public final Parser.RuleType ruleType;

    public AstNode(Parser.RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public void add(Parser.RuleType ruleType, Object obj) {
        List<Object> items = this.subItems.get((Object)ruleType);
        if (items == null) {
            items = new ArrayList<Object>();
            this.subItems.put(ruleType, items);
        }
        items.add(obj);
    }

    public <T> T getSingle(Parser.RuleType ruleType, T defaultResult) {
        List<T> items = this.getItems(ruleType);
        return items.isEmpty() ? defaultResult : items.get(0);
    }

    public <T> List<T> getItems(Parser.RuleType ruleType) {
        List<Object> items = this.subItems.get((Object)ruleType);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public Token getToken(Parser.TokenType tokenType) {
        Parser.RuleType ruleType = Parser.RuleType.cast(tokenType);
        return this.getSingle(ruleType, new Token(null, null));
    }

    public List<Token> getTokens(Parser.TokenType tokenType) {
        return this.getItems(Parser.RuleType.cast(tokenType));
    }
}

