/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.gherkin.messages.internal.gherkin;

import io.cucumber.shaded.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.GherkinException;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.IGherkinDialectProvider;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.Location;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.Json;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.JsonObject;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GherkinDialectProvider
implements IGherkinDialectProvider {
    private static JsonObject DIALECTS;
    private final String defaultDialectName;
    public static final String JSON_PATH = "/io/cucumber/shaded/gherkin/messages/internal/gherkin/gherkin-languages.json";

    public GherkinDialectProvider(String defaultDialectName) {
        this.defaultDialectName = defaultDialectName;
    }

    public GherkinDialectProvider() {
        this("en");
    }

    @Override
    public GherkinDialect getDefaultDialect() {
        return this.getDialect(this.defaultDialectName, null);
    }

    @Override
    public GherkinDialect getDialect(String language, Location location) {
        JsonValue languageObject = DIALECTS.get(language);
        if (languageObject == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return new GherkinDialect(language, languageObject.asObject());
    }

    @Override
    public List<String> getLanguages() {
        ArrayList<String> languages = new ArrayList<String>(DIALECTS.names());
        Collections.sort(languages);
        return Collections.unmodifiableList(languages);
    }

    static {
        try (InputStreamReader reader = new InputStreamReader(GherkinDialectProvider.class.getResourceAsStream(JSON_PATH), StandardCharsets.UTF_8);){
            DIALECTS = Json.parse(reader).asObject();
        }
        catch (IOException e) {
            throw new GherkinException("Unable to parse /io/cucumber/gherkin/gherkin-languages.json", e);
        }
    }
}

