/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.config.external.JsonConfigLoader;
import com.aventstack.extentreports.config.external.XmlConfigLoader;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.AbstractFileReporter;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import com.aventstack.extentreports.reporter.ReporterFilterable;
import com.aventstack.extentreports.reporter.configuration.EntityFilters;
import com.aventstack.extentreports.reporter.configuration.ExtentHtmlReporterConfig;
import com.aventstack.extentreports.viewdefs.Icon;
import com.aventstack.extentreports.viewdefs.MaterialIcon;
import com.aventstack.extentreports.viewdefs.ReportUtils;
import com.aventstack.extentreports.viewdefs.TWBSColor;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentHtmlReporter
extends AbstractFileReporter
implements ReportObserver<ReportEntity>,
ReporterConfigurable,
ReporterFilterable<ExtentHtmlReporter> {
    private static final Logger logger = Logger.getLogger(ExtentHtmlReporter.class.getName());
    private static final String TEMPLATE_LOCATION = "templates/";
    private static final String ENCODING = "UTF-8";
    private static final String REPORTER_NAME = "html";
    private static final String SPA_TEMPLATE_NAME = "html/v3-html-index.ftl";
    private static final String FILE_NAME = "Index.html";
    private final AtomicBoolean executed = new AtomicBoolean();
    private final EntityFilters<ExtentHtmlReporter> filter = new EntityFilters((AbstractReporter)this);
    private ExtentHtmlReporterConfig conf = ((ExtentHtmlReporterConfig.ExtentHtmlReporterConfigBuilder)ExtentHtmlReporterConfig.builder().reporter((AbstractReporter)this)).build();
    private Disposable disposable;
    private Report report;

    public ExtentHtmlReporter(String path) {
        super(new File(path));
    }

    public ExtentHtmlReporter(File f) {
        super(f);
    }

    public EntityFilters<ExtentHtmlReporter> filter() {
        return this.filter;
    }

    public ExtentHtmlReporterConfig config() {
        return this.conf;
    }

    public ExtentHtmlReporter config(ExtentHtmlReporterConfig conf) {
        conf.setReporter((AbstractReporter)this);
        this.conf = conf;
        return this;
    }

    public void loadJSONConfig(File jsonFile) throws IOException {
        JsonConfigLoader loader = new JsonConfigLoader((Object)this.conf, jsonFile);
        loader.apply();
    }

    public void loadJSONConfig(String jsonString) throws IOException {
        JsonConfigLoader loader = new JsonConfigLoader((Object)this.conf, jsonString);
        loader.apply();
    }

    public void loadXMLConfig(File xmlFile) throws IOException {
        XmlConfigLoader loader = new XmlConfigLoader((Object)this.conf, xmlFile);
        loader.apply();
    }

    public void loadXMLConfig(String xmlFile) throws IOException {
        this.loadXMLConfig(new File(xmlFile));
    }

    private void executeActions() {
        if (!this.executed.get()) {
            this.conf.enableOfflineMode(this.conf.getOfflineMode());
            this.executed.compareAndSet(false, true);
        }
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                ExtentHtmlReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                ExtentHtmlReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
        this.loadTemplateModel();
    }

    private void flush(ReportEntity value) {
        this.executeActions();
        this.report = this.filterAndGet(value.getReport(), this.filter.statusFilter().getStatus());
        try {
            this.getTemplateModel().put("this", this);
            this.getTemplateModel().put("report", this.report);
            this.getTemplateModel().put("MaterialIcon", new MaterialIcon());
            this.getTemplateModel().put("Icon", new Icon());
            this.getTemplateModel().put("TWBSColor", new TWBSColor());
            this.getTemplateModel().put("ReportUtils", new ReportUtils());
            this.createFreemarkerConfig(TEMPLATE_LOCATION, ENCODING);
            String filePath = this.getFileNameAsExt(FILE_NAME, new String[]{".html", ".htm"});
            Template template = this.getFreemarkerConfig().getTemplate(SPA_TEMPLATE_NAME);
            this.processTemplate(template, new File(filePath));
            return;
        }
        catch (TemplateException | IOException e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
            return;
        }
    }

    public AtomicBoolean getExecuted() {
        return this.executed;
    }

    public ExtentHtmlReporterConfig getConf() {
        return this.conf;
    }

    public Disposable getDisposable() {
        return this.disposable;
    }

    public Report getReport() {
        return this.report;
    }
}

