/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.liquibase;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import liquibase.exception.LiquibaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.liquibase.DataSourceClosingSpringLiquibase;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StopWatch;

public class AsyncSpringLiquibase
extends DataSourceClosingSpringLiquibase {
    public static final String DISABLED_MESSAGE = "Liquibase is disabled";
    public static final String STARTING_ASYNC_MESSAGE = "Starting Liquibase asynchronously, your database might not be ready at startup!";
    public static final String STARTING_SYNC_MESSAGE = "Starting Liquibase synchronously";
    public static final String STARTED_MESSAGE = "Liquibase has updated your database in {} ms";
    public static final String EXCEPTION_MESSAGE = "Liquibase could not start correctly, your database is NOT ready: {}";
    public static final long SLOWNESS_THRESHOLD = 5L;
    public static final String SLOWNESS_MESSAGE = "Warning, Liquibase took more than {} seconds to start up!";
    private final Logger logger = LoggerFactory.getLogger(AsyncSpringLiquibase.class);
    private final Executor executor;
    private final Environment env;

    public AsyncSpringLiquibase(Executor executor, Environment env) {
        this.executor = executor;
        this.env = env;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        if (!this.env.acceptsProfiles(Profiles.of((String[])new String[]{"no-liquibase"}))) {
            if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev|heroku"}))) {
                try (Connection connection = this.getDataSource().getConnection();){
                    this.executor.execute(() -> {
                        try {
                            this.logger.warn(STARTING_ASYNC_MESSAGE);
                            this.initDb();
                        }
                        catch (LiquibaseException e) {
                            this.logger.error(EXCEPTION_MESSAGE, (Object)e.getMessage(), (Object)e);
                        }
                    });
                }
                catch (SQLException e) {
                    this.logger.error(EXCEPTION_MESSAGE, (Object)e.getMessage(), (Object)e);
                }
            } else {
                this.logger.debug(STARTING_SYNC_MESSAGE);
                this.initDb();
            }
        } else {
            this.logger.debug(DISABLED_MESSAGE);
        }
    }

    protected void initDb() throws LiquibaseException {
        StopWatch watch = new StopWatch();
        watch.start();
        super.afterPropertiesSet();
        watch.stop();
        this.logger.debug(STARTED_MESSAGE, (Object)watch.getTotalTimeMillis());
        if (watch.getTotalTimeMillis() > 5000L) {
            this.logger.warn(SLOWNESS_MESSAGE, (Object)5L);
        }
    }
}

