/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.CgiServlet;
import Acme.Serve.FileServlet;
import Acme.Serve.WarDeployer;
import Acme.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class Serve
implements ServletContext,
Serializable {
    public static final String ARG_PORT = "port";
    public static final String ARG_THROTTLES = "throttles";
    public static final String ARG_SERVLETS = "servlets";
    public static final String ARG_REALMS = "realms";
    public static final String ARG_ALIASES = "aliases";
    public static final String ARG_BINDADDRESS = "bind-address";
    public static final String ARG_BACKLOG = "backlog";
    public static final String ARG_CGI_PATH = "cgi-path";
    public static final String ARG_ERR = "error-stream";
    public static final String ARG_OUT = "out-stream";
    public static final String ARG_SESSION_TIMEOUT = "session-timeout";
    public static final String ARG_LOG_DIR = "log-dir";
    public static final String ARG_LOG_OPTIONS = "log-options";
    public static final String ARG_NOHUP = "nohup";
    public static final String ARG_JSP = "JSP";
    public static final String ARG_WAR = "war-deployer";
    public static final String ARG_KEEPALIVE = "keep-alive";
    public static final String DEF_LOGENCODING = "tjws.serve.log.encoding";
    public static final String ARG_KEEPALIVE_TIMEOUT = "timeout-keep-alive";
    public static final String ARG_MAX_CONN_USE = "max-alive-conn-use";
    public static final String ARG_SESSION_PERSIST = "sssn-persistance";
    public static final String ARG_MAX_ACTIVE_SESSIONS = "max-active-sessions";
    public static final String ARG_ACCESS_LOG_FMT = "access-log-format";
    public static final String ARG_ACCEPTOR_CLASS = "acceptorImpl";
    public static final String ARG_WORK_DIRECTORY = "workdirectory";
    public static final String ARG_THREAD_POOL_SIZE = "Acme.Utils.ThreadPool.maxpooledthreads";
    protected static final int DEF_SESSION_TIMEOUT = 30;
    protected static final int DEF_MIN_ACT_SESS = 10;
    protected static final int DESTROY_TIME_SEC = 15;
    public static final int DEF_PORT = 8080;
    public static final String BGCOLOR = "BGCOLOR=\"#D1E9FE\"";
    protected static final int DEF_MAX_CONN_USE = 100;
    protected static final String UTF8 = "UTF-8";
    protected String hostName;
    private transient PrintStream logStream;
    private boolean useAccLog;
    private boolean keepAlive;
    private int timeoutKeepAlive;
    private int maxAliveConnUse;
    private boolean showUserAgent;
    private boolean showReferer;
    protected String keepAliveHdrParams;
    protected transient PathTreeDictionary registry;
    protected transient PathTreeDictionary realms;
    protected transient PathTreeDictionary mappingtable;
    private Hashtable attributes;
    protected transient KeepAliveCleaner keepAliveCleaner;
    protected transient ThreadGroup serverThreads;
    protected transient Utils.ThreadPool threadPool;
    private int uniqer;
    protected HttpSessionContextImpl sessions;
    protected int expiredIn;
    public Map arguments;
    transient boolean running = true;
    protected transient Acceptor acceptor;
    protected transient Thread ssclThread;

    public Serve(Map map, PrintStream printStream) {
        int n;
        this.arguments = map;
        this.logStream = printStream;
        this.registry = new PathTreeDictionary();
        this.realms = new PathTreeDictionary();
        this.attributes = new Hashtable();
        this.serverThreads = new ThreadGroup("TJWS threads");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        this.threadPool = new Utils.ThreadPool(properties, new Utils.ThreadFactory(){

            public Thread create(Runnable runnable) {
                Thread thread = new Thread(Serve.this.serverThreads, runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.setAccessLogged();
        this.keepAlive = map.get(ARG_KEEPALIVE) == null || (Boolean)map.get(ARG_KEEPALIVE) != false;
        try {
            n = Integer.parseInt((String)map.get(ARG_KEEPALIVE_TIMEOUT));
        }
        catch (Exception exception) {
            n = 30;
        }
        this.timeoutKeepAlive = n * 1000;
        try {
            this.maxAliveConnUse = Integer.parseInt((String)map.get(ARG_MAX_CONN_USE));
        }
        catch (Exception exception) {
            this.maxAliveConnUse = 100;
        }
        this.keepAliveHdrParams = "timeout=" + n + ", max=" + this.maxAliveConnUse;
        this.expiredIn = map.get(ARG_SESSION_TIMEOUT) != null ? (Integer)map.get(ARG_SESSION_TIMEOUT) : 30;
    }

    public Serve() {
        this(new HashMap(), System.err);
    }

    protected void setAccessLogged() {
        String string = (String)this.arguments.get(ARG_LOG_OPTIONS);
        if (string != null) {
            this.useAccLog = true;
            this.showUserAgent = string.indexOf(65) >= 0;
            this.showReferer = string.indexOf(82) >= 0;
        }
    }

    protected boolean isAccessLogged() {
        return this.useAccLog;
    }

    protected boolean isShowReferer() {
        return this.showReferer;
    }

    protected boolean isShowUserAgent() {
        return this.showUserAgent;
    }

    protected boolean isKeepAlive() {
        return this.keepAlive;
    }

    protected int getKeepAliveDuration() {
        return this.timeoutKeepAlive;
    }

    protected String getKeepAliveParamStr() {
        return this.keepAliveHdrParams;
    }

    protected int getMaxTimesConnectionUse() {
        return this.maxAliveConnUse;
    }

    public void addServlet(String string, String string2) {
        this.addServlet(string, string2, (Hashtable)null);
    }

    public void addServlet(String string, String string2, Hashtable hashtable) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string2.lastIndexOf(46)) > 0) {
            securityManager.checkPackageAccess(string2.substring(0, n));
            securityManager.checkPackageDefinition(string2.substring(0, n));
        }
        try {
            this.addServlet(string, (Servlet)Class.forName(string2).newInstance(), hashtable);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Class not found: " + string2);
        }
        catch (ClassCastException classCastException) {
            this.log("Class cast problem: " + classCastException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.log("Instantiation problem: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log("Illegal class access: " + illegalAccessException.getMessage());
        }
        catch (Exception exception) {
            this.log("Unexpected problem creating servlet: " + exception, exception);
        }
    }

    public void addServlet(String string, Servlet servlet) {
        this.addServlet(string, servlet, (Hashtable)null);
    }

    public synchronized void addServlet(String string, Servlet servlet, Hashtable hashtable) {
        try {
            if (this.getServlet(string) != null) {
                this.log("Servlet overriden by " + servlet + ", for path:" + string);
            }
            servlet.init((ServletConfig)new ServeConfig(this, hashtable, string));
            this.registry.put(string, servlet);
        }
        catch (ServletException servletException) {
            this.log("Problem initializing servlet, it won't be used: " + (Object)((Object)servletException));
        }
    }

    public void addDefaultServlets(String string) {
        try {
            this.addDefaultServlets(string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addDefaultServlets(String string, String string2) throws IOException {
        if (string != null) {
            if (this.getServlet("/" + string) == null) {
                this.addServlet("/" + string, (Servlet)new CgiServlet());
            } else {
                this.log("Servlet for path '/" + string + "' already defined and no default will be used.");
            }
        }
        if (this.getServlet("/") == null) {
            if (string2 != null) {
                this.addServlet("/", (Servlet)new FileServlet(string2, null));
            } else {
                this.addServlet("/", (Servlet)new FileServlet());
            }
        } else {
            this.log("Servlet for path '/' already defined and no default will be used.");
        }
    }

    protected void addWarDeployer(String string, String string2) {
        if (string == null) {
            string = "rogatkin.web.WarRoller";
        }
        try {
            WarDeployer warDeployer = (WarDeployer)Class.forName(string).newInstance();
            warDeployer.deploy(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Problem initializing war deployer: " + classNotFoundException);
        }
        catch (Exception exception) {
            this.log("Problem war(s) deployment", exception);
        }
    }

    protected File getPersistentFile() {
        if (this.arguments.get(ARG_SESSION_PERSIST) == null || (Boolean)this.arguments.get(ARG_SESSION_PERSIST) == Boolean.FALSE) {
            return null;
        }
        String string = (String)this.arguments.get(ARG_WORK_DIRECTORY);
        if (string == null) {
            string = ".";
        }
        return new File(string, this.hostName + '-' + (this.arguments.get(ARG_PORT) == null ? String.valueOf(8080) : this.arguments.get(ARG_PORT)) + "-session.obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int serve() {
        Closeable closeable;
        File file;
        try {
            this.acceptor = this.createAcceptor();
        }
        catch (IOException iOException) {
            this.log("Acceptor: " + iOException);
            return 1;
        }
        if (this.expiredIn > 0) {
            this.ssclThread = new Thread(this.serverThreads, new Runnable(){

                public void run() {
                    while (Serve.this.running) {
                        try {
                            Thread.sleep(Serve.this.expiredIn * 60 * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!Serve.this.running) break;
                        }
                        Enumeration enumeration = Serve.this.sessions.keys();
                        while (enumeration.hasMoreElements()) {
                            AcmeSession acmeSession;
                            Object k = enumeration.nextElement();
                            if (k == null || (acmeSession = (AcmeSession)Serve.this.sessions.get(k)) == null || !acmeSession.checkExpired() && acmeSession.isValid() || (acmeSession = (AcmeSession)Serve.this.sessions.remove(k)) == null || !acmeSession.isValid()) continue;
                            try {
                                acmeSession.invalidate();
                            }
                            catch (IllegalStateException illegalStateException) {}
                        }
                    }
                }
            }, "Session cleaner");
            this.ssclThread.setPriority(1);
            this.ssclThread.start();
        }
        if (this.isKeepAlive()) {
            this.keepAliveCleaner = new KeepAliveCleaner();
            this.keepAliveCleaner.start();
        }
        if ((file = this.getPersistentFile()) != null && file.exists()) {
            closeable = null;
            try {
                closeable = new BufferedReader(new FileReader(file));
                this.sessions = HttpSessionContextImpl.restore(closeable, Math.abs(this.expiredIn) * 60, this);
            }
            catch (IOException iOException) {
                this.log("Problem in restoring sessions.", iOException);
            }
            catch (Exception exception) {
                this.log("Unexpected problem in restoring sessions.", exception);
            }
            finally {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.sessions == null) {
            this.sessions = new HttpSessionContextImpl();
        }
        System.out.println("[" + new Date() + "] TJWS httpd " + this.hostName + " - " + this.acceptor + " is listening.");
        try {
            while (this.running) {
                try {
                    closeable = this.acceptor.accept();
                    if (this.keepAliveCleaner != null) {
                        this.keepAliveCleaner.addConnection(new ServeConnection((Socket)closeable, this));
                        continue;
                    }
                    new ServeConnection((Socket)closeable, this);
                }
                catch (IOException iOException) {
                    this.log("Accept: " + iOException);
                }
                catch (SecurityException securityException) {
                    this.log("Illegal access: " + securityException);
                }
                catch (IllegalStateException illegalStateException) {
                    this.log("Illegal state: " + illegalStateException);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.log("Unhandled exception: " + throwable + ", server is terminating.", throwable);
                if (throwable instanceof ThreadDeath) {
                    throw (Error)throwable;
                }
                int n = -1;
                return n;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (this.acceptor != null) {
                        this.acceptor.destroy();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (this.acceptor == null) return 0;
            this.acceptor.destroy();
            return 0;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void notifyStop() throws IOException {
        this.running = false;
        this.acceptor.destroy();
        this.acceptor = null;
        if (this.ssclThread != null) {
            this.ssclThread.interrupt();
        }
    }

    protected Acceptor createAcceptor() throws IOException {
        String string = (String)this.arguments.get(ARG_ACCEPTOR_CLASS);
        if (string == null) {
            string = "Acme.Serve.SimpleAcceptor";
        }
        try {
            this.acceptor = (Acceptor)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.log("Couldn't instantiate Acceptor, the Server is inoperable", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            try {
                Constructor<?> constructor = Class.forName(string).getDeclaredConstructor(Utils.EMPTY_CLASSES);
                constructor.setAccessible(true);
                this.acceptor = (Acceptor)constructor.newInstance(Utils.EMPTY_OBJECTS);
            }
            catch (Exception exception) {
                this.log("Acceptor is not accessable or can't be instantiated, the Server is inoperable", illegalAccessException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Acceptor class not found, the Server is inoperable", classNotFoundException);
        }
        Properties properties = new Properties();
        this.acceptor.init(this.arguments, properties);
        this.hostName = (String)properties.get(ARG_BINDADDRESS);
        return this.acceptor;
    }

    public Servlet getServlet(String string) {
        try {
            return (Servlet)this.registry.get(string)[0];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Enumeration getServlets() {
        return this.registry.elements();
    }

    public Enumeration getServletNames() {
        return this.registry.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyAllServlets() {
        Object object;
        Object object2;
        Object object3;
        File file = this.getPersistentFile();
        if (file != null && this.sessions != null) {
            object3 = null;
            try {
                object3 = new FileWriter(file);
                this.sessions.save((Writer)object3);
                this.log("Sessions stored.");
            }
            catch (IOException iOException) {
                this.log("IO problem in storing sessions " + iOException);
            }
            catch (Throwable throwable) {
                this.log("Problem in storing sessions " + throwable);
            }
            finally {
                try {
                    ((Writer)object3).close();
                }
                catch (Exception exception) {}
            }
            object2 = this.sessions.keys();
            while (object2.hasMoreElements()) {
                Object e = object2.nextElement();
                if (e == null || (object = (AcmeSession)this.sessions.get(e)) == null || (object = (AcmeSession)this.sessions.remove(e)) == null || !((AcmeSession)object).isValid()) continue;
                try {
                    ((AcmeSession)object).invalidate();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        object3 = this.registry.elements();
        object2 = new Runnable((Enumeration)object3){
            private final /* synthetic */ Enumeration val$en;
            {
                this.val$en = enumeration;
            }

            public void run() {
                ((Servlet)this.val$en.nextElement()).destroy();
            }
        };
        int n = 0;
        while (object3.hasMoreElements()) {
            object = new Thread((Runnable)object2, "Destroy");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            try {
                ((Thread)object).join(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!((Thread)object).isAlive()) continue;
            this.log("Destroy thread didn't terminate in 15");
            ((Thread)object).setName("Destroy too long " + n++);
        }
        this.registry = new PathTreeDictionary();
    }

    protected void setMappingTable(PathTreeDictionary pathTreeDictionary) {
        this.mappingtable = pathTreeDictionary;
    }

    protected void setRealms(PathTreeDictionary pathTreeDictionary) {
        this.realms = pathTreeDictionary;
    }

    AcmeSession getSession(String string) {
        return (AcmeSession)this.sessions.get(string);
    }

    HttpSession createSession() {
        Integer n = (Integer)this.arguments.get(ARG_MAX_ACTIVE_SESSIONS);
        if (n != null && n < this.sessions.size()) {
            return null;
        }
        AcmeSession acmeSession = new AcmeSession(this.generateSessionId(), Math.abs(this.expiredIn) * 60, this, this.sessions);
        this.sessions.put(acmeSession.getId(), acmeSession);
        return acmeSession;
    }

    void removeSession(String string) {
        this.sessions.remove(string);
    }

    public void log(String string) {
        Date date = new Date(System.currentTimeMillis());
        this.logStream.println("[" + date.toString() + "] " + string);
    }

    public void log(String string, Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = string + '\n' + stringWriter;
        }
        this.log(string);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public String getRealPath(String string) {
        if (this.mappingtable != null) {
            Object[] objectArray = this.mappingtable.get(string);
            if (objectArray[0] == null) {
                return null;
            }
            int n = (Integer)objectArray[1];
            int n2 = string.length();
            if (n > 0) {
                string = string.length() > n ? string.substring(n + 1) : "";
            } else if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (c == '/' || c == '\\') continue;
                    if (i <= 0) break;
                    string = string.substring(i);
                    break;
                }
            }
            return new File((File)objectArray[0], string).getPath();
        }
        return string;
    }

    public String getContextPath() {
        return "";
    }

    public String getMimeType(String string) {
        if ((string = string.toUpperCase()).endsWith(".HTML") || string.endsWith(".HTM")) {
            return "text/html";
        }
        if (string.endsWith(".TXT")) {
            return "text/plain";
        }
        if (string.endsWith(".XML")) {
            return "text/xml";
        }
        if (string.endsWith(".CSS")) {
            return "text/css";
        }
        if (string.endsWith(".SGML") || string.endsWith(".SGM")) {
            return "text/x-sgml";
        }
        if (string.endsWith(".GIF")) {
            return "image/gif";
        }
        if (string.endsWith(".JPG") || string.endsWith(".JPEG") || string.endsWith(".JPE")) {
            return "image/jpeg";
        }
        if (string.endsWith(".PNG")) {
            return "image/png";
        }
        if (string.endsWith(".BMP")) {
            return "image/bmp";
        }
        if (string.endsWith(".TIF") || string.endsWith(".TIFF")) {
            return "image/tiff";
        }
        if (string.endsWith(".RGB")) {
            return "image/x-rgb";
        }
        if (string.endsWith(".XPM")) {
            return "image/x-xpixmap";
        }
        if (string.endsWith(".XBM")) {
            return "image/x-xbitmap";
        }
        if (string.endsWith(".SVG")) {
            return "image/svg-xml ";
        }
        if (string.endsWith(".SVGZ")) {
            return "image/svg-xml ";
        }
        if (string.endsWith(".AU") || string.endsWith(".SND")) {
            return "audio/basic";
        }
        if (string.endsWith(".MID") || string.endsWith(".MIDI") || string.endsWith(".RMI") || string.endsWith(".KAR")) {
            return "audio/mid";
        }
        if (string.endsWith(".MPGA") || string.endsWith(".MP2") || string.endsWith(".MP3")) {
            return "audio/mpeg";
        }
        if (string.endsWith(".WAV")) {
            return "audio/wav";
        }
        if (string.endsWith(".AIFF") || string.endsWith(".AIFC")) {
            return "audio/aiff";
        }
        if (string.endsWith(".AIF")) {
            return "audio/x-aiff";
        }
        if (string.endsWith(".RA")) {
            return "audio/x-realaudio";
        }
        if (string.endsWith(".RPM")) {
            return "audio/x-pn-realaudio-plugin";
        }
        if (string.endsWith(".RAM")) {
            return "audio/x-pn-realaudio";
        }
        if (string.endsWith(".SD2")) {
            return "audio/x-sd2";
        }
        if (string.endsWith(".BIN") || string.endsWith(".DMS") || string.endsWith(".LHA") || string.endsWith(".LZH") || string.endsWith(".EXE") || string.endsWith(".DLL") || string.endsWith(".CLASS")) {
            return "application/octet-stream";
        }
        if (string.endsWith(".HQX")) {
            return "application/mac-binhex40";
        }
        if (string.endsWith(".PS") || string.endsWith(".AI") || string.endsWith(".EPS")) {
            return "application/postscript";
        }
        if (string.endsWith(".PDF")) {
            return "application/pdf";
        }
        if (string.endsWith(".RTF")) {
            return "application/rtf";
        }
        if (string.endsWith(".DOC")) {
            return "application/msword";
        }
        if (string.endsWith(".PPT")) {
            return "application/powerpoint";
        }
        if (string.endsWith(".FIF")) {
            return "application/fractals";
        }
        if (string.endsWith(".P7C")) {
            return "application/pkcs7-mime";
        }
        if (string.endsWith(".JS")) {
            return "application/x-javascript";
        }
        if (string.endsWith(".Z")) {
            return "application/x-compress";
        }
        if (string.endsWith(".GZ")) {
            return "application/x-gzip";
        }
        if (string.endsWith(".TAR")) {
            return "application/x-tar";
        }
        if (string.endsWith(".TGZ")) {
            return "application/x-compressed";
        }
        if (string.endsWith(".ZIP")) {
            return "application/x-zip-compressed";
        }
        if (string.endsWith(".DIR") || string.endsWith(".DCR") || string.endsWith(".DXR")) {
            return "application/x-director";
        }
        if (string.endsWith(".DVI")) {
            return "application/x-dvi";
        }
        if (string.endsWith(".TEX")) {
            return "application/x-tex";
        }
        if (string.endsWith(".LATEX")) {
            return "application/x-latex";
        }
        if (string.endsWith(".TCL")) {
            return "application/x-tcl";
        }
        if (string.endsWith(".CER") || string.endsWith(".CRT") || string.endsWith(".DER")) {
            return "application/x-x509-ca-cert";
        }
        if (string.endsWith(".MPG") || string.endsWith(".MPE") || string.endsWith(".MPEG")) {
            return "video/mpeg";
        }
        if (string.endsWith(".QT") || string.endsWith(".MOV")) {
            return "video/quicktime";
        }
        if (string.endsWith(".AVI")) {
            return "video/x-msvideo";
        }
        if (string.endsWith(".MOVIE")) {
            return "video/x-sgi-movie";
        }
        if (string.endsWith(".PDB") || string.endsWith(".XYZ")) {
            return "chemical/x-pdb";
        }
        if (string.endsWith(".ICE")) {
            return "x-conference/x-cooltalk";
        }
        if (string.endsWith(".JNLP")) {
            return "application/x-java-jnlp-file";
        }
        if (string.endsWith(".WRL") || string.endsWith(".VRML")) {
            return "x-world/x-vrml";
        }
        if (string.endsWith(".WML")) {
            return "text/vnd.wap.wml";
        }
        if (string.endsWith(".WMLC")) {
            return "application/vnd.wap.wmlc";
        }
        if (string.endsWith(".WMLS")) {
            return "text/vnd.wap.wmlscript";
        }
        if (string.endsWith(".WMLSC")) {
            return "application/vnd.wap.wmlscriptc";
        }
        if (string.endsWith(".WBMP")) {
            return "image/vnd.wap.wbmp";
        }
        return null;
    }

    public String getServerInfo() {
        return "Rogatkin's JWS based on Acme.Serve Version 1.31, $Revision: 1.151 $ (http://tjws.sourceforge.net)";
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.attributes.remove(string);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String string) {
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public Set getResourcePaths(String string) {
        String[] stringArray;
        String string2 = this.getRealPath(string);
        if (string2 != null && (stringArray = new File(string2).list()).length > 0) {
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            return hashSet;
        }
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new MalformedURLException("Path " + string + " is not in acceptable form.");
        }
        return new URL("file", "localhost", this.getRealPath(string));
    }

    public InputStream getResourceAsStream(String string) {
        try {
            return this.getResource(string).openStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        try {
            return new SimpleRequestDispatcher(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return Utils.EMPTY_ENUMERATION;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    synchronized String generateSessionId() {
        return "-" + System.currentTimeMillis() + '-' + this.uniqer++ + '-' + Math.round(Math.random() * 1000.0);
    }

    protected static class HttpSessionContextImpl
    extends Hashtable
    implements HttpSessionContext {
        protected HttpSessionContextImpl() {
        }

        public Enumeration getIds() {
            return this.keys();
        }

        public HttpSession getSession(String string) {
            return (HttpSession)this.get(string);
        }

        void save(Writer writer) throws IOException {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                ((AcmeSession)enumeration.nextElement()).save(writer);
            }
        }

        static HttpSessionContextImpl restore(BufferedReader bufferedReader, int n, ServletContext servletContext) throws IOException {
            AcmeSession acmeSession;
            HttpSessionContextImpl httpSessionContextImpl = new HttpSessionContextImpl();
            while ((acmeSession = AcmeSession.restore(bufferedReader, n, servletContext, httpSessionContextImpl)) != null) {
                if (acmeSession.checkExpired()) continue;
                httpSessionContextImpl.put(acmeSession.getId(), acmeSession);
            }
            return httpSessionContextImpl;
        }
    }

    protected static class AcceptLocaleEnumeration
    implements Enumeration {
        Iterator i;

        public AcceptLocaleEnumeration(TreeSet treeSet) {
            this.i = treeSet.iterator();
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return ((LocaleWithWeight)this.i.next()).getLocale();
        }
    }

    protected static class LocaleWithWeight
    implements Comparable {
        protected float weight;
        protected Locale locale;

        LocaleWithWeight(Locale locale, float f) {
            this.locale = locale;
            this.weight = f;
        }

        public int compareTo(Object object) {
            if (object instanceof LocaleWithWeight) {
                return (int)(((LocaleWithWeight)object).weight - this.weight) * 100;
            }
            throw new IllegalArgumentException();
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static class AcmeSession
    extends Hashtable
    implements HttpSession {
        private long createTime = System.currentTimeMillis();
        private long lastAccessTime;
        private String id;
        private int inactiveInterval;
        private boolean expired;
        private transient ServletContext servletContext;
        private transient HttpSessionContext sessionContext;
        private transient List listeners;

        AcmeSession(String string, ServletContext servletContext, HttpSessionContext httpSessionContext) {
            this(string, 0, servletContext, httpSessionContext);
        }

        AcmeSession(String string, int n, ServletContext servletContext, HttpSessionContext httpSessionContext) {
            this.id = string;
            this.inactiveInterval = n;
            this.servletContext = servletContext;
            this.sessionContext = httpSessionContext;
        }

        public long getCreationTime() {
            return this.createTime;
        }

        public String getId() {
            return this.id;
        }

        public long getLastAccessedTime() {
            return this.lastAccessTime;
        }

        public void setMaxInactiveInterval(int n) {
            this.inactiveInterval = n;
        }

        public int getMaxInactiveInterval() {
            return this.inactiveInterval;
        }

        public HttpSessionContext getSessionContext() {
            return this.sessionContext;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Object getAttribute(String string) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.get(string);
        }

        public Object getValue(String string) throws IllegalStateException {
            return this.getAttribute(string);
        }

        public Enumeration getAttributeNames() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.keys();
        }

        public String[] getValueNames() throws IllegalStateException {
            Enumeration enumeration = this.getAttributeNames();
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public void setAttribute(String string, Object object) throws IllegalStateException {
            Object object2;
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object object3 = object2 = object != null ? this.put(string, object) : this.remove(string);
            if (object2 != null) {
                if (object2 instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)object2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
                } else if (object2 instanceof HttpSessionAttributeListener) {
                    ((HttpSessionAttributeListener)object2).attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, string, object));
                }
            }
            if (object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
            } else if (object instanceof HttpSessionAttributeListener) {
                ((HttpSessionAttributeListener)object).attributeAdded(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }

        public void putValue(String string, Object object) throws IllegalStateException {
            this.setAttribute(string, object);
        }

        public void removeAttribute(String string) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object v = this.remove(string);
            if (v != null) {
                if (v instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
                } else if (v instanceof HttpSessionAttributeListener) {
                    ((HttpSessionAttributeListener)v).attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, string));
                }
            }
        }

        public void removeValue(String string) throws IllegalStateException {
            this.removeAttribute(string);
        }

        public synchronized void invalidate() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            this.notifyListeners();
            Enumeration enumeration = this.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                this.removeAttribute((String)enumeration.nextElement());
            }
            this.setExpired(true);
        }

        public boolean isNew() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.lastAccessTime == 0L;
        }

        public synchronized void setListeners(List list) {
            if (this.listeners == null) {
                this.listeners = list;
                if (this.listeners != null) {
                    HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            ((HttpSessionListener)this.listeners.get(0)).sessionCreated(httpSessionEvent);
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public synchronized void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        private void notifyListeners() {
            if (this.listeners != null) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((HttpSessionListener)this.listeners.get(i)).sessionDestroyed(httpSessionEvent);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        private void setExpired(boolean bl) {
            this.expired = bl;
        }

        boolean isValid() {
            return !this.expired;
        }

        boolean checkExpired() {
            return this.inactiveInterval > 0 && (long)(this.inactiveInterval * 1000) < System.currentTimeMillis() - this.lastAccessTime;
        }

        void userTouch() {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            this.lastAccessTime = System.currentTimeMillis();
        }

        void save(Writer writer) throws IOException {
            if (this.expired) {
                return;
            }
            writer.write(this.id);
            writer.write(58);
            writer.write(Integer.toString(this.inactiveInterval));
            writer.write(58);
            writer.write(this.servletContext == null || this.servletContext.getServletContextName() == null ? "" : this.servletContext.getServletContextName());
            writer.write(58);
            writer.write(Long.toString(this.lastAccessTime));
            writer.write("\r\n");
            Enumeration enumeration = this.getAttributeNames();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.get(string);
                if (v instanceof Serializable) {
                    byteArrayOutputStream.reset();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    try {
                        objectOutputStream.writeObject(v);
                        writer.write(string);
                        writer.write(":");
                        writer.write(Utils.base64Encode(byteArrayOutputStream.toByteArray()));
                        writer.write("\r\n");
                    }
                    catch (IOException iOException) {
                        this.servletContext.log("Problem storing session value " + string, (Throwable)iOException);
                    }
                }
                if (!(v instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)v).sessionWillPassivate(new HttpSessionEvent((HttpSession)this));
            }
            writer.write("$$\r\n");
        }

        static AcmeSession restore(BufferedReader bufferedReader, int n, ServletContext servletContext, HttpSessionContext httpSessionContext) throws IOException {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            int n2 = string.indexOf(58);
            if (n2 < 0) {
                throw new IOException("Invalid format for a session header, no session id: " + string);
            }
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf(58, n2 + 1);
            if (n3 < 0) {
                throw new IOException("Invalid format for a session header, no latency: " + string);
            }
            try {
                n = Integer.parseInt(string.substring(n2 + 1, n3));
            }
            catch (NumberFormatException numberFormatException) {
                servletContext.log("Session latency invalid:" + string.substring(n2 + 1, n3) + " " + numberFormatException);
            }
            n2 = string.indexOf(58, n3 + 1);
            if (n2 < 0) {
                throw new IOException("Invalid format for a session header, context name: " + string);
            }
            String string3 = string.substring(n3 + 1, n2);
            AcmeSession acmeSession = new AcmeSession(string2, n, (ServletContext)(string3.length() == 0 ? servletContext : null), httpSessionContext);
            try {
                acmeSession.lastAccessTime = Long.parseLong(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                servletContext.log("Last access time invalid:" + string.substring(n2 + 1) + " " + numberFormatException);
            }
            while (true) {
                Throwable throwable;
                if ((string = bufferedReader.readLine()) == null) {
                    throw new IOException("Unexpected end of stream.");
                }
                if ("$$".equals(string)) {
                    return acmeSession;
                }
                n2 = string.indexOf(58);
                if (n2 < 0) {
                    throw new IOException("Invalid format for a session entry: " + string);
                }
                String string4 = string.substring(0, n2);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(Utils.decode64(string.substring(n2 + 1))));
                try {
                    Object object = objectInputStream.readObject();
                    acmeSession.put(string4, object);
                    throwable = null;
                    if (object instanceof HttpSessionActivationListener) {
                        ((HttpSessionActivationListener)object).sessionDidActivate(new HttpSessionEvent((HttpSession)acmeSession));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throwable = classNotFoundException;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throwable = noClassDefFoundError;
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                if (throwable == null) continue;
                servletContext.log("Can't restore :" + string4 + ", " + throwable);
            }
        }
    }

    public static class PathTreeDictionary {
        Node root_node = new Node();

        public synchronized void put(String string, Object object) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
            Node node = this.root_node;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Node node2 = (Node)node.get(string2);
                if (node2 == null) {
                    node2 = new Node();
                    node.put(string2, node2);
                }
                node = node2;
            }
            node.object = object;
        }

        public synchronized Object[] remove(Object object) {
            return this.remove(this.root_node, object);
        }

        public synchronized Object[] remove(String string) {
            Object[] objectArray = this.get(string);
            if (objectArray[1] != null) {
                return this.remove(objectArray[1]);
            }
            return objectArray;
        }

        public Object[] remove(Node node, Object object) {
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Node node2 = (Node)node.get(string);
                if (node2.object == object) {
                    return new Object[]{string, object};
                }
                Object[] objectArray = this.remove(node2, object);
                if (objectArray[1] == null) continue;
                return objectArray;
            }
            return new Object[]{null, null};
        }

        public Object[] get(String string) {
            Object[] objectArray = new Object[2];
            if (string == null) {
                return objectArray;
            }
            char[] cArray = string.toCharArray();
            Node node = this.root_node;
            int n = 0;
            int n2 = 0;
            objectArray[0] = node.object;
            boolean bl = true;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '/' || cArray[i] == '\\') {
                    if (bl) continue;
                    Node node2 = (Node)node.get(new String(cArray, n, i - n));
                    if (node2 == null) {
                        objectArray[1] = new Integer(n2);
                        return objectArray;
                    }
                    if (node2.object != null) {
                        objectArray[0] = node2.object;
                        n2 = i;
                    }
                    node = node2;
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                n = i;
                bl = false;
            }
            if ((node = (Node)node.get(new String(cArray, n, cArray.length - n))) != null && node.object != null) {
                objectArray[0] = node.object;
                n2 = cArray.length;
            }
            objectArray[1] = new Integer(n2);
            return objectArray;
        }

        public Enumeration keys() {
            Vector vector = new Vector();
            this.addSiblingNames(this.root_node, vector, "");
            return vector.elements();
        }

        public void addSiblingNames(Node node, Vector vector, String string) {
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Node node2 = (Node)node.get(string2);
                string2 = string + '/' + string2;
                if (node2.object != null) {
                    vector.addElement(string2);
                }
                this.addSiblingNames(node2, vector, string2);
            }
        }

        public Enumeration elements() {
            Vector vector = new Vector();
            this.addSiblingObjects(this.root_node, vector);
            return vector.elements();
        }

        public void addSiblingObjects(Node node, Vector vector) {
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)node.get(enumeration.nextElement());
                if (node2.object != null) {
                    vector.addElement(node2.object);
                }
                this.addSiblingObjects(node2, vector);
            }
        }

        class Node
        extends Hashtable {
            Object object;

            Node() {
            }
        }
    }

    public static class ServeOutputStream
    extends ServletOutputStream {
        private static final boolean STREAM_DEBUG = false;
        private boolean chunked;
        private boolean closed;
        private OutputStream out;
        private ServeConnection conn;
        private boolean inInclude;
        private String encoding;
        private long lbytes;
        private Utils.SimpleBuffer buffer;

        public ServeOutputStream(OutputStream outputStream, ServeConnection serveConnection) {
            this.out = outputStream;
            this.conn = serveConnection;
            this.buffer = new Utils.SimpleBuffer();
            this.encoding = serveConnection.getCharacterEncoding();
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }

        void refresh() {
            this.chunked = false;
            this.closed = false;
            this.inInclude = false;
            this.lbytes = 0L;
            this.buffer.reset();
            this.encoding = this.conn.getCharacterEncoding();
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }

        protected void reset() {
            if (this.lbytes != 0L) {
                throw new IllegalStateException("Result was already committed");
            }
            this.buffer.reset();
        }

        protected int getBufferSize() {
            return this.buffer.getSize();
        }

        protected void setBufferSize(int n) {
            if (this.lbytes > 0L) {
                throw new IllegalStateException("Bytes already written in response");
            }
            this.buffer.setSize(n);
        }

        protected void setChunked(boolean bl) {
            this.chunked = bl;
        }

        public void print(String string) throws IOException {
            this.write(string.getBytes(this.encoding));
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("An attempt of writing " + n2 + " bytes to closed out.");
            }
            if (n2 == 0) {
                return;
            }
            this.conn.writeHeaders();
            byArray = this.buffer.put(byArray, n, n2);
            n2 = byArray.length;
            if (n2 == 0) {
                return;
            }
            n = 0;
            if (this.chunked) {
                String string = Integer.toHexString(n2);
                this.out.write((string + "\r\n").getBytes());
                this.lbytes += (long)(2 + string.length());
                this.out.write(byArray, n, n2);
                this.lbytes += (long)n2;
                this.out.write("\r\n".getBytes());
                this.lbytes += 2L;
            } else {
                this.out.write(byArray, n, n2);
                this.lbytes += (long)n2;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            this.conn.writeHeaders();
            byte[] byArray = this.buffer.get();
            if (byArray.length > 0) {
                if (this.chunked) {
                    String string = Integer.toHexString(byArray.length);
                    this.out.write((string + "\r\n").getBytes());
                    this.lbytes += (long)(2 + string.length());
                    this.out.write(byArray);
                    this.lbytes += (long)byArray.length;
                    this.out.write("\r\n".getBytes());
                    this.lbytes += 2L;
                } else {
                    this.out.write(byArray);
                    this.lbytes += (long)byArray.length;
                }
            }
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
                if (!this.inInclude) {
                    if (this.chunked) {
                        this.out.write("0\r\n\r\n".getBytes());
                        this.lbytes += 5L;
                        this.out.flush();
                    }
                    if (!this.conn.keepAlive) {
                        this.out.close();
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        private long lengthWritten() {
            return this.lbytes;
        }

        boolean isInInclude() {
            return this.inInclude;
        }

        void setInInclude(boolean bl) {
            this.inInclude = bl;
        }
    }

    public static class ServeInputStream
    extends ServletInputStream {
        private static final boolean STREAM_DEBUG = false;
        private BufferedInputStream in;
        private int chunksize = 0;
        private boolean chunking = false;
        private boolean returnedAsReader;
        private boolean returnedAsStream;
        private long contentLength = -1L;
        private long readCount;

        public ServeInputStream(InputStream inputStream) {
            this.in = new BufferedInputStream(inputStream);
        }

        void refresh() {
            this.returnedAsReader = false;
            this.returnedAsStream = false;
            this.contentLength = -1L;
            this.readCount = 0L;
            this.chunksize = 0;
        }

        public void chunking(boolean bl) {
            if (this.contentLength == -1L) {
                this.chunking = bl;
            }
        }

        void setContentLength(long l) {
            if (this.contentLength == -1L && l >= 0L && !this.chunking) {
                this.contentLength = l;
                this.readCount = 0L;
            }
        }

        public String readLine() throws IOException {
            int n;
            StringBuffer stringBuffer = new StringBuffer(1024);
            boolean bl = false;
            block4: while ((n = this.chunking || this.contentLength >= 0L ? this.read() : this.in.read()) != -1) {
                switch (n) {
                    case 10: {
                        break block4;
                    }
                    case 13: {
                        bl = true;
                        if (this.chunking) continue block4;
                        this.in.mark(2);
                        continue block4;
                    }
                    default: {
                        if (bl) {
                            this.in.reset();
                            break block4;
                        }
                        stringBuffer.append((char)n);
                        continue block4;
                    }
                }
            }
            if (n == -1 && stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            if (this.chunking) {
                int n = -1;
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1;
                }
                n = this.in.read();
                this.chunksize = n < 0 ? -1 : this.chunksize - 1;
                return n;
            }
            if (this.contentLength >= 0L) {
                if (this.readCount >= this.contentLength) {
                    return -1;
                }
                ++this.readCount;
            }
            return this.in.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1;
                }
                if (n2 > this.chunksize) {
                    n2 = this.chunksize;
                }
                this.chunksize = (n2 = this.in.read(byArray, n, n2)) < 0 ? -1 : this.chunksize - n2;
            } else if (this.contentLength >= 0L) {
                if (this.contentLength - this.readCount < Integer.MAX_VALUE) {
                    n2 = Math.min(n2, (int)(this.contentLength - this.readCount));
                }
                if (n2 <= 0) {
                    return -1;
                }
                n2 = this.in.read(byArray, n, n2);
                this.readCount += (long)n2;
            } else {
                n2 = this.in.read(byArray, n, n2);
            }
            return n2;
        }

        public long skip(long l) throws IOException {
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1L;
                }
                if (l > (long)this.chunksize) {
                    l = this.chunksize;
                }
                this.chunksize = (l = this.in.skip(l)) < 0L ? -1 : this.chunksize - (int)l;
            } else if (this.contentLength >= 0L) {
                if ((l = Math.min(l, this.contentLength - this.readCount)) <= 0L) {
                    return -1L;
                }
                l = this.in.skip(l);
                this.readCount += l;
            } else {
                l = this.in.skip(l);
            }
            return l;
        }

        public int available() throws IOException {
            if (this.chunking) {
                int n = this.in.available();
                if (n <= this.chunksize) {
                    return n;
                }
                return this.chunksize;
            }
            if (this.contentLength >= 0L) {
                int n = this.in.available();
                if (this.contentLength - this.readCount < Integer.MAX_VALUE) {
                    return Math.min(n, (int)(this.contentLength - this.readCount));
                }
                return n;
            }
            return this.in.available();
        }

        public void close() throws IOException {
            this.chunksize = -1;
            if (this.contentLength >= 0L) {
                this.contentLength = this.readCount;
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            this.in.reset();
        }

        public void mark(int n) {
        }

        private int getChunkSize() throws IOException {
            if (this.chunksize < 0) {
                return -1;
            }
            this.chunksize = -1;
            this.chunking = false;
            String string = this.readLine();
            while (string != null && string.length() == 0) {
                string = this.readLine();
            }
            this.chunking = true;
            if (string == null) {
                return -1;
            }
            int n = string.indexOf(59);
            if (n > 0) {
                string = string.substring(0, n).trim();
            }
            this.chunksize = Integer.parseInt(string, 16);
            if (this.chunksize == 0) {
                this.chunksize = -1;
                this.chunking = false;
            }
            return this.chunksize;
        }

        boolean isReturnedAsStream() {
            return this.returnedAsStream;
        }

        void setReturnedAsStream(boolean bl) {
            this.returnedAsStream = bl;
        }

        boolean isReturnedAsReader() {
            return this.returnedAsReader;
        }

        void setReturnedAsReader(boolean bl) {
            this.returnedAsReader = bl;
        }
    }

    protected static class BasicAuthRealm
    extends Hashtable {
        String name;

        BasicAuthRealm(String string) {
            this.name = string;
        }

        String name() {
            return this.name;
        }
    }

    public static class ServeConnection
    implements Runnable,
    HttpServletRequest,
    HttpServletResponse {
        private Socket socket;
        private Serve serve;
        private ServletInputStream in;
        private ServletOutputStream out;
        private String scheme;
        public static final String WWWFORMURLENCODE = "application/x-www-form-urlencoded";
        public static final String TRANSFERENCODING = "transfer-encoding".toLowerCase();
        public static final String KEEPALIVE = "Keep-Alive".toLowerCase();
        public static final String CONNECTION = "Connection".toLowerCase();
        public static final String CHUNKED = "chunked";
        public static final String CONTENTLENGTH = "Content-Length".toLowerCase();
        public static final String CONTENTTYPE = "Content-Type".toLowerCase();
        public static final String SETCOOKIE = "Set-Cookie".toLowerCase();
        public static final String HOST = "Host".toLowerCase();
        public static final String COOKIE = "Cookie".toLowerCase();
        public static final String ACCEPT_LANGUAGE = "Accept-Language".toLowerCase();
        public static final String SESSION_COOKIE_NAME = "JSESSIONID";
        public static final String SESSION_URL_NAME = ";$sessionid$";
        private static final Map EMPTYHASHTABLE = new Hashtable();
        private String reqMethod;
        private String reqUriPath;
        private String reqProtocol;
        private String charEncoding;
        private String remoteUser;
        private String authType;
        private boolean oneOne;
        private boolean reqMime;
        private Vector reqHeaderNames = new Vector();
        private Vector reqHeaderValues = new Vector();
        private Locale locale;
        private int uriLen;
        protected boolean keepAlive = true;
        protected int timesRequested;
        protected long lastRun;
        protected long lastWait;
        private Vector outCookies;
        private Vector inCookies;
        private String sessionCookieValue;
        private String sessionUrlValue;
        private String sessionValue;
        protected String reqQuery;
        private PrintWriter pw;
        private ServletOutputStream rout;
        private Map formParameters;
        private Hashtable attributes = new Hashtable();
        private int resCode = -1;
        private String resMessage;
        private Hashtable resHeaderNames = new Hashtable();
        private String[] postCache;
        private boolean headersWritten;
        private MessageFormat accessFmt;
        private Object[] logPlaceholders;
        private final SimpleDateFormat expdatefmt = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat rfc850DateFmt = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat headerdateformat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat asciiDateFmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        private static final TimeZone tz = TimeZone.getTimeZone("GMT");
        private static final int MAYBEVERSION = 1;
        private static final int INVERSION = 2;
        private static final int OLD_INNAME = 3;
        private static final int OLD_INVAL = 4;
        private static final int INVERSIONNUM = 5;
        private static final int RECOVER = 6;
        private static final int NEW_INNAME = 7;
        private static final int NEW_INVAL = 8;
        private static final int INPATH = 9;
        private static final int MAYBEINPATH = 10;
        private static final int INPATHVALUE = 11;
        private static final int MAYBEPORT = 12;
        private static final int INDOMAIN = 13;
        private static final int MAYBEDOMAIN = 14;
        private static final int INPORT = 15;
        private static final int INDOMAINVALUE = 16;
        private static final int INPORTVALUE = 17;

        public ServeConnection(Socket socket, Serve serve) {
            this.socket = socket;
            this.serve = serve;
            this.expdatefmt.setTimeZone(tz);
            this.headerdateformat.setTimeZone(tz);
            this.rfc850DateFmt.setTimeZone(tz);
            this.asciiDateFmt.setTimeZone(tz);
            if (serve.isAccessLogged()) {
                this.accessFmt = new MessageFormat((String)serve.arguments.get(Serve.ARG_ACCESS_LOG_FMT));
                this.logPlaceholders = new Object[12];
            }
            serve.threadPool.executeThread(this);
        }

        public void close() throws IOException {
            if (this.pw != null) {
                this.pw.flush();
            } else {
                this.out.flush();
            }
            this.out.close();
        }

        private void restart() {
            this.reqMethod = null;
            this.reqUriPath = null;
            this.reqProtocol = null;
            this.charEncoding = null;
            this.remoteUser = null;
            this.authType = null;
            this.oneOne = false;
            this.reqMime = false;
            if (this.reqHeaderNames == null) {
                this.reqHeaderNames = new Vector();
            } else {
                this.reqHeaderNames.clear();
            }
            if (this.reqHeaderValues == null) {
                this.reqHeaderValues = new Vector();
            } else {
                this.reqHeaderValues.clear();
            }
            this.locale = null;
            this.uriLen = 0;
            this.outCookies = null;
            this.inCookies = null;
            this.sessionCookieValue = null;
            this.sessionUrlValue = null;
            this.sessionValue = null;
            this.reqQuery = null;
            this.pw = null;
            this.rout = null;
            this.formParameters = null;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            } else {
                this.attributes.clear();
            }
            this.resCode = -1;
            this.resMessage = null;
            this.resHeaderNames.clear();
            this.headersWritten = false;
            this.postCache = null;
            ((ServeInputStream)this.in).refresh();
            ((ServeOutputStream)this.out).refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block27: {
                try {
                    this.in = new ServeInputStream(this.socket.getInputStream());
                    this.out = new ServeOutputStream(this.socket.getOutputStream(), this);
                    do {
                        this.restart();
                        this.parseRequest();
                        if (this.reqMethod != null && this.serve.isAccessLogged()) {
                            this.logPlaceholders[0] = this.socket.getInetAddress();
                            this.logPlaceholders[1] = "-";
                            this.logPlaceholders[2] = this.remoteUser == null ? "-" : this.remoteUser;
                            this.logPlaceholders[3] = new Date(this.lastRun);
                            this.logPlaceholders[4] = this.reqMethod;
                            this.logPlaceholders[5] = this.reqUriPath;
                            this.logPlaceholders[6] = this.reqProtocol;
                            this.logPlaceholders[7] = new Integer(this.resCode);
                            this.logPlaceholders[8] = new Long(((ServeOutputStream)this.out).lengthWritten());
                            this.logPlaceholders[9] = new Integer(this.socket.getLocalPort());
                            this.logPlaceholders[10] = this.serve.isShowReferer() ? this.getHeader("Referer") : "-";
                            this.logPlaceholders[11] = this.serve.isShowUserAgent() ? this.getHeader("User-Agent") : "-";
                            this.serve.logStream.println(this.accessFmt.format(this.logPlaceholders));
                        }
                        this.lastRun = 0L;
                        ++this.timesRequested;
                    } while (this.keepAlive && this.serve.isKeepAlive() && this.timesRequested < this.serve.getMaxTimesConnectionUse());
                }
                catch (IOException iOException) {
                    String string = iOException.getMessage();
                    if (!(string != null && string.indexOf("ocket closed") >= 0 || iOException instanceof AsynchronousCloseException)) {
                        this.serve.log("IO error: " + iOException + " in processing a request from " + this.socket.getInetAddress() + ":" + this.socket.getLocalPort() + " / " + this.socket.getClass().getName());
                        break block27;
                    }
                    ServeConnection serveConnection = this;
                    synchronized (serveConnection) {
                        this.socket = null;
                    }
                }
                finally {
                    ServeConnection serveConnection = this;
                    synchronized (serveConnection) {
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        this.socket = null;
                    }
                }
            }
        }

        private void parseRequest() throws IOException {
            Object[] objectArray;
            String string;
            String string2;
            int n;
            byte[] byArray = new byte[4096];
            this.lastWait = System.currentTimeMillis();
            int n2 = this.in.readLine(byArray, 0, byArray.length);
            if (n2 == -1 || n2 == 0) {
                if (this.keepAlive) {
                    this.keepAlive = false;
                } else {
                    this.problem("Status-Code 400: Bad Request(empty)", 400);
                }
                return;
            }
            if (n2 >= byArray.length) {
                this.problem("Status-Code 414: Request-URI Too Long", 414);
                return;
            }
            String string3 = new String(byArray, 0, n2, Serve.UTF8);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            if (stringTokenizer.hasMoreTokens()) {
                this.reqMethod = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    this.reqUriPath = stringTokenizer.nextToken();
                    n = this.reqUriPath.indexOf(SESSION_URL_NAME);
                    if (n > 0) {
                        this.sessionUrlValue = this.reqUriPath.substring(n + SESSION_URL_NAME.length());
                        this.reqUriPath = this.reqUriPath.substring(0, n);
                        try {
                            this.serve.getSession(this.sessionUrlValue).userTouch();
                        }
                        catch (NullPointerException nullPointerException) {
                            this.sessionUrlValue = null;
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.sessionUrlValue = null;
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        this.reqProtocol = stringTokenizer.nextToken();
                        this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                        this.reqMime = true;
                        while ((string2 = ((ServeInputStream)this.in).readLine()) != null && string2.length() != 0) {
                            int n3 = string2.indexOf(58, 0);
                            if (n3 > 0) {
                                String string4 = string2.substring(0, n3).trim().toLowerCase();
                                String string5 = string2.substring(n3 + 1).trim();
                                this.reqHeaderNames.addElement(string4);
                                this.reqHeaderValues.addElement(string5);
                                if (CONNECTION.equalsIgnoreCase(string4)) {
                                    if (this.oneOne) {
                                        this.keepAlive = !"close".equalsIgnoreCase(string5);
                                        continue;
                                    }
                                    this.keepAlive = KEEPALIVE.equalsIgnoreCase(string5);
                                    continue;
                                }
                                if (!KEEPALIVE.equalsIgnoreCase(string4)) continue;
                            }
                            this.serve.log("header field '" + string2 + "' without ':'");
                        }
                    } else {
                        this.reqProtocol = "HTTP/0.9";
                        this.oneOne = false;
                        this.reqMime = false;
                    }
                }
            }
            if (this.reqProtocol == null) {
                this.problem("Status-Code 400: Malformed request line:" + string3, 400);
                return;
            }
            if (this.oneOne && (string = this.getHeader(HOST)) == null) {
                this.problem("'Host' header missing in HTTP/1.1 request", 400);
                return;
            }
            n = this.reqUriPath.indexOf(63);
            if (n > -1) {
                if (n < this.reqUriPath.length() - 1) {
                    this.reqQuery = this.reqUriPath.substring(n + 1);
                }
                this.reqUriPath = Utils.decode(this.reqUriPath.substring(0, n), Serve.UTF8);
            } else {
                this.reqUriPath = Utils.decode(this.reqUriPath, Serve.UTF8);
            }
            if (CHUNKED.equals(this.getHeader(TRANSFERENCODING))) {
                this.setHeader(CONTENTLENGTH, null);
                ((ServeInputStream)this.in).chunking(true);
            }
            if ((string2 = this.getHeader(CONTENTLENGTH)) != null) {
                try {
                    ((ServeInputStream)this.in).setContentLength(Long.parseLong(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.serve.log("Invalid value of input content-length: " + string2);
                }
            }
            if (this.assureHeaders() && !this.socket.getKeepAlive()) {
                this.socket.setKeepAlive(true);
            }
            if ((objectArray = this.serve.registry.get(this.reqUriPath))[0] != null) {
                this.lastRun = System.currentTimeMillis();
                this.uriLen = (Integer)objectArray[1];
                this.runServlet((HttpServlet)objectArray[0]);
            } else {
                this.problem("No any servlet found for serving " + this.reqUriPath, 400);
            }
            this.skipPostData();
        }

        private boolean assureHeaders() {
            if (this.reqMime) {
                this.setHeader("MIME-Version", "1.0");
            }
            this.setDateHeader("Date", System.currentTimeMillis());
            this.setHeader("Server", "Rogatkin's JWS based on Acme.Serve/Version 1.31, $Revision: 1.151 $");
            if (this.keepAlive && this.serve.isKeepAlive()) {
                if (this.reqMime) {
                    this.setHeader(CONNECTION, KEEPALIVE);
                    if (this.oneOne) {
                        this.setHeader(KEEPALIVE, this.serve.getKeepAliveParamStr());
                    }
                }
                return true;
            }
            this.setHeader(CONNECTION, "close");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runServlet(HttpServlet httpServlet) throws IOException {
            this.setStatus(200);
            try {
                this.parseCookies();
                if (this.sessionValue == null) {
                    this.sessionValue = this.sessionUrlValue;
                }
                if (this.authenificate()) {
                    if (httpServlet instanceof SingleThreadModel) {
                        HttpServlet httpServlet2 = httpServlet;
                        synchronized (httpServlet2) {
                            httpServlet.service((ServletRequest)this, (ServletResponse)this);
                        }
                    } else {
                        httpServlet.service((ServletRequest)this, (ServletResponse)this);
                    }
                }
                this.close();
            }
            catch (UnavailableException unavailableException) {
                if (unavailableException.isPermanent()) {
                    this.serve.registry.remove(httpServlet);
                    httpServlet.destroy();
                } else if (unavailableException.getUnavailableSeconds() > 0) {
                    this.serve.log("Unsupported temporary unavailability  " + httpServlet);
                }
                this.problem(unavailableException.getMessage(), 503);
            }
            catch (ServletException servletException) {
                this.serve.log("Servlet exception", servletException);
                Throwable throwable = servletException.getRootCause();
                while (throwable != null) {
                    this.serve.log("Caused by", throwable);
                    if (throwable instanceof ServletException) {
                        throwable = ((ServletException)throwable).getRootCause();
                        continue;
                    }
                    throwable = throwable.getCause();
                }
                this.problem(servletException.toString(), 500);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                this.serve.log("Unexpected problem running servlet", exception);
                this.problem("Unexpected problem running servlet: " + exception.toString(), 500);
            }
        }

        private boolean authenificate() throws IOException {
            Object[] objectArray = this.serve.realms.get(this.reqUriPath);
            BasicAuthRealm basicAuthRealm = null;
            if (objectArray != null) {
                basicAuthRealm = (BasicAuthRealm)objectArray[0];
            }
            if (basicAuthRealm == null) {
                return true;
            }
            String string = this.getHeader("Authorization");
            if (string != null) {
                string = Utils.base64Decode(string.substring(string.indexOf(32) + 1), this.getCharacterEncoding());
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.remoteUser = string2;
                this.authType = "Basic";
                String string4 = (String)basicAuthRealm.get(string2);
                if (string4 != null && string4.equals(string3)) {
                    return true;
                }
            }
            this.setStatus(401);
            this.setHeader("WWW-Authenticate", "basic realm=\"" + basicAuthRealm.name() + '\"');
            this.realSendError();
            return false;
        }

        private void problem(String string, int n) {
            this.serve.log(string);
            try {
                this.sendError(n, string);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void parseCookies() throws IOException {
            String string;
            if (this.inCookies == null) {
                this.inCookies = new Vector();
            }
            if ((string = this.getHeader(COOKIE)) == null) {
                return;
            }
            try {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                if (string.length() > 1228800) {
                    throw new IOException("Cookie string too long:" + string.length());
                }
                char[] cArray = string.toCharArray();
                int n = 1;
                StringBuffer stringBuffer = new StringBuffer(256);
                boolean bl = false;
                block22: for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    switch (n) {
                        case 1: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 2;
                                continue block22;
                            }
                            n = 3;
                            continue block22;
                        }
                        case 3: {
                            if (c == '=') {
                                n = 4;
                                string2 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && stringBuffer.length() <= 0) continue block22;
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 4: {
                            if (!bl) {
                                if (c == ';') {
                                    n = 3;
                                    string3 = stringBuffer.toString();
                                    stringBuffer.setLength(0);
                                    this.addCookie(string2, string3, null, null);
                                    continue block22;
                                }
                                if (c == '\"' && stringBuffer.length() == 0) {
                                    bl = true;
                                    continue block22;
                                }
                                stringBuffer.append(c);
                                continue block22;
                            }
                            if (c == '\"') {
                                bl = false;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 2: {
                            if (c == '=') {
                                if ("$Version".equals(stringBuffer.toString())) {
                                    n = 5;
                                } else {
                                    n = 4;
                                    string2 = stringBuffer.toString();
                                }
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 5: {
                            if (c == ',' || c == ';') {
                                stringBuffer.setLength(0);
                                n = 7;
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                n = 6;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 7: {
                            if (c == '=') {
                                n = 8;
                                string2 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && stringBuffer.length() <= 0) continue block22;
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 8: {
                            if (c == ';') {
                                n = 10;
                                string3 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                string4 = null;
                                continue block22;
                            }
                            if (c == ',') {
                                n = 7;
                                string3 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                this.addCookie(string2, string3, null, null);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 10: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 9;
                                continue block22;
                            }
                            this.addCookie(string2, string3, null, null);
                            n = 7;
                            continue block22;
                        }
                        case 9: {
                            if (c == '=') {
                                if ("$Path".equals(stringBuffer.toString())) {
                                    n = 11;
                                } else {
                                    this.addCookie(string2, string3, null, null);
                                    n = 8;
                                    string2 = stringBuffer.toString();
                                }
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 11: {
                            if (c == ',') {
                                string4 = stringBuffer.toString();
                                n = 7;
                                this.addCookie(string2, string3, string4, null);
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                n = 14;
                                string4 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 14: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 13;
                                continue block22;
                            }
                            this.addCookie(string2, string3, string4, null);
                            n = 7;
                            continue block22;
                        }
                        case 13: {
                            if (c != '=') continue block22;
                            if ("$Domain".equals(stringBuffer.toString())) {
                                n = 16;
                            } else {
                                this.addCookie(string2, string3, string4, null);
                                n = 8;
                                string2 = stringBuffer.toString();
                            }
                            stringBuffer.setLength(0);
                            continue block22;
                        }
                        case 16: {
                            if (c == ',') {
                                n = 7;
                                this.addCookie(string2, string3, string4, stringBuffer.toString());
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                string5 = stringBuffer.toString();
                                n = 12;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 12: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 15;
                                continue block22;
                            }
                            this.addCookie(string2, string3, string4, string5);
                            n = 7;
                            continue block22;
                        }
                        case 15: {
                            if (c != '=') continue block22;
                            if ("$Port".equals(stringBuffer.toString())) {
                                n = 17;
                            } else {
                                this.addCookie(string2, string3, string4, string5);
                                n = 8;
                                string2 = stringBuffer.toString();
                            }
                            stringBuffer.setLength(0);
                            continue block22;
                        }
                        case 17: {
                            if (c == ',' || c == ';') {
                                int n2 = Integer.parseInt(stringBuffer.toString());
                                n = 7;
                                this.addCookie(string2, string3, string4, string5);
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                n = 6;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 6: {
                            this.serve.log("Parsing recover of cookie string " + string, null);
                            if (c != ';' && c != ',') continue block22;
                            stringBuffer.setLength(0);
                            n = 7;
                        }
                    }
                }
                if (n == 4 || n == 8) {
                    string3 = stringBuffer.toString();
                    this.addCookie(string2, string3, null, null);
                } else if (n == 11) {
                    this.addCookie(string2, string3, stringBuffer.toString(), null);
                } else if (n == 16) {
                    this.addCookie(string2, string3, string4, stringBuffer.toString());
                } else if (n == 17) {
                    this.addCookie(string2, string3, string4, string5);
                }
            }
            catch (Error error) {
                this.serve.log("Error in parsing cookies: " + string, error);
            }
            catch (Exception exception) {
                this.serve.log("An exception in parsing cookies: " + string, exception);
            }
        }

        private void addCookie(String string, String string2, String string3, String string4) {
            if (SESSION_COOKIE_NAME.equals(string) && this.sessionCookieValue == null) {
                this.sessionCookieValue = string2;
                try {
                    this.serve.getSession(this.sessionCookieValue).userTouch();
                    this.sessionValue = this.sessionCookieValue;
                    this.sessionUrlValue = null;
                }
                catch (IllegalStateException illegalStateException) {
                    this.sessionCookieValue = null;
                }
                catch (NullPointerException nullPointerException) {
                    this.sessionCookieValue = null;
                }
            } else {
                Cookie cookie = new Cookie(string, string2);
                this.inCookies.addElement(cookie);
                if (string3 != null) {
                    cookie.setPath(string3);
                    if (string4 != null) {
                        cookie.setDomain(string4);
                    }
                }
            }
        }

        public int getContentLength() {
            return this.getIntHeader(CONTENTLENGTH);
        }

        public String getContentType() {
            return this.getHeader(CONTENTTYPE);
        }

        public String getProtocol() {
            return this.reqProtocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getScheme() {
            if (this.scheme == null) {
                ServeConnection serveConnection = this;
                synchronized (serveConnection) {
                    if (this.scheme == null) {
                        this.scheme = this.socket.getClass().getName().indexOf("SSLSocket") > 0 ? "https" : "http";
                    }
                }
            }
            return this.scheme;
        }

        public String getServerName() {
            int n;
            String string = this.getHeader(HOST);
            if (string != null && string.length() > 0 && (n = string.indexOf(58)) >= 0 && n < string.length()) {
                string = string.substring(0, n);
            }
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "127.0.0.0";
                }
            }
            if ((n = string.indexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }

        public int getServerPort() {
            return this.socket.getLocalPort();
        }

        public String getRemoteAddr() {
            return this.socket.getInetAddress().getHostAddress();
        }

        public String getRemoteHost() {
            String string = this.socket.getInetAddress().getHostName();
            return string != null ? string : this.getRemoteAddr();
        }

        public String getRealPath(String string) {
            return this.serve.getRealPath(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletInputStream getInputStream() throws IOException {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsReader()) {
                    throw new IllegalStateException("Already returned as a reader.");
                }
                ((ServeInputStream)this.in).setReturnedAsStream(true);
            }
            return this.in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedReader getReader() {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsStream()) {
                    throw new IllegalStateException("Already returned as a stream.");
                }
                ((ServeInputStream)this.in).setReturnedAsReader(true);
            }
            if (this.charEncoding != null) {
                try {
                    return new BufferedReader(new InputStreamReader((InputStream)this.in, this.charEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return new BufferedReader(new InputStreamReader((InputStream)this.in));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skipPostData() {
            if (this.postCache == null && "POST".equals(this.reqMethod) && WWWFORMURLENCODE.equals(this.getContentType())) {
                ServletInputStream servletInputStream = null;
                int n = this.getContentLength();
                try {
                    long l;
                    servletInputStream = this.getInputStream();
                    while (n > 0 && (l = servletInputStream.skip(n)) > 0L) {
                        n = (int)((long)n - l);
                    }
                }
                catch (IOException iOException) {
                    this.serve.log("IOException " + iOException + " at skipping 'POST' data of length " + n);
                }
                finally {
                    if (servletInputStream != null) {
                        try {
                            servletInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Map getParametersFromRequest() {
            Map map = null;
            if ("GET".equals(this.reqMethod)) {
                if (this.reqQuery != null) {
                    try {
                        map = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.serve.log("Exception " + illegalArgumentException + " at parsing 'get' data " + this.reqQuery);
                    }
                }
            } else if ("POST".equals(this.reqMethod)) {
                if (WWWFORMURLENCODE.equals(this.getContentType())) {
                    if (this.postCache == null) {
                        this.postCache = new String[1];
                        ServletInputStream servletInputStream = null;
                        try {
                            servletInputStream = this.getInputStream();
                            map = Utils.parsePostData(this.getContentLength(), (InputStream)servletInputStream, this.charEncoding, this.postCache);
                        }
                        catch (Exception exception) {
                            this.serve.log("Exception " + exception + " at parsing 'POST' data of length " + this.getContentLength());
                            Map map2 = EMPTYHASHTABLE;
                            return map2;
                        }
                        finally {
                            if (servletInputStream != null) {
                                try {
                                    servletInputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    map = Utils.parseQueryString(this.postCache[0], this.charEncoding);
                    if (this.reqQuery != null && this.reqQuery.length() > 0) {
                        map.putAll(Utils.parseQueryString(this.reqQuery, this.charEncoding));
                    }
                } else if (this.reqQuery != null) {
                    map = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                }
            }
            return map != null ? map : EMPTYHASHTABLE;
        }

        public synchronized Enumeration getParameterNames() {
            if (this.formParameters == null) {
                this.formParameters = this.getParametersFromRequest();
            }
            return ((Hashtable)this.formParameters).keys();
        }

        public String getParameter(String string) {
            String[] stringArray = this.getParameterValues(string);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            return stringArray[0];
        }

        public synchronized String[] getParameterValues(String string) {
            if (this.formParameters == null) {
                this.getParameterNames();
            }
            return (String[])this.formParameters.get(string);
        }

        public Object getAttribute(String string) {
            return this.attributes.get(string);
        }

        public Cookie[] getCookies() {
            Object[] objectArray = new Cookie[this.inCookies.size()];
            this.inCookies.copyInto(objectArray);
            return objectArray;
        }

        public String getMethod() {
            return this.reqMethod;
        }

        public String getRequestURI() {
            return this.reqUriPath;
        }

        public StringBuffer getRequestURL() {
            int n = this.getServerPort();
            return new StringBuffer().append(this.getScheme()).append("://").append(this.serve.hostName).append("https".equals(this.getScheme()) && n == 443 || n == 80 ? "" : ":" + String.valueOf(n)).append(this.getRequestURI());
        }

        public String getServletPath() {
            return this.uriLen > 0 ? this.reqUriPath.substring(0, this.uriLen) : "";
        }

        public String getPathInfo() {
            return this.uriLen >= this.reqUriPath.length() ? null : this.reqUriPath.substring(this.uriLen);
        }

        public String getPathTranslated() {
            return this.getRealPath(this.getPathInfo());
        }

        public String getQueryString() {
            return this.reqQuery;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getHeader(String string) {
            int n = this.reqHeaderNames.indexOf(string.toLowerCase());
            if (n == -1) {
                return null;
            }
            return (String)this.reqHeaderValues.elementAt(n);
        }

        public int getIntHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1;
            }
            return Integer.parseInt(string2);
        }

        public long getDateHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1L;
            }
            try {
                return this.headerdateformat.parse(string2).getTime();
            }
            catch (ParseException parseException) {
                try {
                    return this.rfc850DateFmt.parse(string2).getTime();
                }
                catch (ParseException parseException2) {
                    try {
                        return this.asciiDateFmt.parse(string2).getTime();
                    }
                    catch (ParseException parseException3) {
                        throw new IllegalArgumentException("Value " + string2 + " can't be converted to Date using any of formats: [" + this.headerdateformat.toPattern() + "][ " + this.rfc850DateFmt.toPattern() + "][" + this.asciiDateFmt.toPattern());
                    }
                }
            }
        }

        public Enumeration getHeaderNames() {
            return this.reqHeaderNames.elements();
        }

        public synchronized HttpSession getSession(boolean bl) {
            AcmeSession acmeSession = null;
            if (this.sessionValue != null && (acmeSession = this.serve.getSession(this.sessionValue)) != null && !acmeSession.isValid()) {
                this.serve.removeSession(this.sessionValue);
                acmeSession = null;
            }
            if (acmeSession == null && bl) {
                acmeSession = this.serve.createSession();
                if (acmeSession != null) {
                    this.sessionValue = acmeSession.getId();
                } else {
                    throw new RuntimeException("Session can't be created");
                }
            }
            return acmeSession;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public Enumeration getAttributeNames() {
            return this.attributes.keys();
        }

        public void setAttribute(String string, Object object) {
            if (object != null) {
                this.attributes.put(string, object);
            } else {
                this.attributes.remove(string);
            }
        }

        public String getRequestedSessionId() {
            return this.sessionValue;
        }

        public boolean isRequestedSessionIdValid() {
            if (this.sessionValue != null) {
                AcmeSession acmeSession = this.serve.getSession(this.sessionValue);
                return acmeSession != null && acmeSession.isValid();
            }
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.sessionCookieValue != null;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.sessionUrlValue != null;
        }

        public void setContentLength(int n) {
            if (n >= 0) {
                this.setIntHeader(CONTENTLENGTH, n);
            } else {
                this.setHeader(CONTENTLENGTH, null);
            }
        }

        public void setContentType(String string) {
            this.setHeader(CONTENTTYPE, string != null ? string : "Unknown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletOutputStream getOutputStream() {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.rout == null) {
                    if (this.pw != null) {
                        throw new IllegalStateException("Already returned as a writer");
                    }
                    this.rout = this.out;
                }
            }
            return this.rout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter getWriter() throws IOException {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.pw == null) {
                    if (this.rout != null) {
                        throw new IllegalStateException("Already was returned as servlet output stream");
                    }
                    String string = this.getCharacterEncoding();
                    this.pw = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.out, string)) : new PrintWriter((OutputStream)this.out);
                }
            }
            return this.pw;
        }

        public String getCharacterEncoding() {
            int n;
            String string = (String)this.resHeaderNames.get(CONTENTTYPE.toLowerCase());
            if (string != null && (n = string.indexOf(59)) > 0 && (n = string.toLowerCase().indexOf("charset=", n)) >= 0) {
                int n2;
                if ((n = (string = string.substring(n + 8)).indexOf(32)) > 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(59)) > 0) {
                    string = string.substring(0, n);
                }
                if ((n2 = string.length()) > 2 && string.charAt(0) == '\"') {
                    return string.substring(1, n2 - 1);
                }
                return string;
            }
            return this.charEncoding;
        }

        public void flushBuffer() throws IOException {
            ((ServeOutputStream)this.out).flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetBuffer() {
            ((ServeOutputStream)this.out).reset();
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.headersWritten = false;
            }
        }

        public int getBufferSize() {
            return ((ServeOutputStream)this.out).getBufferSize();
        }

        public void setBufferSize(int n) {
            ((ServeOutputStream)this.out).setBufferSize(n);
        }

        public boolean isCommitted() {
            return this.headersWritten && ((ServeOutputStream)this.out).lengthWritten() > 0L;
        }

        public void reset() throws IllegalStateException {
            if (!this.isCommitted()) {
                if (this.outCookies != null) {
                    this.outCookies.clear();
                }
            } else {
                throw new IllegalStateException("Header have already been committed.");
            }
            this.resHeaderNames.clear();
            this.pw = null;
            this.rout = null;
            ((ServeOutputStream)this.out).reset();
            this.assureHeaders();
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            if (this.locale != null) {
                return this.locale;
            }
            Enumeration enumeration = this.getLocales();
            if (enumeration.hasMoreElements()) {
                return (Locale)enumeration.nextElement();
            }
            return Locale.getDefault();
        }

        public Enumeration getLocales() {
            String string = this.getHeader(ACCEPT_LANGUAGE);
            TreeSet<LocaleWithWeight> treeSet = new TreeSet<LocaleWithWeight>();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken(";");
                        String string3 = stringTokenizer.nextToken(";=");
                        string3 = stringTokenizer.nextToken("=,");
                        float f = 0.0f;
                        try {
                            f = Float.valueOf(string3).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (!(f > 0.0f)) continue;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ", ", false);
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string4 = stringTokenizer2.nextToken();
                            int n = string4.indexOf(45);
                            if (n < 0) {
                                treeSet.add(new LocaleWithWeight(new Locale(string4.trim()), f));
                                continue;
                            }
                            treeSet.add(new LocaleWithWeight(new Locale(string4.substring(0, n), string4.substring(n + 1).trim().toUpperCase()), f));
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (treeSet.size() == 0) {
                treeSet.add(new LocaleWithWeight(Locale.getDefault(), 1.0f));
            }
            return new AcceptLocaleEnumeration(treeSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCharacterEncoding(String string) {
            this.charEncoding = string;
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.formParameters = null;
            }
        }

        public void addDateHeader(String string, long l) {
            this.addHeader(string, this.headerdateformat.format(new Date(l)));
        }

        public void addHeader(String string, String string2) {
            Object v = this.resHeaderNames.get(string = string.trim().toLowerCase());
            if (v == null) {
                this.setHeader(string, string2);
            } else if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string2;
                this.resHeaderNames.put(string, stringArray2);
            } else if (v instanceof String) {
                String[] stringArray = new String[]{(String)v, string2};
                this.resHeaderNames.put(string, stringArray);
            } else {
                throw new RuntimeException("Invalid content of header hash - " + v.getClass().getName());
            }
        }

        public void addIntHeader(String string, int n) {
            this.addHeader(string, Integer.toString(n));
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            if (string.length() > 0 && string.charAt(0) != '/') {
                int n;
                String string2 = this.getContextPath() + this.getServletPath();
                String string3 = this.getPathInfo();
                if (string3 != null && (n = string3.indexOf(47, 1)) > 0) {
                    string2 = string2 + string3.substring(0, n - 1);
                }
                string = string2 + '/' + string;
            }
            return this.serve.getRequestDispatcher(string);
        }

        public boolean isSecure() {
            return "https".equals(this.getScheme());
        }

        public void removeAttribute(String string) {
            this.attributes.remove(string);
        }

        public String getContextPath() {
            return "";
        }

        public Enumeration getHeaders(String string) {
            Vector vector = new Vector();
            int n = -1;
            while ((n = this.reqHeaderNames.indexOf(string.toLowerCase(), n + 1)) >= 0) {
                vector.addElement(this.reqHeaderValues.elementAt(n));
            }
            return vector.elements();
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String string) {
            return false;
        }

        public synchronized Map getParameterMap() {
            if (this.formParameters == null) {
                this.getParameterNames();
            }
            return this.formParameters;
        }

        public void addCookie(Cookie cookie) {
            if (this.outCookies == null) {
                this.outCookies = new Vector();
            }
            this.outCookies.addElement(cookie);
        }

        public boolean containsHeader(String string) {
            return this.resHeaderNames.contains(string);
        }

        public String encodeURL(String string) {
            int n = string.indexOf(SESSION_URL_NAME);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (this.sessionValue == null || this.isRequestedSessionIdFromCookie()) {
                return string;
            }
            try {
                new URL(string);
                int n2 = string.indexOf(47);
                if (n2 < 0) {
                    n2 = string.indexOf(63);
                }
                if (n2 < 0) {
                    n2 = string.indexOf(35);
                }
                if (n2 < 0) {
                    n2 = string.length();
                }
                if (!string.regionMatches(true, 0, this.getRequestURL().toString(), 0, n2)) {
                    return string;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return string + SESSION_URL_NAME + this.sessionValue;
        }

        public String encodeRedirectURL(String string) {
            return this.encodeURL(string);
        }

        public int getRemotePort() {
            return this.socket.getPort();
        }

        public String getLocalName() {
            InetAddress inetAddress = this.socket.getLocalAddress();
            return inetAddress == null ? null : inetAddress.getHostAddress();
        }

        public String getLocalAddr() {
            InetAddress inetAddress = this.socket.getLocalAddress();
            return inetAddress == null ? null : inetAddress.getCanonicalHostName();
        }

        public int getLocalPort() {
            return this.getServerPort();
        }

        public void setStatus(int n, String string) {
            this.resCode = n;
            this.resMessage = string;
        }

        public void setStatus(int n) {
            switch (n) {
                case 100: {
                    this.setStatus(n, "Continue");
                    break;
                }
                case 101: {
                    this.setStatus(n, "Switching protocols");
                    break;
                }
                case 200: {
                    this.setStatus(n, "Ok");
                    break;
                }
                case 201: {
                    this.setStatus(n, "Created");
                    break;
                }
                case 202: {
                    this.setStatus(n, "Accepted");
                    break;
                }
                case 203: {
                    this.setStatus(n, "Non-authoritative");
                    break;
                }
                case 204: {
                    this.setStatus(n, "No content");
                    break;
                }
                case 205: {
                    this.setStatus(n, "Reset content");
                    break;
                }
                case 206: {
                    this.setStatus(n, "Partial content");
                    break;
                }
                case 300: {
                    this.setStatus(n, "Multiple choices");
                    break;
                }
                case 301: {
                    this.setStatus(n, "Moved permanentently");
                    break;
                }
                case 302: {
                    this.setStatus(n, "Moved temporarily");
                    break;
                }
                case 303: {
                    this.setStatus(n, "See other");
                    break;
                }
                case 304: {
                    this.setStatus(n, "Not modified");
                    break;
                }
                case 305: {
                    this.setStatus(n, "Use proxy");
                    break;
                }
                case 400: {
                    this.setStatus(n, "Bad request");
                    break;
                }
                case 401: {
                    this.setStatus(n, "Unauthorized");
                    break;
                }
                case 402: {
                    this.setStatus(n, "Payment required");
                    break;
                }
                case 403: {
                    this.setStatus(n, "Forbidden");
                    break;
                }
                case 404: {
                    this.setStatus(n, "Not found");
                    break;
                }
                case 405: {
                    this.setStatus(n, "Method not allowed");
                    break;
                }
                case 406: {
                    this.setStatus(n, "Not acceptable");
                    break;
                }
                case 407: {
                    this.setStatus(n, "Proxy auth required");
                    break;
                }
                case 408: {
                    this.setStatus(n, "Request timeout");
                    break;
                }
                case 409: {
                    this.setStatus(n, "Conflict");
                    break;
                }
                case 410: {
                    this.setStatus(n, "Gone");
                    break;
                }
                case 411: {
                    this.setStatus(n, "Length required");
                    break;
                }
                case 412: {
                    this.setStatus(n, "Precondition failed");
                    break;
                }
                case 413: {
                    this.setStatus(n, "Request entity too large");
                    break;
                }
                case 414: {
                    this.setStatus(n, "Request URI too long");
                    break;
                }
                case 415: {
                    this.setStatus(n, "Unsupported media type");
                    break;
                }
                case 500: {
                    this.setStatus(n, "Internal server error");
                    break;
                }
                case 501: {
                    this.setStatus(n, "Not implemented");
                    break;
                }
                case 502: {
                    this.setStatus(n, "Bad gateway");
                    break;
                }
                case 503: {
                    this.setStatus(n, "Service unavailable");
                    break;
                }
                case 504: {
                    this.setStatus(n, "Gateway timeout");
                    break;
                }
                case 505: {
                    this.setStatus(n, "HTTP version not supported");
                    break;
                }
                case 207: {
                    this.setStatus(n, "Multi Status");
                    break;
                }
                default: {
                    this.setStatus(n, "");
                }
            }
        }

        public void setHeader(String string, String string2) {
            string = string.trim().toLowerCase();
            if (string2 == null) {
                this.resHeaderNames.remove(string);
            } else {
                this.resHeaderNames.put(string, string2);
            }
        }

        public void setIntHeader(String string, int n) {
            this.setHeader(string, Integer.toString(n));
        }

        public void setLongHeader(String string, long l) {
            this.setHeader(string, Long.toString(l));
        }

        public void setDateHeader(String string, long l) {
            this.setHeader(string, this.headerdateformat.format(new Date(l)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeHeaders() throws IOException {
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                if (this.headersWritten) {
                    return;
                }
                this.headersWritten = true;
            }
            if (this.reqMime) {
                AcmeSession acmeSession;
                Cookie cookie;
                StringBuffer stringBuffer;
                CharSequence charSequence;
                boolean bl = false;
                boolean bl2 = false;
                if (this.resMessage.length() < 256) {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.replace('\r', '/').replace('\n', '/'));
                } else {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.substring(0, 255).replace('\r', '/').replace('\n', '/'));
                }
                Enumeration enumeration = this.resHeaderNames.keys();
                while (enumeration.hasMoreElements()) {
                    charSequence = (String)enumeration.nextElement();
                    stringBuffer = (StringBuffer)this.resHeaderNames.get(charSequence);
                    if (stringBuffer instanceof String) {
                        cookie = (Cookie)stringBuffer;
                        if (cookie == null) continue;
                        this.out.println((String)charSequence + ": " + (String)cookie);
                        if (!bl2 && CONTENTLENGTH.equals(charSequence)) {
                            try {
                                bl2 = Long.parseLong((String)cookie) > 0L;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl || !TRANSFERENCODING.equals(charSequence) || !CHUNKED.equals(cookie)) continue;
                        bl = true;
                        continue;
                    }
                    if (!(stringBuffer instanceof String[])) continue;
                    cookie = (Cookie)stringBuffer;
                    this.out.print((String)charSequence + ": " + (String)cookie[0]);
                    for (int i = 1; i < ((Cookie)cookie).length; ++i) {
                        this.out.print("," + (String)cookie[i]);
                    }
                    this.out.println();
                }
                charSequence = null;
                stringBuffer = null;
                cookie = null;
                if (this.sessionValue != null && (acmeSession = this.serve.getSession(this.sessionValue)) != null) {
                    if (acmeSession.isValid()) {
                        if (acmeSession.isNew()) {
                            cookie = new Cookie(SESSION_COOKIE_NAME, this.sessionValue);
                            if (this.serve.expiredIn < 0) {
                                cookie.setMaxAge(Math.abs(this.serve.expiredIn) * 60);
                            }
                            this.addCookie(cookie);
                        }
                    } else {
                        cookie = new Cookie(SESSION_COOKIE_NAME, "");
                        cookie.setMaxAge(0);
                        this.addCookie(cookie);
                    }
                }
                for (int i = 0; this.outCookies != null && i < this.outCookies.size(); ++i) {
                    cookie = (Cookie)this.outCookies.elementAt(i);
                    if (cookie.getSecure() && !this.isSecure()) continue;
                    int n = cookie.getVersion();
                    if (n > 1) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(SETCOOKIE + "2: ");
                        } else {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(cookie.getName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(cookie.getValue()).append('\"');
                        String string = cookie.getComment();
                        if (string != null) {
                            stringBuffer.append("; Comment=\"").append(string).append('\"');
                        }
                        if ((string = cookie.getDomain()) != null) {
                            stringBuffer.append("; Domain=\"").append(string).append('\"');
                        }
                        if (cookie.getMaxAge() >= 0) {
                            stringBuffer.append("; Max-Age=\"").append(cookie.getMaxAge()).append('\"');
                        }
                        if ((string = cookie.getPath()) != null) {
                            stringBuffer.append("; Path=\"").append(string).append('\"');
                        }
                        if (cookie.getSecure()) {
                            stringBuffer.append("; Secure");
                        }
                        stringBuffer.append("; Version=\"").append(n).append('\"');
                        continue;
                    }
                    if (charSequence == null) {
                        charSequence = new StringBuffer(SETCOOKIE + ": ");
                    } else {
                        ((StringBuffer)charSequence).append("\r\n" + SETCOOKIE + ": ");
                    }
                    ((StringBuffer)charSequence).append(cookie.getName());
                    ((StringBuffer)charSequence).append('=');
                    ((StringBuffer)charSequence).append(cookie.getValue());
                    if (cookie.getDomain() != null && cookie.getDomain().length() > 0) {
                        ((StringBuffer)charSequence).append("; domain=" + cookie.getDomain());
                    }
                    if (cookie.getMaxAge() >= 0) {
                        ((StringBuffer)charSequence).append("; expires=");
                        ((StringBuffer)charSequence).append(this.expdatefmt.format(new Date(new Date().getTime() + 1000L * (long)cookie.getMaxAge())));
                    }
                    if (cookie.getPath() != null && cookie.getPath().length() > 0) {
                        ((StringBuffer)charSequence).append("; path=" + cookie.getPath());
                    }
                    if (!cookie.getSecure()) continue;
                    ((StringBuffer)charSequence).append("; secure");
                }
                if (charSequence != null) {
                    this.out.println(((StringBuffer)charSequence).toString());
                }
                if (stringBuffer != null) {
                    this.out.println(stringBuffer.toString());
                }
                if (!bl2 && !bl && this.serve.isKeepAlive()) {
                    this.out.println(TRANSFERENCODING + ": " + CHUNKED);
                    bl = true;
                }
                this.out.println();
                this.out.flush();
                ((ServeOutputStream)this.out).setChunked(bl);
            }
        }

        public void sendError(int n, String string) throws IOException {
            this.setStatus(n, string);
            this.realSendError();
        }

        public void sendError(int n) throws IOException {
            this.setStatus(n);
            this.realSendError();
        }

        public void setInInclude(boolean bl) {
            ((ServeOutputStream)this.out).setInInclude(bl);
        }

        private void realSendError() throws IOException {
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not send error, headers have been already written");
            }
            this.setContentType("text/html");
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = this.resMessage.indexOf(10);
            stringBuffer.append("<HTML><HEAD>").append("<TITLE>" + this.resCode + " " + (n < 0 ? this.resMessage : this.resMessage.substring(0, n)) + "</TITLE>").append("</HEAD><BODY BGCOLOR=\"#D1E9FE\"").append("><H2>" + this.resCode + " " + (n < 0 ? this.resMessage : this.resMessage.substring(0, n)) + "</H2>");
            if (n > 0) {
                stringBuffer.append("<PRE>").append(Utils.htmlEncode(this.resMessage.substring(n), false)).append("</PRE>");
            }
            stringBuffer.append("<HR>");
            Identification.writeAddress(stringBuffer);
            stringBuffer.append("</BODY></HTML>");
            this.setContentLength(stringBuffer.length());
            this.out.print(stringBuffer.toString());
            this.out.flush();
            this.out.close();
        }

        public void sendRedirect(String string) throws IOException {
            CharSequence charSequence;
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not redirect, headers have been already written");
            }
            if (string.indexOf(":/") < 0) {
                charSequence = "";
                if ("https".equalsIgnoreCase(this.getScheme())) {
                    if (this.getServerPort() != 443) {
                        charSequence = ":" + this.getServerPort();
                    }
                } else if (this.getServerPort() != 80) {
                    charSequence = ":" + this.getServerPort();
                }
                if (string.length() > 0 && string.charAt(0) == '/') {
                    string = this.getScheme() + "://" + this.getServerName() + (String)charSequence + string;
                } else {
                    String string2;
                    int n = this.reqUriPath.lastIndexOf(47);
                    if (n < 0) {
                        string2 = this.reqUriPath + '/';
                        n = string2.length();
                    } else {
                        string2 = this.reqUriPath;
                        ++n;
                    }
                    string = this.getScheme() + "://" + this.getServerName() + (String)charSequence + string2.substring(0, n) + string;
                }
            }
            this.setHeader("Location", string);
            this.setStatus(302);
            this.setContentType("text/html");
            charSequence = new StringBuffer(200);
            ((StringBuffer)charSequence).append("<HTML><HEAD><TITLE>302 Moved</TITLE></HEAD><BODY BGCOLOR=\"#D1E9FE\"><H2>302 Moved</H2>This document has moved <a href=" + string + ">here.<HR>");
            Identification.writeAddress((StringBuffer)charSequence);
            ((StringBuffer)charSequence).append("</BODY></HTML>");
            this.setContentLength(((StringBuffer)charSequence).length());
            this.out.print(((StringBuffer)charSequence).toString());
            this.out.flush();
            this.out.close();
        }

        public String encodeUrl(String string) {
            return this.encodeURL(string);
        }

        public String encodeRedirectUrl(String string) {
            return this.encodeRedirectURL(string);
        }

        public Socket getSocket() {
            return this.socket;
        }

        static {
            tz.setID("GMT");
        }
    }

    protected static class ServeConfig
    implements ServletConfig {
        private ServletContext context;
        private Hashtable init_params;
        private String servletName;

        public ServeConfig(ServletContext servletContext) {
            this(servletContext, null, "undefined");
        }

        public ServeConfig(ServletContext servletContext, Hashtable hashtable, String string) {
            this.context = servletContext;
            this.init_params = hashtable;
            this.servletName = string;
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String string) {
            if (this.init_params != null) {
                return (String)this.init_params.get(string);
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            if (this.init_params != null) {
                return this.init_params.keys();
            }
            return new Vector().elements();
        }

        public String getServletName() {
            return this.servletName;
        }
    }

    static final class Identification {
        public static final String serverName = "Rogatkin's JWS based on Acme.Serve";
        public static final String serverVersion = "Version 1.31, $Revision: 1.151 $";
        public static final String serverUrl = "http://tjws.sourceforge.net";

        Identification() {
        }

        public static void writeAddress(OutputStream outputStream) throws IOException {
            PrintStream printStream = new PrintStream(outputStream);
            printStream.println("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">Rogatkin's JWS based on Acme.Serve Version 1.31, $Revision: 1.151 $</A></ADDRESS>");
        }

        public static void writeAddress(StringBuffer stringBuffer) throws IOException {
            stringBuffer.append("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">Rogatkin's JWS based on Acme.Serve Version 1.31, $Revision: 1.151 $</A></ADDRESS>");
        }
    }

    class KeepAliveCleaner
    extends Thread {
        protected List connections;
        protected List ingoings;
        protected boolean stopped;
        private boolean noCheckClose;

        KeepAliveCleaner() {
            super("KeepAlive cleaner");
            this.connections = new ArrayList();
            this.ingoings = new ArrayList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addConnection(ServeConnection serveConnection) {
            List list = this.ingoings;
            synchronized (list) {
                if (!this.stopped) {
                    this.ingoings.add(serveConnection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = Serve.this.getKeepAliveDuration();
            int n = Serve.this.getMaxTimesConnectionUse();
            while (true) {
                Object object = this.ingoings;
                synchronized (object) {
                    Iterator iterator = this.ingoings.iterator();
                    while (iterator.hasNext()) {
                        this.connections.add(iterator.next());
                        iterator.remove();
                    }
                }
                object = this.connections.iterator();
                long l2 = System.currentTimeMillis();
                l = Serve.this.getKeepAliveDuration();
                while (object.hasNext()) {
                    ServeConnection serveConnection;
                    boolean bl;
                    ServeConnection serveConnection2 = (ServeConnection)object.next();
                    boolean bl2 = bl = serveConnection2.socket == null;
                    if (!this.noCheckClose) {
                        serveConnection = serveConnection2;
                        synchronized (serveConnection) {
                            if (serveConnection2.socket != null) {
                                try {
                                    bl = (Boolean)serveConnection2.socket.getClass().getMethod("isClosed", Utils.EMPTY_CLASSES).invoke((Object)serveConnection2.socket, Utils.EMPTY_OBJECTS);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                }
                                catch (SecurityException securityException) {
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    this.noCheckClose = true;
                                }
                            }
                        }
                    }
                    if (!bl && (!serveConnection2.keepAlive || l2 - serveConnection2.lastWait <= l || serveConnection2.lastRun >= serveConnection2.lastWait) && !this.stopped) continue;
                    object.remove();
                    serveConnection = serveConnection2;
                    synchronized (serveConnection) {
                        if (serveConnection2.socket != null) {
                            try {
                                serveConnection2.socket.getInputStream().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.stopped && this.connections.size() == 0) break;
                try {
                    KeepAliveCleaner.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    this.stopped = true;
                }
            }
        }
    }

    protected class SimpleRequestDispatcher
    implements RequestDispatcher {
        HttpServlet servlet;
        String dispatchPath;
        String dispatchQuery;
        int dispatchLen;

        SimpleRequestDispatcher(String string) {
            Object[] objectArray = Serve.this.registry.get(string);
            this.servlet = (HttpServlet)objectArray[0];
            if (this.servlet == null) {
                throw new NullPointerException();
            }
            this.dispatchLen = (Integer)objectArray[1];
            int n = string.indexOf(63);
            if (n < 0 || n >= string.length() - 1) {
                this.dispatchPath = string;
            } else {
                this.dispatchPath = string.substring(0, n);
                this.dispatchQuery = string.substring(n + 1);
            }
        }

        public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            servletRequest.removeAttribute("javax.servlet.forward.request_uri");
            servletResponse.reset();
            this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                public String getPathInfo() {
                    return SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen);
                }

                public String getRequestURI() {
                    return SimpleRequestDispatcher.this.dispatchPath;
                }

                public String getQueryString() {
                    return SimpleRequestDispatcher.this.dispatchQuery;
                }

                public String getServletPath() {
                    return SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen);
                }

                public synchronized Enumeration getAttributeNames() {
                    if (super.getAttribute("javax.servlet.forward.request_uri") == null) {
                        this.setAttribute("javax.servlet.forward.request_uri", super.getRequestURI());
                        this.setAttribute("javax.servlet.forward.context_path", this.getContextPath());
                        this.setAttribute("javax.servlet.forward.servlet_path", super.getServletPath());
                        this.setAttribute("javax.servlet.forward.path_info", super.getPathInfo());
                        this.setAttribute("javax.servlet.forward.query_string", super.getQueryString());
                    }
                    return super.getAttributeNames();
                }

                public Object getAttribute(String string) {
                    this.getAttributeNames();
                    return super.getAttribute(string);
                }
            }, servletResponse);
            ((ServeConnection)servletResponse).close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            servletRequest.removeAttribute("javax.servlet.include.request_uri");
            ((ServeConnection)servletResponse).setInInclude(true);
            try {
                this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                    public synchronized Enumeration getAttributeNames() {
                        if (super.getAttribute("javax.servlet.include.request_uri") == null) {
                            this.setAttribute("javax.servlet.include.request_uri", SimpleRequestDispatcher.this.dispatchPath);
                            this.setAttribute("javax.servlet.include.context_path", this.getContextPath());
                            this.setAttribute("javax.servlet.include.servlet_path", SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.path_info", SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.query_string", SimpleRequestDispatcher.this.dispatchQuery);
                        }
                        return super.getAttributeNames();
                    }

                    public Object getAttribute(String string) {
                        this.getAttributeNames();
                        return super.getAttribute(string);
                    }
                }, servletResponse);
            }
            finally {
                ((ServeConnection)servletResponse).setInInclude(false);
            }
        }
    }

    public static interface Acceptor {
        public void init(Map var1, Map var2) throws IOException;

        public Socket accept() throws IOException;

        public void destroy() throws IOException;
    }
}

