/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.environment;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import uk.org.webcompere.systemstubs.properties.PropertiesUtils;
import uk.org.webcompere.systemstubs.resource.NameValuePairSetter;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;

public class EnvironmentVariables
extends SingularTestResource
implements NameValuePairSetter<EnvironmentVariables> {
    protected final Map<String, String> variables;
    private Map<String, String> originalEnvironment = null;

    public EnvironmentVariables() {
        this(Collections.emptyMap());
    }

    public EnvironmentVariables(String name, String value, String ... others) {
        if (others.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide even number of parameters");
        }
        this.variables = new HashMap<String, String>();
        this.variables.put(name, value);
        for (int i = 0; i < others.length; i += 2) {
            this.variables.put(others[i], others[i + 1]);
        }
    }

    public EnvironmentVariables(Properties properties) {
        this(PropertiesUtils.toStringMap(properties));
    }

    public EnvironmentVariables(Map<String, String> variables) {
        this.variables = new HashMap<String, String>(variables);
    }

    public EnvironmentVariables and(String name, String value) {
        this.validateNotSet(name, value);
        return new EnvironmentVariables(this.variables).set(name, value);
    }

    @Override
    public EnvironmentVariables set(String name, String value) {
        this.variables.put(name, value);
        if (this.isActive()) {
            this.setEnvironmentVariables();
        }
        return this;
    }

    public Map<String, String> getVariables() {
        return new HashMap<String, String>(this.variables);
    }

    private void validateNotSet(String name, String value) {
        if (this.variables.containsKey(name)) {
            String currentValue = this.variables.get(name);
            throw new IllegalArgumentException("The environment variable '" + name + "' cannot be set to " + this.format(value) + " because it was already set to " + this.format(currentValue) + ".");
        }
    }

    private String format(String text) {
        if (text == null) {
            return "null";
        }
        return "'" + text + "'";
    }

    @Override
    protected void doSetup() {
        this.originalEnvironment = new HashMap<String, String>(System.getenv());
        this.setEnvironmentVariables();
    }

    @Override
    protected void doTeardown() {
        this.restoreOriginalVariables(this.originalEnvironment);
    }

    private void setEnvironmentVariables() {
        this.overrideVariables(EnvironmentVariables.getEditableMapOfVariables());
        this.overrideVariables(EnvironmentVariables.getTheCaseInsensitiveEnvironment());
    }

    private void overrideVariables(Map<String, String> existingVariables) {
        if (existingVariables != null) {
            this.variables.forEach((name, value) -> this.setOrRemoveInMap(existingVariables, (String)name, (String)value));
        }
    }

    private void setOrRemoveInMap(Map<String, String> variables, String name, String value) {
        if (value == null) {
            variables.remove(name);
        } else {
            variables.put(name, value);
        }
    }

    void restoreOriginalVariables(Map<String, String> originalVariables) {
        this.restoreVariables(EnvironmentVariables.getEditableMapOfVariables(), originalVariables);
        this.restoreVariables(EnvironmentVariables.getTheCaseInsensitiveEnvironment(), originalVariables);
    }

    void restoreVariables(Map<String, String> variables, Map<String, String> originalVariables) {
        if (variables != null) {
            variables.clear();
            variables.putAll(originalVariables);
        }
    }

    private static Map<String, String> getEditableMapOfVariables() {
        Class<?> classOfMap = System.getenv().getClass();
        try {
            return EnvironmentVariables.getFieldValue(classOfMap, System.getenv(), "m");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access the field 'm' of the map System.getenv().", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Expects System.getenv() to have a field 'm' but it has not.", e);
        }
    }

    private static Map<String, String> getTheCaseInsensitiveEnvironment() {
        try {
            Class<?> processEnvironment = Class.forName("java.lang.ProcessEnvironment");
            return EnvironmentVariables.getFieldValue(processEnvironment, null, "theCaseInsensitiveEnvironment");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("System Rules expects the existence of the class java.lang.ProcessEnvironment but it does not exist.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("System Rules cannot access the static field 'theCaseInsensitiveEnvironment' of the class java.lang.ProcessEnvironment.", e);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Map<String, String> getFieldValue(Class<?> klass, Object object, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = klass.getDeclaredField(name);
        field.setAccessible(true);
        return (Map)field.get(object);
    }
}

