/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Supplier;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;
import uk.org.webcompere.systemstubs.stream.StreamException;
import uk.org.webcompere.systemstubs.stream.output.Output;
import uk.org.webcompere.systemstubs.stream.output.TapStream;

public class SystemStreamBase
extends SingularTestResource
implements Output<OutputStream> {
    private static final boolean AUTO_FLUSH = true;
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    protected PrintStream originalStream;
    protected Output<? extends OutputStream> target;
    protected Consumer<PrintStream> printStreamSetter;
    protected Supplier<PrintStream> printStreamGetter;

    protected <T extends OutputStream> SystemStreamBase(Consumer<PrintStream> printStreamSetter, Supplier<PrintStream> printStreamGetter) {
        this(new TapStream(), printStreamSetter, printStreamGetter);
    }

    protected <T extends OutputStream> SystemStreamBase(Output<? extends OutputStream> target, Consumer<PrintStream> printStreamSetter, Supplier<PrintStream> printStreamGetter) {
        this.target = target;
        this.printStreamSetter = printStreamSetter;
        this.printStreamGetter = printStreamGetter;
    }

    private static PrintStream wrap(OutputStream outputStream) throws UnsupportedEncodingException {
        return new PrintStream(outputStream, true, DEFAULT_ENCODING);
    }

    @Override
    protected void doSetup() throws Exception {
        this.clear();
        this.originalStream = this.printStreamGetter.get();
        try {
            this.printStreamSetter.accept(SystemStreamBase.wrap(this.target.getOutputStream()));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException("Cannot wrap stream: " + e.getMessage(), e);
        }
    }

    @Override
    protected void doTeardown() throws Exception {
        this.printStreamSetter.accept(this.originalStream);
    }

    @Override
    public String getText() {
        return this.target.getText();
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.target.getOutputStream();
    }
}

