/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.output;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Output<T extends OutputStream> {
    default public String getText() {
        return "";
    }

    default public void clear() {
    }

    public T getOutputStream();

    default public Stream<String> getLines() {
        return Arrays.stream(this.getText().split(Pattern.quote(System.lineSeparator())));
    }

    default public String getLinesNormalized() {
        return this.getLinesNormalized("\n");
    }

    default public String getLinesNormalized(String linebreak) {
        String combined = this.getLines().collect(Collectors.joining(linebreak));
        if (combined.isEmpty()) {
            return "";
        }
        return combined + linebreak;
    }
}

