/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.environment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We need to set up the stub, but interaction is set on construction")
public class EnvironmentVariableMocker {
    private static final Stack<Map<String, String>> REPLACEMENT_ENV = new Stack();
    private static final Set<String> MOCKED_METHODS = Stream.of("getenv", "environment", "toEnvironmentBlock").collect(Collectors.toSet());

    private static Map<String, String> getenv() {
        return REPLACEMENT_ENV.peek();
    }

    private static Object simulateToEnvironmentBlock(InvocationOnMock invocationOnMock) {
        if (invocationOnMock.getArguments().length == 1) {
            return EnvironmentVariableMocker.toEnvironmentBlockWindows((Map)invocationOnMock.getArgument(0));
        }
        return EnvironmentVariableMocker.toEnvironmentBlockNix((Map)invocationOnMock.getArgument(0), (int[])invocationOnMock.getArgument(1, int[].class));
    }

    private static String toEnvironmentBlockWindows(Map<String, String> m) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(m.entrySet());
        Collections.sort(list, (e1, e2) -> NameComparator.compareNames((String)e1.getKey(), (String)e2.getKey()));
        StringBuilder sb = new StringBuilder(m.size() * 30);
        int cmp = -1;
        String systemRoot = "SystemRoot";
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (cmp < 0 && (cmp = NameComparator.compareNames(key, "SystemRoot")) > 0) {
                EnvironmentVariableMocker.addToEnvIfSet(sb, "SystemRoot");
            }
            EnvironmentVariableMocker.addToEnv(sb, key, value);
        }
        if (cmp < 0) {
            EnvironmentVariableMocker.addToEnvIfSet(sb, "SystemRoot");
        }
        if (sb.length() == 0) {
            sb.append('\u0000');
        }
        sb.append('\u0000');
        return sb.toString();
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS", "DM_DEFAULT_ENCODING"})
    private static byte[] toEnvironmentBlockNix(Map<String, String> m, int[] envc) {
        if (m == null) {
            return null;
        }
        int count = m.size() * 2;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            count += entry.getKey().getBytes().length;
            count += entry.getValue().getBytes().length;
        }
        byte[] block = new byte[count];
        int i = 0;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            byte[] key = entry.getKey().getBytes();
            byte[] value = entry.getValue().getBytes();
            System.arraycopy(key, 0, block, i, key.length);
            i += key.length;
            block[i++] = 61;
            System.arraycopy(value, 0, block, i, value.length);
            i += value.length + 1;
        }
        envc[0] = m.size();
        return block;
    }

    private static Map<String, String> filterNulls(Map<String, String> currentMockedEnvironment) {
        return currentMockedEnvironment.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void connect(Map<String, String> newEnvironmentVariables) {
        System.getenv().entrySet().stream().filter(entry -> !newEnvironmentVariables.containsKey(entry.getKey())).forEach(entry -> {
            String cfr_ignored_0 = (String)newEnvironmentVariables.put((String)entry.getKey(), (String)entry.getValue());
        });
        REPLACEMENT_ENV.push(newEnvironmentVariables);
    }

    public static boolean pop() {
        if (!REPLACEMENT_ENV.empty()) {
            REPLACEMENT_ENV.pop();
        }
        return REPLACEMENT_ENV.empty();
    }

    public static boolean remove(Map<String, String> theOneToPop) {
        return REPLACEMENT_ENV.remove(theOneToPop);
    }

    private static void addToEnvIfSet(StringBuilder sb, String name) {
        String s = EnvironmentVariableMocker.getenv().get(name);
        if (s != null) {
            EnvironmentVariableMocker.addToEnv(sb, name, s);
        }
    }

    private static void addToEnv(StringBuilder sb, String name, String val) {
        sb.append(name).append('=').append(val).append('\u0000');
    }

    static {
        try {
            Class<?> typeToMock = Class.forName("java.lang.ProcessEnvironment");
            Mockito.mockStatic(typeToMock, invocationOnMock -> {
                if (REPLACEMENT_ENV.empty() || !MOCKED_METHODS.contains(invocationOnMock.getMethod().getName())) {
                    return invocationOnMock.callRealMethod();
                }
                if ("toEnvironmentBlock".equals(invocationOnMock.getMethod().getName())) {
                    return EnvironmentVariableMocker.simulateToEnvironmentBlock(invocationOnMock);
                }
                Map<String, String> currentMockedEnvironment = EnvironmentVariableMocker.getenv();
                if (invocationOnMock.getMethod().getParameterCount() == 0) {
                    return EnvironmentVariableMocker.filterNulls(currentMockedEnvironment);
                }
                return currentMockedEnvironment.get(invocationOnMock.getArgument(0, String.class));
            });
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot set up environment mocking: " + e.getMessage() + ". This may be a result of not having the right mockito-inline installed, or may be down to a Java internals change.", e);
        }
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return NameComparator.compareNames(s1, s2);
        }

        public static int compareNames(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

