/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.scanners;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import za.co.absa.cobrix.cobol.internal.Logging;
import za.co.absa.cobrix.cobol.reader.common.Constants$;
import za.co.absa.cobrix.cobol.reader.index.entry.SparseIndexEntry;
import za.co.absa.cobrix.spark.cobol.reader.FixedLenReader;
import za.co.absa.cobrix.spark.cobol.reader.VarLenReader;
import za.co.absa.cobrix.spark.cobol.source.SerializableConfiguration;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer$;
import za.co.absa.cobrix.spark.cobol.source.types.FileWithOrder;
import za.co.absa.cobrix.spark.cobol.utils.FileUtils$;

public final class CobolScanners$
implements Logging {
    public static CobolScanners$ MODULE$;
    private transient Logger za$co$absa$cobrix$cobol$internal$Logging$$log_;

    static {
        new CobolScanners$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public Logger za$co$absa$cobrix$cobol$internal$Logging$$log_() {
        return this.za$co$absa$cobrix$cobol$internal$Logging$$log_;
    }

    public void za$co$absa$cobrix$cobol$internal$Logging$$log__$eq(Logger x$1) {
        this.za$co$absa$cobrix$cobol$internal$Logging$$log_ = x$1;
    }

    public RDD<Row> buildScanForVarLenIndex(VarLenReader reader, RDD<SparseIndexEntry> indexes, FileWithOrder[] filesList, SQLContext sqlContext) {
        Map filesMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesList)).map((Function1 & Serializable & scala.Serializable)fileWithOrder -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)fileWithOrder.order()), (Object)fileWithOrder.filePath()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        return indexes.flatMap((Function1 & Serializable & scala.Serializable)indexEntry -> {
            String filePathName = (String)filesMap.apply((Object)BoxesRunTime.boxToInteger((int)indexEntry.fileId()));
            Path path = new Path(filePathName);
            FileSystem fileSystem = path.getFileSystem(sconf.value());
            String fileName = path.getName();
            long numOfBytes = indexEntry.offsetTo() > 0L ? indexEntry.offsetTo() - indexEntry.offsetFrom() : 0L;
            String numOfBytesMsg = numOfBytes > 0L ? new StringBuilder(3).append(numOfBytes / (long)Constants$.MODULE$.megabyte()).append(" MB").toString() : "until the end";
            MODULE$.logger().info(new StringBuilder(35).append("Going to process offsets ").append(indexEntry.offsetFrom()).append("...").append(indexEntry.offsetTo()).append(" (").append(numOfBytesMsg).append(") of ").append(fileName).toString());
            FileStreamer dataStream = new FileStreamer(filePathName, fileSystem, indexEntry.offsetFrom(), numOfBytes);
            return reader.getRowIterator(dataStream, indexEntry.offsetFrom(), indexEntry.fileId(), indexEntry.recordIndex());
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> buildScanForVariableLength(VarLenReader reader, FileWithOrder[] filesList, SQLContext sqlContext) {
        RDD filesRDD = sqlContext.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])filesList), filesList.length, ClassTag$.MODULE$.apply(FileWithOrder.class));
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        return filesRDD.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            String filePath = row.filePath();
            int fileOrder = row.order();
            Path path = new Path(filePath);
            FileSystem fileSystem = path.getFileSystem(sconf.value());
            MODULE$.logger().info(new StringBuilder(21).append("Going to parse file: ").append(filePath).toString());
            return reader.getRowIterator(new FileStreamer(filePath, fileSystem, FileStreamer$.MODULE$.$lessinit$greater$default$3(), FileStreamer$.MODULE$.$lessinit$greater$default$4()), 0L, fileOrder, 0L);
        }), filesRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> buildScanForFixedLength(FixedLenReader reader, Seq<String> sourceDirs, Function2<FixedLenReader, RDD<byte[]>, RDD<Row>> recordParser, boolean debugIgnoreFileSize, SQLContext sqlContext) {
        int recordSize = reader.getRecordSize();
        sourceDirs.foreach((Function1 & Serializable & scala.Serializable)sourceDir -> {
            CobolScanners$.$anonfun$buildScanForFixedLength$1(debugIgnoreFileSize, sqlContext, recordSize, sourceDir);
            return BoxedUnit.UNIT;
        });
        RDD records = (RDD)((TraversableOnce)sourceDirs.map((Function1 & Serializable & scala.Serializable)sourceDir -> sqlContext.sparkContext().binaryRecords(sourceDir, recordSize, sqlContext.sparkContext().hadoopConfiguration()), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.union(b));
        return (RDD)recordParser.apply((Object)reader, (Object)records);
    }

    public RDD<Row> buildScanForTextFiles(FixedLenReader reader, Seq<String> sourceDirs, Function2<FixedLenReader, RDD<byte[]>, RDD<Row>> recordParser, SQLContext sqlContext) {
        sqlContext.read().text((Seq)Nil$.MODULE$);
        RDD rddText = (RDD)((TraversableOnce)sourceDirs.map((Function1 & Serializable & scala.Serializable)sourceDir -> {
            SparkContext qual$1 = sqlContext.sparkContext();
            String x$1 = sourceDir;
            int x$2 = qual$1.textFile$default$2();
            return qual$1.textFile(x$1, x$2);
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.union(b));
        RDD records = rddText.filter((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToBoolean((boolean)CobolScanners$.$anonfun$buildScanForTextFiles$3(str))).map((Function1 & Serializable & scala.Serializable)str -> str.getBytes(StandardCharsets.UTF_8), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        return (RDD)recordParser.apply((Object)reader, (Object)records);
    }

    private boolean areThereNonDivisibleFiles(String sourceDir, Configuration hadoopConfiguration, int divisor) {
        FileSystem fileSystem = new Path(sourceDir).getFileSystem(hadoopConfiguration);
        return FileUtils$.MODULE$.getNumberOfFilesInDir(sourceDir, fileSystem) < FileUtils$.MODULE$.THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK() ? FileUtils$.MODULE$.findAndLogAllNonDivisibleFiles(sourceDir, divisor, fileSystem) > 0L : FileUtils$.MODULE$.findAndLogFirstNonDivisibleFile(sourceDir, divisor, fileSystem);
    }

    public static final /* synthetic */ void $anonfun$buildScanForFixedLength$1(boolean debugIgnoreFileSize$1, SQLContext sqlContext$1, int recordSize$1, String sourceDir) {
        if (!debugIgnoreFileSize$1 && MODULE$.areThereNonDivisibleFiles(sourceDir, sqlContext$1.sparkContext().hadoopConfiguration(), recordSize$1)) {
            throw new IllegalArgumentException(new StringBuilder(159).append("There are some files in ").append(sourceDir).append(" that are NOT DIVISIBLE by the RECORD SIZE calculated from the copybook (").append(recordSize$1).append(" bytes per record). Check the logs for the names of the files.").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildScanForTextFiles$3(String str) {
        return str.length() > 0;
    }

    private CobolScanners$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

