/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.streaming;

import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import scala.reflect.ScalaSignature;
import za.co.absa.cobrix.cobol.reader.common.Constants$;
import za.co.absa.cobrix.cobol.reader.stream.SimpleStream;
import za.co.absa.cobrix.spark.cobol.source.streaming.BufferedFSDataInputStream;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\u000f\u001e\u00019B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d!\u0007A1A\u0005\n\u0015Da\u0001\u001c\u0001!\u0002\u00131\u0007bB7\u0001\u0001\u0004%IA\u001c\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0011\u00191\b\u0001)Q\u00051\"9q\u000f\u0001a\u0001\n\u0013A\bb\u0002?\u0001\u0001\u0004%I! \u0005\u0007\u007f\u0002\u0001\u000b\u0015B=\t\u0011\u0005\u0005\u0001A1A\u0005\n9Dq!a\u0001\u0001A\u0003%\u0001\fC\u0004\u0002\u0006\u0001!\t%a\u0002\t\r\u0005%\u0001\u0001\"\u0011o\u0011\u0019\tY\u0001\u0001C!]\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\tI\u0004\u0001C\u0005\u0003w9\u0011\"!\u0011\u001e\u0003\u0003E\t!a\u0011\u0007\u0011qi\u0012\u0011!E\u0001\u0003\u000bBa\u0001\u0018\r\u0005\u0002\u0005\u001d\u0003\"CA%1E\u0005I\u0011AA&\u0011%\t\t\u0007GI\u0001\n\u0003\tYE\u0001\u0007GS2,7\u000b\u001e:fC6,'O\u0003\u0002\u001f?\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003A\u0005\naa]8ve\u000e,'B\u0001\u0012$\u0003\u0015\u0019wNY8m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u000511m\u001c2sSbT!\u0001K\u0015\u0002\t\u0005\u00147/\u0019\u0006\u0003U-\n!aY8\u000b\u00031\n!A_1\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1D(D\u00018\u0015\tA\u0014(\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003um\naA]3bI\u0016\u0014(B\u0001\u0012&\u0013\titG\u0001\u0007TS6\u0004H.Z*ue\u0016\fW.\u0001\u0005gS2,\u0007+\u0019;i!\t\u0001uI\u0004\u0002B\u000bB\u0011!)M\u0007\u0002\u0007*\u0011A)L\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\u0019\u0002\u0015\u0019LG.Z*zgR,W\u000e\u0005\u0002M+6\tQJ\u0003\u0002O\u001f\u0006\u0011am\u001d\u0006\u0003!F\u000ba\u0001[1e_>\u0004(B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!AV'\u0003\u0015\u0019KG.Z*zgR,W.A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bC\u0001\u0019Z\u0013\tQ\u0016G\u0001\u0003M_:<\u0017\u0001D7bq&lW/\u001c\"zi\u0016\u001c\u0018A\u0002\u001fj]&$h\bF\u0003_A\u0006\u00147\r\u0005\u0002`\u00015\tQ\u0004C\u0003?\u000b\u0001\u0007q\bC\u0003K\u000b\u0001\u00071\nC\u0004X\u000bA\u0005\t\u0019\u0001-\t\u000fm+\u0001\u0013!a\u00011\u00061An\\4hKJ,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003SF\u000bQ\u0001\\8hi)L!a\u001b5\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0011BY=uK&sG-\u001a=\u0016\u0003a\u000bQBY=uK&sG-\u001a=`I\u0015\fHCA9u!\t\u0001$/\u0003\u0002tc\t!QK\\5u\u0011\u001d)\u0018\"!AA\u0002a\u000b1\u0001\u001f\u00132\u0003)\u0011\u0017\u0010^3J]\u0012,\u0007\u0010I\u0001\u000fEV4g-\u001a:fIN#(/Z1n+\u0005I\bCA0{\u0013\tYXDA\rCk\u001a4WM]3e\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017A\u00052vM\u001a,'/\u001a3TiJ,\u0017-\\0%KF$\"!\u001d@\t\u000fUd\u0011\u0011!a\u0001s\u0006y!-\u001e4gKJ,Gm\u0015;sK\u0006l\u0007%\u0001\u0005gS2,7+\u001b>f\u0003%1\u0017\u000e\\3TSj,\u0007%A\u0007j]B,HOR5mK:\u000bW.Z\u000b\u0002\u007f\u0005!1/\u001b>f\u0003\u0019ygMZ:fi\u0006!a.\u001a=u)\u0011\t\t\"!\b\u0011\u000bA\n\u0019\"a\u0006\n\u0007\u0005U\u0011GA\u0003BeJ\f\u0017\u0010E\u00021\u00033I1!a\u00072\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005}1\u00031\u0001\u0002\"\u0005ia.^7cKJ|eMQ=uKN\u00042\u0001MA\u0012\u0013\r\t)#\r\u0002\u0004\u0013:$\u0018!B2m_N,G#A9\u0002\u001b\u001d,G\u000fS1e_>\u0004\b+\u0019;i)\u0011\ty#!\u000e\u0011\u00071\u000b\t$C\u0002\u000245\u0013A\u0001U1uQ\"1\u0011qG\u000bA\u0002}\nA\u0001]1uQ\u0006\tr-\u001a;IC\u0012|w\u000e\u001d$jY\u0016\u001c\u0016N_3\u0015\u0007a\u000bi\u0004C\u0004\u0002@Y\u0001\r!a\f\u0002\u0015!\fGm\\8q!\u0006$\b.\u0001\u0007GS2,7\u000b\u001e:fC6,'\u000f\u0005\u0002`1M\u0011\u0001d\f\u000b\u0003\u0003\u0007\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA'U\rA\u0016qJ\u0016\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0005v]\u000eDWmY6fI*\u0019\u00111L\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0005U#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class FileStreamer
implements SimpleStream {
    private final String filePath;
    private final FileSystem fileSystem;
    private final long startOffset;
    private final long maximumBytes;
    private final Logger logger;
    private long byteIndex;
    private BufferedFSDataInputStream bufferedStream;
    private final long fileSize;

    public static long $lessinit$greater$default$4() {
        return FileStreamer$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return FileStreamer$.MODULE$.$lessinit$greater$default$3();
    }

    public boolean isEndOfStream() {
        return SimpleStream.isEndOfStream$((SimpleStream)this);
    }

    private Logger logger() {
        return this.logger;
    }

    private long byteIndex() {
        return this.byteIndex;
    }

    private void byteIndex_$eq(long x$1) {
        this.byteIndex = x$1;
    }

    private BufferedFSDataInputStream bufferedStream() {
        return this.bufferedStream;
    }

    private void bufferedStream_$eq(BufferedFSDataInputStream x$1) {
        this.bufferedStream = x$1;
    }

    private long fileSize() {
        return this.fileSize;
    }

    public String inputFileName() {
        return this.filePath;
    }

    public long size() {
        return this.maximumBytes > 0L ? Math.min(this.fileSize(), this.maximumBytes + this.startOffset) : this.fileSize();
    }

    public long offset() {
        return this.byteIndex();
    }

    public byte[] next(int numberOfBytes) {
        byte[] byArray;
        int actualBytesToRead;
        int n = actualBytesToRead = this.maximumBytes > 0L ? (int)Math.min(this.maximumBytes - this.byteIndex() + this.startOffset, (long)numberOfBytes) : numberOfBytes;
        if (numberOfBytes <= 0) {
            byArray = new byte[]{};
        } else if (actualBytesToRead <= 0 || this.bufferedStream() == null || this.bufferedStream().isClosed()) {
            this.close();
            byArray = new byte[]{};
        } else {
            byte[] buffer = new byte[actualBytesToRead];
            int readBytes = this.bufferedStream().readFully(buffer, 0, actualBytesToRead);
            if (readBytes > 0) {
                this.byteIndex_$eq(this.byteIndex() + (long)readBytes);
            }
            if (readBytes == numberOfBytes) {
                byArray = buffer;
            } else {
                this.logger().warn((Object)new StringBuilder(51).append("End of stream reached: Requested ").append(numberOfBytes).append(" bytes, received ").append(readBytes).append(".").toString());
                this.close();
                if (readBytes == actualBytesToRead) {
                    byArray = buffer;
                } else if (readBytes > 0) {
                    byte[] shrunkBuffer = new byte[readBytes];
                    System.arraycopy(buffer, 0, shrunkBuffer, 0, readBytes);
                    byArray = shrunkBuffer;
                } else {
                    byArray = new byte[]{};
                }
            }
        }
        return byArray;
    }

    public void close() {
        block0: {
            if (this.bufferedStream() == null || this.bufferedStream().isClosed()) break block0;
            this.bufferedStream().close();
            this.bufferedStream_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Path getHadoopPath(String path) {
        void var2_2;
        Path hadoopPath = new Path(path);
        if (!this.fileSystem.exists(hadoopPath)) {
            throw new IllegalArgumentException(new StringBuilder(21).append("File does not exist: ").append(path).toString());
        }
        return var2_2;
    }

    private long getHadoopFileSize(Path hadoopPath) {
        ContentSummary cSummary = this.fileSystem.getContentSummary(hadoopPath);
        return cSummary.getLength();
    }

    public FileStreamer(String filePath, FileSystem fileSystem, long startOffset, long maximumBytes) {
        this.filePath = filePath;
        this.fileSystem = fileSystem;
        this.startOffset = startOffset;
        this.maximumBytes = maximumBytes;
        SimpleStream.$init$((SimpleStream)this);
        this.logger = Logger.getLogger(this.getClass());
        this.byteIndex = startOffset;
        this.bufferedStream = new BufferedFSDataInputStream(this.getHadoopPath(filePath), fileSystem, startOffset, Constants$.MODULE$.defaultStreamBufferInMB(), maximumBytes);
        this.fileSize = this.getHadoopFileSize(this.getHadoopPath(filePath));
    }
}

