/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl;

import java.util.Iterator;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArraySequence;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public abstract class AbstractNdArray<T, U extends NdArray<T>>
implements NdArray<T> {
    protected final DimensionalSpace dimensions;

    public abstract U slice(long var1, DimensionalSpace var3);

    public DimensionalSpace dimensions() {
        return this.dimensions;
    }

    @Override
    public Shape shape() {
        return this.dimensions.shape();
    }

    @Override
    public NdArraySequence<U> scalars() {
        return this.elements(this.shape().numDimensions() - 1);
    }

    public int hashCode() {
        return this.slowHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NdArray)) {
            return false;
        }
        return this.slowEquals((NdArray)obj);
    }

    protected AbstractNdArray(DimensionalSpace dimensions) {
        this.dimensions = dimensions;
    }

    protected void slowCopyTo(NdArray<T> array) {
        this.scalars().forEachIndexed((coords, e) -> array.setObject(e.getObject(new long[0]), (long)coords));
    }

    protected int slowHashCode() {
        int prime = 31;
        int result = 1;
        for (NdArray scalar : this.scalars()) {
            result = 31 * result + scalar.getObject(new long[0]).hashCode();
        }
        result = 31 * result + this.shape().hashCode();
        return result;
    }

    protected boolean slowEquals(NdArray<?> array) {
        if (!this.shape().equals(array.shape())) {
            return false;
        }
        Iterator thisIter = this.scalars().iterator();
        Iterator otherIter = array.scalars().iterator();
        while (thisIter.hasNext()) {
            if (((NdArray)thisIter.next()).getObject(new long[0]).equals(((NdArray)otherIter.next()).getObject(new long[0]))) continue;
            return false;
        }
        return true;
    }
}

