/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorDataset", inputsClass=Inputs.class)
public final class TensorDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorDataset";
    private Output<? extends TType> handle;

    public TensorDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static TensorDataset create(Scope scope, Iterable<Operand<?>> components, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(components));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new TensorDataset(opBuilder.build());
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=TensorDataset.class)
    public static class Inputs
    extends RawOpInputs<TensorDataset> {
        public final Iterable<Operand<?>> components;
        public final DataType[] ToutputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new TensorDataset(op), op, Arrays.asList("Toutput_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            int componentsLength = op.inputListLength("components");
            this.components = Arrays.asList((Operand[])op.inputList(inputIndex, componentsLength));
            inputIndex += componentsLength;
            this.ToutputTypes = op.attributes().getAttrTypeList("Toutput_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String metadata;

        private Options() {
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

