/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallingFormat {
    protected static CallingFormat regularCallingFormat = new RegularCallingFormat();
    protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
    protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

    public abstract String getEndpoint(String var1, int var2, String var3);

    public abstract String getPathBase(String var1, String var2);

    public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map<String, String> var6) throws MalformedURLException;

    public static CallingFormat getRegularCallingFormat() {
        return regularCallingFormat;
    }

    public static CallingFormat getSubdomainCallingFormat() {
        return subdomainCallingFormat;
    }

    public static CallingFormat getVanityCallingFormat() {
        return vanityCallingFormat;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegularCallingFormat
    extends CallingFormat {
        private RegularCallingFormat() {
        }

        @Override
        public String getPathBase(String bucket, String key) {
            return this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
        }

        @Override
        public String getEndpoint(String server, int port, String bucket) {
            return String.valueOf(server) + ":" + port;
        }

        @Override
        public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map<String, String> pathArgs) throws MalformedURLException {
            String pathBase = this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
            String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
            return new URL(isSecure ? "https" : "http", server, port, String.valueOf(pathBase) + pathArguments);
        }

        private boolean isBucketSpecified(String bucket) {
            if (bucket == null) {
                return false;
            }
            return bucket.length() != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubdomainCallingFormat
    extends CallingFormat {
        private SubdomainCallingFormat() {
        }

        @Override
        public String getPathBase(String bucket, String key) {
            return "/" + key;
        }

        @Override
        public String getEndpoint(String server, int port, String bucket) {
            return String.valueOf(bucket) + "." + server + ":" + port;
        }

        @Override
        public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map<String, String> pathArgs) throws MalformedURLException {
            if (bucket == null || bucket.length() == 0) {
                return CallingFormat.getRegularCallingFormat().getURL(isSecure, server, port, bucket, key, pathArgs);
            }
            String serverToUse = String.valueOf(bucket) + "." + server;
            String pathBase = this.getPathBase(bucket, key);
            String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
            return new URL(isSecure ? "https" : "http", serverToUse, port, String.valueOf(pathBase) + pathArguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VanityCallingFormat
    extends CallingFormat {
        private VanityCallingFormat() {
        }

        @Override
        public String getPathBase(String bucket, String key) {
            return "/" + key;
        }

        @Override
        public String getEndpoint(String server, int port, String bucket) {
            return String.valueOf(bucket) + ":" + port;
        }

        @Override
        public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map<String, String> pathArgs) throws MalformedURLException {
            if (bucket == null || bucket.length() == 0) {
                return CallingFormat.getRegularCallingFormat().getURL(isSecure, server, port, bucket, key, pathArgs);
            }
            String serverToUse = bucket;
            String pathBase = this.getPathBase(bucket, key);
            String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
            return new URL(isSecure ? "https" : "http", serverToUse, port, String.valueOf(pathBase) + pathArguments);
        }
    }
}

