/*
 * Decompiled with CFR 0.152.
 */
package android.arch.core.executor;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.core.executor.TaskExecutor;
import android.arch.core.executor.TaskExecutorWithFakeMainThread;
import android.support.annotation.RestrictTo;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class JunitTaskExecutorRule
implements TestRule {
    private final TaskExecutorWithFakeMainThread mTaskExecutor;

    public JunitTaskExecutorRule(int ioThreadCount, boolean spyOnExecutor) {
        this.mTaskExecutor = spyOnExecutor ? (TaskExecutorWithFakeMainThread)((Object)Mockito.spy((Object)((Object)new TaskExecutorWithFakeMainThread(ioThreadCount)))) : new TaskExecutorWithFakeMainThread(ioThreadCount);
    }

    private void beforeStart() {
        ArchTaskExecutor.getInstance().setDelegate((TaskExecutor)this.mTaskExecutor);
    }

    private void afterFinished() {
        ArchTaskExecutor.getInstance().setDelegate(null);
    }

    public TaskExecutor getTaskExecutor() {
        return this.mTaskExecutor;
    }

    public void drainTasks(int seconds) throws InterruptedException {
        this.mTaskExecutor.drainTasks(seconds);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JunitTaskExecutorRule.this.beforeStart();
                try {
                    base.evaluate();
                    JunitTaskExecutorRule.this.finishExecutors();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                finally {
                    JunitTaskExecutorRule.this.afterFinished();
                }
            }
        };
    }

    private void finishExecutors() throws InterruptedException, MultipleFailureException {
        this.mTaskExecutor.shutdown(10);
        List<Throwable> errors = this.mTaskExecutor.getErrors();
        if (!errors.isEmpty()) {
            throw new MultipleFailureException(errors);
        }
    }
}

