/*
 * Decompiled with CFR 0.152.
 */
package android.arch.core.executor;

import android.arch.core.executor.TaskExecutor;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TaskExecutorWithFakeMainThread
extends TaskExecutor {
    private List<Throwable> mCaughtExceptions = Collections.synchronizedList(new ArrayList());
    private ExecutorService mIOService;
    private Thread mMainThread;
    private final int mIOThreadCount;
    private ExecutorService mMainThreadService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(@NonNull Runnable r) {
            TaskExecutorWithFakeMainThread.this.mMainThread = new LoggingThread(r);
            return TaskExecutorWithFakeMainThread.this.mMainThread;
        }
    });

    public TaskExecutorWithFakeMainThread(int ioThreadCount) {
        this.mIOThreadCount = ioThreadCount;
        this.mIOService = Executors.newFixedThreadPool(ioThreadCount, new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new LoggingThread(r);
            }
        });
    }

    public void executeOnDiskIO(Runnable runnable) {
        this.mIOService.execute(runnable);
    }

    public void postToMainThread(Runnable runnable) {
        this.mMainThreadService.execute(runnable);
    }

    public boolean isMainThread() {
        return Thread.currentThread() == this.mMainThread;
    }

    List<Throwable> getErrors() {
        return this.mCaughtExceptions;
    }

    void shutdown(int timeoutInSeconds) throws InterruptedException {
        this.mMainThreadService.shutdown();
        this.mIOService.shutdown();
        this.mMainThreadService.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
        this.mIOService.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
    }

    public void drainTasks(int seconds) throws InterruptedException {
        if (this.isMainThread()) {
            throw new IllegalStateException();
        }
        final CountDownLatch enterLatch = new CountDownLatch(this.mIOThreadCount);
        final CountDownLatch exitLatch = new CountDownLatch(1);
        for (int i = 0; i < this.mIOThreadCount; ++i) {
            this.executeOnDiskIO(new Runnable(){

                @Override
                public void run() {
                    enterLatch.countDown();
                    try {
                        exitLatch.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        final CountDownLatch mainLatch = new CountDownLatch(1);
        this.postToMainThread(new Runnable(){

            @Override
            public void run() {
                mainLatch.countDown();
            }
        });
        if (!enterLatch.await(seconds, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)("Could not drain IO tasks in " + seconds + " seconds"));
        }
        exitLatch.countDown();
        if (!mainLatch.await(seconds, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)("Could not drain UI tasks in " + seconds + " seconds"));
        }
    }

    class LoggingThread
    extends Thread {
        LoggingThread(final Runnable target) {
            super(new Runnable(){

                @Override
                public void run() {
                    try {
                        target.run();
                    }
                    catch (Throwable t) {
                        TaskExecutorWithFakeMainThread.this.mCaughtExceptions.add(t);
                    }
                }
            });
        }
    }
}

