/*
 * Decompiled with CFR 0.152.
 */
package android.arch.core.executor.testing;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.core.executor.DefaultTaskExecutor;
import android.arch.core.executor.TaskExecutor;
import android.os.SystemClock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class CountingTaskExecutorRule
extends TestWatcher {
    private final Object mCountLock = new Object();
    private int mTaskCount = 0;

    protected void starting(Description description) {
        super.starting(description);
        ArchTaskExecutor.getInstance().setDelegate((TaskExecutor)new DefaultTaskExecutor(){

            public void executeOnDiskIO(Runnable runnable) {
                super.executeOnDiskIO((Runnable)new CountingRunnable(runnable));
            }

            public void postToMainThread(Runnable runnable) {
                super.postToMainThread((Runnable)new CountingRunnable(runnable));
            }
        });
    }

    protected void finished(Description description) {
        super.finished(description);
        ArchTaskExecutor.getInstance().setDelegate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment() {
        Object object = this.mCountLock;
        synchronized (object) {
            ++this.mTaskCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement() {
        Object object = this.mCountLock;
        synchronized (object) {
            --this.mTaskCount;
            if (this.mTaskCount == 0) {
                this.onIdle();
                this.mCountLock.notifyAll();
            }
        }
    }

    protected void onIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this.mCountLock;
        synchronized (object) {
            return this.mTaskCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainTasks(int time, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long end = SystemClock.uptimeMillis() + timeUnit.toMillis(time);
        Object object = this.mCountLock;
        synchronized (object) {
            while (this.mTaskCount != 0) {
                long now = SystemClock.uptimeMillis();
                long remaining = end - now;
                if (remaining > 0L) {
                    this.mCountLock.wait(remaining);
                    continue;
                }
                throw new TimeoutException("could not drain tasks");
            }
        }
    }

    class CountingRunnable
    implements Runnable {
        final Runnable mWrapped;

        CountingRunnable(Runnable wrapped) {
            this.mWrapped = wrapped;
            CountingTaskExecutorRule.this.increment();
        }

        @Override
        public void run() {
            try {
                this.mWrapped.run();
            }
            finally {
                CountingTaskExecutorRule.this.decrement();
            }
        }
    }
}

