/*
 * Decompiled with CFR 0.152.
 */
package android.arch.core.executor;

import android.arch.core.executor.DefaultTaskExecutor;
import android.arch.core.executor.TaskExecutor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ArchTaskExecutor
extends TaskExecutor {
    private static volatile ArchTaskExecutor sInstance;
    @NonNull
    private TaskExecutor mDelegate;
    @NonNull
    private TaskExecutor mDefaultTaskExecutor;
    @NonNull
    private static final Executor sMainThreadExecutor;
    @NonNull
    private static final Executor sIOThreadExecutor;

    private ArchTaskExecutor() {
        this.mDelegate = this.mDefaultTaskExecutor = new DefaultTaskExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchTaskExecutor getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<ArchTaskExecutor> clazz = ArchTaskExecutor.class;
        synchronized (ArchTaskExecutor.class) {
            if (sInstance == null) {
                sInstance = new ArchTaskExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setDelegate(@Nullable TaskExecutor taskExecutor) {
        this.mDelegate = taskExecutor == null ? this.mDefaultTaskExecutor : taskExecutor;
    }

    @Override
    public void executeOnDiskIO(Runnable runnable) {
        this.mDelegate.executeOnDiskIO(runnable);
    }

    @Override
    public void postToMainThread(Runnable runnable) {
        this.mDelegate.postToMainThread(runnable);
    }

    @NonNull
    public static Executor getMainThreadExecutor() {
        return sMainThreadExecutor;
    }

    @NonNull
    public static Executor getIOThreadExecutor() {
        return sIOThreadExecutor;
    }

    @Override
    public boolean isMainThread() {
        return this.mDelegate.isMainThread();
    }

    static {
        sMainThreadExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                ArchTaskExecutor.getInstance().postToMainThread(command);
            }
        };
        sIOThreadExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                ArchTaskExecutor.getInstance().executeOnDiskIO(command);
            }
        };
    }
}

