/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.lifecycle.Elements_extKt;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.arch.lifecycle.Validator;
import android.arch.lifecycle.model.AdapterClassKt;
import android.arch.lifecycle.model.EventMethod;
import android.arch.lifecycle.model.LifecycleObserverInfo;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u000fJ \u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0002J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Landroid/arch/lifecycle/ObserversCollector;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "elementUtils", "Ljavax/lang/model/util/Elements;", "getElementUtils", "()Ljavax/lang/model/util/Elements;", "lifecycleObserverTypeMirror", "Ljavax/lang/model/type/TypeMirror;", "getLifecycleObserverTypeMirror", "()Ljavax/lang/model/type/TypeMirror;", "observers", "", "Ljavax/lang/model/element/TypeElement;", "Landroid/arch/lifecycle/model/LifecycleObserverInfo;", "getObservers", "()Ljava/util/Map;", "typeUtils", "Ljavax/lang/model/util/Types;", "getTypeUtils", "()Ljavax/lang/model/util/Types;", "validator", "Landroid/arch/lifecycle/Validator;", "getValidator", "()Landroid/arch/lifecycle/Validator;", "collect", "type", "createObserverInfo", "typeElement", "parents", "", "generatedAdapterInfoFor", "Ljavax/lang/model/element/ExecutableElement;", "compiler"})
public final class ObserversCollector {
    @NotNull
    private final Types typeUtils;
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final TypeMirror lifecycleObserverTypeMirror;
    @NotNull
    private final Validator validator;
    @NotNull
    private final Map<TypeElement, LifecycleObserverInfo> observers;

    @NotNull
    public final Types getTypeUtils() {
        return this.typeUtils;
    }

    @NotNull
    public final Elements getElementUtils() {
        return this.elementUtils;
    }

    @NotNull
    public final TypeMirror getLifecycleObserverTypeMirror() {
        return this.lifecycleObserverTypeMirror;
    }

    @NotNull
    public final Validator getValidator() {
        return this.validator;
    }

    @NotNull
    public final Map<TypeElement, LifecycleObserverInfo> getObservers() {
        return this.observers;
    }

    @Nullable
    public final LifecycleObserverInfo collect(@NotNull TypeElement type) {
        TypeMirror it;
        Iterable $receiver$iv$iv;
        Map<TypeElement, LifecycleObserverInfo> map;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Map<TypeElement, LifecycleObserverInfo> map2 = map = this.observers;
        if (map2.containsKey(type)) {
            return this.observers.get(type);
        }
        Collection collection = CollectionsKt.listOf((Object)type.getSuperclass());
        List<? extends TypeMirror> list = type.getInterfaces();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"type.interfaces");
        Iterable $receiver$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (TypeMirror)element$iv$iv;
            if (!this.typeUtils.isAssignable(it, this.lifecycleObserverTypeMirror)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (TypeMirror)element$iv$iv;
            if (this.typeUtils.isSameType(it, this.lifecycleObserverTypeMirror)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (TypeMirror)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"MoreTypes.asTypeElement(it)");
            LifecycleObserverInfo lifecycleObserverInfo = this.collect(typeElement);
            collection2.add(lifecycleObserverInfo);
        }
        List parents = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        LifecycleObserverInfo info = this.createObserverInfo(type, parents);
        if (info != null) {
            object = this.observers;
            LifecycleObserverInfo lifecycleObserverInfo = info;
            object.put(type, lifecycleObserverInfo);
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ExecutableElement> generatedAdapterInfoFor(@NotNull TypeElement type) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CharSequence charSequence = Elements_extKt.getPackageQName(type);
        String packageName = charSequence.length() == 0 ? "" : "" + Elements_extKt.getPackageQName(type) + '.';
        TypeElement adapterType = this.elementUtils.getTypeElement(packageName + AdapterClassKt.getAdapterName(type));
        Object object = adapterType;
        if (object != null && (object = Elements_extKt.methods((TypeElement)object)) != null) {
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = (Iterable)object;
            void var5_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ExecutableElement executable = (ExecutableElement)element$iv$iv;
                if (!Elements_extKt.isSyntheticMethod(executable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final LifecycleObserverInfo createObserverInfo(TypeElement typeElement, List<LifecycleObserverInfo> parents) {
        ExecutableElement executable;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        if (!this.validator.validateClass(typeElement)) {
            return null;
        }
        Iterable iterable = $receiver$iv = (Iterable)Elements_extKt.methods(typeElement);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            executable = (ExecutableElement)element$iv$iv;
            if (!MoreElements.isAnnotationPresent((Element)executable, OnLifecycleEvent.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            EventMethod eventMethod;
            executable = (ExecutableElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            OnLifecycleEvent onState = executable.getAnnotation(OnLifecycleEvent.class);
            if (this.validator.validateMethod(executable, onState.value())) {
                OnLifecycleEvent onLifecycleEvent = onState;
                Intrinsics.checkExpressionValueIsNotNull((Object)onLifecycleEvent, (String)"onState");
                eventMethod = new EventMethod(executable, onLifecycleEvent, typeElement);
            } else {
                eventMethod = null;
            }
            EventMethod eventMethod2 = eventMethod;
            collection.add(eventMethod2);
        }
        List methods = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        return new LifecycleObserverInfo(typeElement, methods, parents);
    }

    public ObserversCollector(@NotNull ProcessingEnvironment processingEnv) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        Types types = processingEnv.getTypeUtils();
        Intrinsics.checkExpressionValueIsNotNull((Object)types, (String)"processingEnv.typeUtils");
        this.typeUtils = types;
        Elements elements = processingEnv.getElementUtils();
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"processingEnv.elementUtils");
        this.elementUtils = elements;
        TypeMirror typeMirror = this.elementUtils.getTypeElement(LifecycleObserver.class.getCanonicalName()).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"elementUtils.getTypeElem\u2026a.canonicalName).asType()");
        this.lifecycleObserverTypeMirror = typeMirror;
        this.validator = new Validator(processingEnv);
        ObserversCollector observersCollector = this;
        observersCollector.observers = map = (Map)new LinkedHashMap();
    }
}

