/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.lifecycle.LiveData;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ComputableLiveData<T> {
    private final LiveData<T> mLiveData;
    private AtomicBoolean mInvalid = new AtomicBoolean(true);
    private AtomicBoolean mComputing = new AtomicBoolean(false);
    @VisibleForTesting
    final Runnable mRefreshRunnable = new Runnable(){

        @Override
        @WorkerThread
        public void run() {
            boolean computed;
            do {
                computed = false;
                if (!ComputableLiveData.this.mComputing.compareAndSet(false, true)) continue;
                try {
                    Object value = null;
                    while (ComputableLiveData.this.mInvalid.compareAndSet(true, false)) {
                        computed = true;
                        value = ComputableLiveData.this.compute();
                    }
                    if (!computed) continue;
                    ComputableLiveData.this.mLiveData.postValue(value);
                }
                finally {
                    ComputableLiveData.this.mComputing.set(false);
                }
            } while (computed && ComputableLiveData.this.mInvalid.get());
        }
    };
    @VisibleForTesting
    final Runnable mInvalidationRunnable = new Runnable(){

        @Override
        @MainThread
        public void run() {
            boolean isActive = ComputableLiveData.this.mLiveData.hasActiveObservers();
            if (ComputableLiveData.this.mInvalid.compareAndSet(false, true) && isActive) {
                ArchTaskExecutor.getInstance().executeOnDiskIO(ComputableLiveData.this.mRefreshRunnable);
            }
        }
    };

    public ComputableLiveData() {
        this.mLiveData = new LiveData<T>(){

            @Override
            protected void onActive() {
                ArchTaskExecutor.getInstance().executeOnDiskIO(ComputableLiveData.this.mRefreshRunnable);
            }
        };
    }

    @NonNull
    public LiveData<T> getLiveData() {
        return this.mLiveData;
    }

    public void invalidate() {
        ArchTaskExecutor.getInstance().executeOnMainThread(this.mInvalidationRunnable);
    }

    @WorkerThread
    protected abstract T compute();
}

