/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.EmptyActivityLifecycleCallbacks;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleRegistry;
import android.arch.lifecycle.LifecycleRegistryOwner;
import android.arch.lifecycle.ReportFragment;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class LifecycleDispatcher {
    private static final String REPORT_FRAGMENT_TAG = "android.arch.lifecycle.LifecycleDispatcher.report_fragment_tag";
    private static AtomicBoolean sInitialized = new AtomicBoolean(false);

    LifecycleDispatcher() {
    }

    static void init(Context context) {
        if (sInitialized.getAndSet(true)) {
            return;
        }
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new DispatcherActivityCallback());
    }

    private static void markState(FragmentManager manager, Lifecycle.State state) {
        List fragments = manager.getFragments();
        if (fragments == null) {
            return;
        }
        for (Fragment fragment : fragments) {
            if (fragment == null) continue;
            LifecycleDispatcher.markStateIn(fragment, state);
            if (!fragment.isAdded()) continue;
            LifecycleDispatcher.markState(fragment.getChildFragmentManager(), state);
        }
    }

    private static void markStateIn(Object object, Lifecycle.State state) {
        if (object instanceof LifecycleRegistryOwner) {
            LifecycleRegistry registry = ((LifecycleRegistryOwner)object).getLifecycle();
            registry.markState(state);
        }
    }

    private static void markState(FragmentActivity activity, Lifecycle.State state) {
        LifecycleDispatcher.markStateIn(activity, state);
        LifecycleDispatcher.markState(activity.getSupportFragmentManager(), state);
    }

    private static void dispatchIfLifecycleOwner(Fragment fragment, Lifecycle.Event event) {
        if (fragment instanceof LifecycleRegistryOwner) {
            ((LifecycleRegistryOwner)fragment).getLifecycle().handleLifecycleEvent(event);
        }
    }

    @VisibleForTesting
    static class FragmentCallback
    extends FragmentManager.FragmentLifecycleCallbacks {
        FragmentCallback() {
        }

        public void onFragmentCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
            LifecycleDispatcher.dispatchIfLifecycleOwner(f, Lifecycle.Event.ON_CREATE);
            if (!(f instanceof LifecycleRegistryOwner)) {
                return;
            }
            if (f.getChildFragmentManager().findFragmentByTag(LifecycleDispatcher.REPORT_FRAGMENT_TAG) == null) {
                f.getChildFragmentManager().beginTransaction().add((Fragment)new DestructionReportFragment(), LifecycleDispatcher.REPORT_FRAGMENT_TAG).commit();
            }
        }

        public void onFragmentStarted(FragmentManager fm, Fragment f) {
            LifecycleDispatcher.dispatchIfLifecycleOwner(f, Lifecycle.Event.ON_START);
        }

        public void onFragmentResumed(FragmentManager fm, Fragment f) {
            LifecycleDispatcher.dispatchIfLifecycleOwner(f, Lifecycle.Event.ON_RESUME);
        }
    }

    public static class DestructionReportFragment
    extends Fragment {
        public void onPause() {
            super.onPause();
            this.dispatch(Lifecycle.Event.ON_PAUSE);
        }

        public void onStop() {
            super.onStop();
            this.dispatch(Lifecycle.Event.ON_STOP);
        }

        public void onDestroy() {
            super.onDestroy();
            this.dispatch(Lifecycle.Event.ON_DESTROY);
        }

        protected void dispatch(Lifecycle.Event event) {
            LifecycleDispatcher.dispatchIfLifecycleOwner(this.getParentFragment(), event);
        }
    }

    @VisibleForTesting
    static class DispatcherActivityCallback
    extends EmptyActivityLifecycleCallbacks {
        private final FragmentCallback mFragmentCallback = new FragmentCallback();

        DispatcherActivityCallback() {
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            if (activity instanceof FragmentActivity) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentCallback, true);
            }
            ReportFragment.injectIfNeededIn((Activity)activity);
        }

        @Override
        public void onActivityStopped(Activity activity) {
            if (activity instanceof FragmentActivity) {
                LifecycleDispatcher.markState((FragmentActivity)activity, Lifecycle.State.CREATED);
            }
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            if (activity instanceof FragmentActivity) {
                LifecycleDispatcher.markState((FragmentActivity)activity, Lifecycle.State.CREATED);
            }
        }
    }
}

