/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.core.internal.SafeIterableMap;
import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LifecycleRegistry;
import android.arch.lifecycle.Observer;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Map;

public abstract class LiveData<T> {
    private final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    private static final Object NOT_SET = new Object();
    private static final LifecycleOwner ALWAYS_ON = new LifecycleOwner(){
        private LifecycleRegistry mRegistry = this.init();

        private LifecycleRegistry init() {
            LifecycleRegistry registry = new LifecycleRegistry((LifecycleOwner)this);
            registry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
            registry.handleLifecycleEvent(Lifecycle.Event.ON_START);
            registry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
            return registry;
        }

        public Lifecycle getLifecycle() {
            return this.mRegistry;
        }
    };
    private SafeIterableMap<Observer<T>, LifecycleBoundObserver> mObservers = new SafeIterableMap();
    private int mActiveCount = 0;
    private volatile Object mData = NOT_SET;
    private volatile Object mPendingData = NOT_SET;
    private int mVersion = -1;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;
    private final Runnable mPostValueRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object newValue;
            Object object = LiveData.this.mDataLock;
            synchronized (object) {
                newValue = LiveData.this.mPendingData;
                LiveData.this.mPendingData = NOT_SET;
            }
            LiveData.this.setValue(newValue);
        }
    };

    private void considerNotify(LifecycleBoundObserver observer) {
        if (!observer.active) {
            return;
        }
        if (!LiveData.isActiveState(observer.owner.getLifecycle().getCurrentState())) {
            observer.activeStateChanged(false);
            return;
        }
        if (observer.lastVersion >= this.mVersion) {
            return;
        }
        observer.lastVersion = this.mVersion;
        observer.observer.onChanged(this.mData);
    }

    private void dispatchingValue(@Nullable LifecycleBoundObserver initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            SafeIterableMap.IteratorWithAdditions iterator = this.mObservers.iteratorWithAdditions();
            while (iterator.hasNext()) {
                this.considerNotify((LifecycleBoundObserver)((Map.Entry)iterator.next()).getValue());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @MainThread
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner, observer);
        LifecycleBoundObserver existing = (LifecycleBoundObserver)this.mObservers.putIfAbsent(observer, (Object)wrapper);
        if (existing != null && existing.owner != wrapper.owner) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
    }

    @MainThread
    public void observeForever(@NonNull Observer<T> observer) {
        this.observe(ALWAYS_ON, observer);
    }

    @MainThread
    public void removeObserver(@NonNull Observer<T> observer) {
        this.assertMainThread("removeObserver");
        LifecycleBoundObserver removed = (LifecycleBoundObserver)this.mObservers.remove(observer);
        if (removed == null) {
            return;
        }
        removed.owner.getLifecycle().removeObserver((LifecycleObserver)removed);
        removed.activeStateChanged(false);
    }

    @MainThread
    public void removeObservers(@NonNull LifecycleOwner owner) {
        this.assertMainThread("removeObservers");
        for (Map.Entry entry : this.mObservers) {
            if (((LifecycleBoundObserver)entry.getValue()).owner != owner) continue;
            this.removeObserver((Observer)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postValue(T value) {
        boolean postTask;
        Object object = this.mDataLock;
        synchronized (object) {
            postTask = this.mPendingData == NOT_SET;
            this.mPendingData = value;
        }
        if (!postTask) {
            return;
        }
        ArchTaskExecutor.getInstance().postToMainThread(this.mPostValueRunnable);
    }

    @MainThread
    protected void setValue(T value) {
        this.assertMainThread("setValue");
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasObservers() {
        return this.mObservers.size() > 0;
    }

    public boolean hasActiveObservers() {
        return this.mActiveCount > 0;
    }

    static boolean isActiveState(Lifecycle.State state) {
        return state.isAtLeast(Lifecycle.State.STARTED);
    }

    private void assertMainThread(String methodName) {
        if (!ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot invoke " + methodName + " on a background" + " thread");
        }
    }

    class LifecycleBoundObserver
    implements GenericLifecycleObserver {
        public final LifecycleOwner owner;
        public final Observer<T> observer;
        public boolean active;
        public int lastVersion = -1;

        LifecycleBoundObserver(LifecycleOwner owner, Observer<T> observer) {
            this.owner = owner;
            this.observer = observer;
        }

        public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
            if (this.owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                LiveData.this.removeObserver(this.observer);
                return;
            }
            this.activeStateChanged(LiveData.isActiveState(this.owner.getLifecycle().getCurrentState()));
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.active) {
                return;
            }
            this.active = newActive;
            boolean wasInactive = LiveData.this.mActiveCount == 0;
            LiveData liveData = LiveData.this;
            liveData.mActiveCount = liveData.mActiveCount + (this.active ? 1 : -1);
            if (wasInactive && this.active) {
                LiveData.this.onActive();
            }
            if (LiveData.this.mActiveCount == 0 && !this.active) {
                LiveData.this.onInactive();
            }
            if (this.active) {
                LiveData.this.dispatchingValue(this);
            }
        }
    }
}

