/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.core.util.Function;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class Transformations {
    private Transformations() {
    }

    @MainThread
    public static <X, Y> LiveData<Y> map(@NonNull LiveData<X> source, final @NonNull Function<X, Y> func) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, new Observer<X>(){

            @Override
            public void onChanged(@Nullable X x) {
                result.setValue(func.apply(x));
            }
        });
        return result;
    }

    @MainThread
    public static <X, Y> LiveData<Y> switchMap(@NonNull LiveData<X> trigger, final @NonNull Function<X, LiveData<Y>> func) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(trigger, new Observer<X>(){
            LiveData<Y> mSource;

            @Override
            public void onChanged(@Nullable X x) {
                LiveData newLiveData = (LiveData)func.apply(x);
                if (this.mSource == newLiveData) {
                    return;
                }
                if (this.mSource != null) {
                    result.removeSource(this.mSource);
                }
                this.mSource = newLiveData;
                if (this.mSource != null) {
                    result.addSource(this.mSource, new Observer<Y>(){

                        @Override
                        public void onChanged(@Nullable Y y) {
                            result.setValue(y);
                        }
                    });
                }
            }
        });
        return result;
    }
}

