/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelStores;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import java.lang.reflect.InvocationTargetException;

public class ViewModelProviders {
    @SuppressLint(value={"StaticFieldLeak"})
    private static DefaultFactory sDefaultFactory;

    private static void initializeFactoryIfNeeded(Application application) {
        if (sDefaultFactory == null) {
            sDefaultFactory = new DefaultFactory(application);
        }
    }

    private static Application checkApplication(Activity activity) {
        Application application = activity.getApplication();
        if (application == null) {
            throw new IllegalStateException("Your activity/fragment is not yet attached to Application. You can't request ViewModel before onCreate call.");
        }
        return application;
    }

    private static Activity checkActivity(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Can't create ViewModelProvider for detached fragment");
        }
        return activity;
    }

    @MainThread
    public static ViewModelProvider of(@NonNull Fragment fragment) {
        ViewModelProviders.initializeFactoryIfNeeded(ViewModelProviders.checkApplication(ViewModelProviders.checkActivity(fragment)));
        return new ViewModelProvider(ViewModelStores.of(fragment), (ViewModelProvider.Factory)sDefaultFactory);
    }

    @MainThread
    public static ViewModelProvider of(@NonNull FragmentActivity activity) {
        ViewModelProviders.initializeFactoryIfNeeded(ViewModelProviders.checkApplication((Activity)activity));
        return new ViewModelProvider(ViewModelStores.of(activity), (ViewModelProvider.Factory)sDefaultFactory);
    }

    @MainThread
    public static ViewModelProvider of(@NonNull Fragment fragment, @NonNull ViewModelProvider.Factory factory) {
        ViewModelProviders.checkApplication(ViewModelProviders.checkActivity(fragment));
        return new ViewModelProvider(ViewModelStores.of(fragment), factory);
    }

    @MainThread
    public static ViewModelProvider of(@NonNull FragmentActivity activity, @NonNull ViewModelProvider.Factory factory) {
        ViewModelProviders.checkApplication((Activity)activity);
        return new ViewModelProvider(ViewModelStores.of(activity), factory);
    }

    public static class DefaultFactory
    extends ViewModelProvider.NewInstanceFactory {
        private Application mApplication;

        public DefaultFactory(@NonNull Application application) {
            this.mApplication = application;
        }

        @Override
        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            if (AndroidViewModel.class.isAssignableFrom(modelClass)) {
                try {
                    return (T)((ViewModel)modelClass.getConstructor(Application.class).newInstance(this.mApplication));
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Cannot create an instance of " + modelClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot create an instance of " + modelClass, e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Cannot create an instance of " + modelClass, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Cannot create an instance of " + modelClass, e);
                }
            }
            return super.create(modelClass);
        }
    }
}

