/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.view.View;
import android.view.ViewParent;
import androidx.navigation.NavController;
import androidx.navigation.R;
import java.lang.ref.WeakReference;

public final class Navigation {
    private Navigation() {
    }

    @NonNull
    public static NavController findNavController(@NonNull Activity activity, @IdRes int viewId) {
        View view = ActivityCompat.requireViewById((Activity)activity, (int)viewId);
        NavController navController = Navigation.findViewNavController(view);
        if (navController == null) {
            throw new IllegalStateException("Activity " + activity + " does not have a NavController set on " + viewId);
        }
        return navController;
    }

    @NonNull
    public static NavController findNavController(@NonNull View view) {
        NavController navController = Navigation.findViewNavController(view);
        if (navController == null) {
            throw new IllegalStateException("View " + view + " does not have a NavController set");
        }
        return navController;
    }

    @NonNull
    public static View.OnClickListener createNavigateOnClickListener(@IdRes int resId) {
        return Navigation.createNavigateOnClickListener(resId, null);
    }

    @NonNull
    public static View.OnClickListener createNavigateOnClickListener(final @IdRes int resId, final @Nullable Bundle args) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                Navigation.findNavController(view).navigate(resId, args);
            }
        };
    }

    public static void setViewNavController(@NonNull View view, @Nullable NavController controller) {
        view.setTag(R.id.nav_controller_view_tag, (Object)controller);
    }

    @Nullable
    private static NavController findViewNavController(@NonNull View view) {
        while (view != null) {
            NavController controller = Navigation.getViewNavController(view);
            if (controller != null) {
                return controller;
            }
            ViewParent parent = view.getParent();
            view = parent instanceof View ? (View)parent : null;
        }
        return null;
    }

    @Nullable
    private static NavController getViewNavController(@NonNull View view) {
        Object tag = view.getTag(R.id.nav_controller_view_tag);
        NavController controller = null;
        if (tag instanceof WeakReference) {
            controller = (NavController)((WeakReference)tag).get();
        } else if (tag instanceof NavController) {
            controller = (NavController)tag;
        }
        return controller;
    }
}

