/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.support.annotation.NavigationRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import androidx.navigation.NavAction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.NavType;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class NavInflater {
    private static final String TAG_ARGUMENT = "argument";
    private static final String TAG_DEEP_LINK = "deepLink";
    private static final String TAG_ACTION = "action";
    private static final String TAG_INCLUDE = "include";
    private static final String APPLICATION_ID_PLACEHOLDER = "${applicationId}";
    private static final ThreadLocal<TypedValue> sTmpValue = new ThreadLocal();
    private Context mContext;
    private NavigatorProvider mNavigatorProvider;

    public NavInflater(@NonNull Context context, @NonNull NavigatorProvider navigatorProvider) {
        this.mContext = context;
        this.mNavigatorProvider = navigatorProvider;
    }

    @SuppressLint(value={"ResourceType"})
    @NonNull
    public NavGraph inflate(@NavigationRes int graphResId) {
        Resources res = this.mContext.getResources();
        XmlResourceParser parser = res.getXml(graphResId);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            String rootElement = parser.getName();
            NavDestination destination = this.inflate(res, parser, attrs, graphResId);
            if (!(destination instanceof NavGraph)) {
                throw new IllegalArgumentException("Root element <" + rootElement + ">" + " did not inflate into a NavGraph");
            }
            NavGraph navGraph = (NavGraph)destination;
            return navGraph;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception inflating " + res.getResourceName(graphResId) + " line " + parser.getLineNumber(), e);
        }
        finally {
            parser.close();
        }
    }

    @NonNull
    private NavDestination inflate(@NonNull Resources res, @NonNull XmlResourceParser parser, @NonNull AttributeSet attrs, int graphResId) throws XmlPullParserException, IOException {
        int depth;
        int type;
        Navigator navigator = this.mNavigatorProvider.getNavigator(parser.getName());
        NavDestination dest = navigator.createDestination();
        dest.onInflate(this.mContext, attrs);
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (TAG_ARGUMENT.equals(name)) {
                this.inflateArgumentForDestination(res, dest, attrs, graphResId);
                continue;
            }
            if (TAG_DEEP_LINK.equals(name)) {
                this.inflateDeepLink(res, dest, attrs);
                continue;
            }
            if (TAG_ACTION.equals(name)) {
                this.inflateAction(res, dest, attrs, parser, graphResId);
                continue;
            }
            if (TAG_INCLUDE.equals(name) && dest instanceof NavGraph) {
                TypedArray a = res.obtainAttributes(attrs, R.styleable.NavInclude);
                int id = a.getResourceId(R.styleable.NavInclude_graph, 0);
                ((NavGraph)dest).addDestination((NavDestination)this.inflate(id));
                a.recycle();
                continue;
            }
            if (!(dest instanceof NavGraph)) continue;
            ((NavGraph)dest).addDestination(this.inflate(res, parser, attrs, graphResId));
        }
        return dest;
    }

    private void inflateArgumentForDestination(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs, int graphResId) throws XmlPullParserException {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavArgument);
        String name = a.getString(R.styleable.NavArgument_android_name);
        if (name == null) {
            throw new XmlPullParserException("Arguments must have a name");
        }
        NavArgument argument = this.inflateArgument(a, res, graphResId);
        dest.addArgument(name, argument);
        a.recycle();
    }

    private void inflateArgumentForBundle(@NonNull Resources res, @NonNull Bundle bundle, @NonNull AttributeSet attrs, int graphResId) throws XmlPullParserException {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavArgument);
        String name = a.getString(R.styleable.NavArgument_android_name);
        if (name == null) {
            throw new XmlPullParserException("Arguments must have a name");
        }
        NavArgument argument = this.inflateArgument(a, res, graphResId);
        if (argument.isDefaultValuePresent()) {
            argument.putDefaultValue(name, bundle);
        }
        a.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    private NavArgument inflateArgument(@NonNull TypedArray a, @NonNull Resources res, int graphResId) throws XmlPullParserException {
        NavArgument.Builder argumentBuilder = new NavArgument.Builder();
        argumentBuilder.setIsNullable(a.getBoolean(R.styleable.NavArgument_nullable, false));
        TypedValue value = sTmpValue.get();
        if (value == null) {
            value = new TypedValue();
            sTmpValue.set(value);
        }
        Object defaultValue = null;
        NavType navType = null;
        String argType = a.getString(R.styleable.NavArgument_argType);
        if (argType != null) {
            navType = NavType.fromArgType((String)argType, (String)res.getResourcePackageName(graphResId));
        }
        if (a.getValue(R.styleable.NavArgument_android_defaultValue, value)) {
            if (navType == NavType.StringType) {
                defaultValue = a.getString(R.styleable.NavArgument_android_defaultValue);
            } else if (navType == NavType.ReferenceType) {
                if (value.resourceId == 0) throw new XmlPullParserException("unsupported value '" + value.string + "' for " + navType.getName() + ". Must be a reference to a resource.");
                defaultValue = value.resourceId;
            } else {
                switch (value.type) {
                    case 3: {
                        String stringValue = value.string.toString();
                        if (navType == null) {
                            navType = NavType.inferFromValue((String)stringValue);
                        }
                        defaultValue = navType.parseValue(stringValue);
                        break;
                    }
                    case 5: {
                        navType = NavInflater.checkNavType(value, navType, NavType.IntType, argType, "dimension");
                        defaultValue = (int)value.getDimension(res.getDisplayMetrics());
                        break;
                    }
                    case 4: {
                        navType = NavInflater.checkNavType(value, navType, NavType.FloatType, argType, "float");
                        defaultValue = Float.valueOf(value.getFloat());
                        break;
                    }
                    case 1: {
                        navType = NavInflater.checkNavType(value, navType, NavType.IntType, argType, "reference");
                        defaultValue = value.data;
                        break;
                    }
                    case 18: {
                        navType = NavInflater.checkNavType(value, navType, NavType.BoolType, argType, "boolean");
                        defaultValue = value.data != 0;
                        break;
                    }
                    default: {
                        if (value.type < 16 || value.type > 31) throw new XmlPullParserException("unsupported argument type " + value.type);
                        navType = NavInflater.checkNavType(value, navType, NavType.IntType, argType, "integer");
                        defaultValue = value.data;
                        break;
                    }
                }
            }
        }
        if (defaultValue != null) {
            argumentBuilder.setDefaultValue(defaultValue);
        }
        if (navType == null) return argumentBuilder.build();
        argumentBuilder.setType(navType);
        return argumentBuilder.build();
    }

    private static NavType checkNavType(TypedValue value, NavType navType, NavType expectedNavType, String argType, String foundType) throws XmlPullParserException {
        if (navType != null && navType != expectedNavType) {
            throw new XmlPullParserException("Type is " + argType + " but found " + foundType + ": " + value.data);
        }
        return navType != null ? navType : expectedNavType;
    }

    private void inflateDeepLink(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs) {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavDeepLink);
        String uri = a.getString(R.styleable.NavDeepLink_uri);
        if (TextUtils.isEmpty((CharSequence)uri)) {
            throw new IllegalArgumentException("Every <deepLink> must include an app:uri");
        }
        uri = uri.replace(APPLICATION_ID_PLACEHOLDER, this.mContext.getPackageName());
        dest.addDeepLink(uri);
        a.recycle();
    }

    private void inflateAction(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs, XmlResourceParser parser, int graphResId) throws IOException, XmlPullParserException {
        int depth;
        int type;
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavAction);
        int id = a.getResourceId(R.styleable.NavAction_android_id, 0);
        int destId = a.getResourceId(R.styleable.NavAction_destination, 0);
        NavAction action = new NavAction(destId);
        NavOptions.Builder builder = new NavOptions.Builder();
        builder.setLaunchSingleTop(a.getBoolean(R.styleable.NavAction_launchSingleTop, false));
        builder.setPopUpTo(a.getResourceId(R.styleable.NavAction_popUpTo, 0), a.getBoolean(R.styleable.NavAction_popUpToInclusive, false));
        builder.setEnterAnim(a.getResourceId(R.styleable.NavAction_enterAnim, -1));
        builder.setExitAnim(a.getResourceId(R.styleable.NavAction_exitAnim, -1));
        builder.setPopEnterAnim(a.getResourceId(R.styleable.NavAction_popEnterAnim, -1));
        builder.setPopExitAnim(a.getResourceId(R.styleable.NavAction_popExitAnim, -1));
        action.setNavOptions(builder.build());
        Bundle args = new Bundle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            String name;
            if (type != 2 || depth > innerDepth || !TAG_ARGUMENT.equals(name = parser.getName())) continue;
            this.inflateArgumentForBundle(res, args, attrs, graphResId);
        }
        if (!args.isEmpty()) {
            action.setDefaultArguments(args);
        }
        dest.putAction(id, action);
        a.recycle();
    }
}

