/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.BoolType;
import androidx.navigation.safe.args.generator.Context;
import androidx.navigation.safe.args.generator.FloatType;
import androidx.navigation.safe.args.generator.IntType;
import androidx.navigation.safe.args.generator.LongType;
import androidx.navigation.safe.args.generator.NavParser;
import androidx.navigation.safe.args.generator.NavParserErrors;
import androidx.navigation.safe.args.generator.NavParserKt;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.NullValue;
import androidx.navigation.safe.args.generator.ParcelableType;
import androidx.navigation.safe.args.generator.ReferenceType;
import androidx.navigation.safe.args.generator.ReferenceValue;
import androidx.navigation.safe.args.generator.StringType;
import androidx.navigation.safe.args.generator.StringValue;
import androidx.navigation.safe.args.generator.WriteableValue;
import androidx.navigation.safe.args.generator.XmlPosition;
import androidx.navigation.safe.args.generator.XmlPositionParser;
import androidx.navigation.safe.args.generator.ext.String_extKt;
import androidx.navigation.safe.args.generator.models.Action;
import androidx.navigation.safe.args.generator.models.Argument;
import androidx.navigation.safe.args.generator.models.Destination;
import androidx.navigation.safe.args.generator.models.IncludedDestination;
import androidx.navigation.safe.args.generator.models.ResReference;
import com.squareup.javapoet.ClassName;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/safe/args/generator/NavParser;", "", "parser", "Landroidx/navigation/safe/args/generator/XmlPositionParser;", "context", "Landroidx/navigation/safe/args/generator/Context;", "rFilePackage", "", "applicationId", "(Landroidx/navigation/safe/args/generator/XmlPositionParser;Landroidx/navigation/safe/args/generator/Context;Ljava/lang/String;Ljava/lang/String;)V", "parseAction", "Landroidx/navigation/safe/args/generator/models/Action;", "parseArgument", "Landroidx/navigation/safe/args/generator/models/Argument;", "parseDestination", "Landroidx/navigation/safe/args/generator/models/Destination;", "parseDestination$navigation_safe_args_generator", "parseId", "Landroidx/navigation/safe/args/generator/models/ResReference;", "xmlId", "xmlPosition", "Landroidx/navigation/safe/args/generator/XmlPosition;", "parseIncludeDestination", "Landroidx/navigation/safe/args/generator/models/IncludedDestination;", "Companion", "navigation-safe-args-generator"})
public final class NavParser {
    private final XmlPositionParser parser;
    private final Context context;
    private final String rFilePackage;
    private final String applicationId;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Destination parseDestination$navigation_safe_args_generator() {
        Collection collection;
        ResReference resReference;
        String sanitizedName;
        Map.Entry element$iv2;
        List list$iv$iv;
        ArrayList answer$iv$iv$iv;
        Object value$iv$iv$iv;
        String key$iv$iv;
        Object it;
        Object element$iv$iv;
        Iterator $receiver$iv$iv$iv;
        Object $receiver$iv$iv;
        XmlPosition position = this.parser.xmlPosition();
        String type = this.parser.name();
        String string = this.parser.attrValue("http://schemas.android.com/apk/res/android", "name");
        if (string == null) {
            string = "";
        }
        String name = string;
        String idValue = this.parser.attrValue("http://schemas.android.com/apk/res/android", "id");
        List args = new ArrayList();
        List actions = new ArrayList();
        List nested = new ArrayList();
        List included = new ArrayList();
        this.parser.traverseInnerStartTags((Function0<Unit>)((Function0)new Function0<Unit>(this, actions, args, included, type, nested){
            final /* synthetic */ NavParser this$0;
            final /* synthetic */ List $actions;
            final /* synthetic */ List $args;
            final /* synthetic */ List $included;
            final /* synthetic */ String $type;
            final /* synthetic */ List $nested;

            public final void invoke() {
                if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"action")) {
                    this.$actions.add(NavParser.access$parseAction(this.this$0));
                } else if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"argument")) {
                    this.$args.add(NavParser.access$parseArgument(this.this$0));
                } else if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"include")) {
                    this.$included.add(NavParser.access$parseIncludeDestination(this.this$0));
                } else if (Intrinsics.areEqual((Object)this.$type, (Object)"navigation")) {
                    this.$nested.add(this.this$0.parseDestination$navigation_safe_args_generator());
                }
            }
            {
                this.this$0 = navParser;
                this.$actions = list;
                this.$args = list2;
                this.$included = list3;
                this.$type = string;
                this.$nested = list4;
                super(0);
            }
        }));
        Object $receiver$iv = actions;
        Iterable iterable = $receiver$iv;
        Iterator destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator.next();
            it = (Action)element$iv$iv;
            key$iv$iv = String_extKt.toCamelCase(((Action)it).getId().getJavaIdentifier());
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        for (Map.Entry element$iv2 : $receiver$iv$iv.entrySet()) {
            Map.Entry $sanitizedName_actions = element$iv2;
            it = $sanitizedName_actions;
            sanitizedName = (String)it.getKey();
            it = $sanitizedName_actions;
            List actions2 = (List)it.getValue();
            if (actions2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameActions(sanitizedName, actions2), position);
        }
        $receiver$iv$iv = $receiver$iv = (Iterable)args;
        destination$iv$iv = new LinkedHashMap();
        element$iv2 = $receiver$iv$iv.iterator();
        while (element$iv2.hasNext()) {
            Object object;
            $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = element$iv2.next();
            it = (Argument)element$iv$iv;
            key$iv$iv = ((Argument)it).getSanitizedName();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = $receiver$iv$iv.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            Map.Entry $sanitizedName_args;
            Map.Entry entry = $sanitizedName_args = (element$iv2 = destination$iv$iv.next());
            sanitizedName = (String)entry.getKey();
            entry = $sanitizedName_args;
            List args2 = (List)entry.getValue();
            if (args2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameArguments(sanitizedName, args2), position);
        }
        String string2 = idValue;
        if (string2 != null) {
            Object it2 = $receiver$iv$iv = string2;
            resReference = this.parseId(idValue, this.rFilePackage, position);
        } else {
            resReference = null;
        }
        ResReference id = resReference;
        ClassName className = Destination.Companion.createName(id, name, this.applicationId);
        if (className == null && (!(collection = (Collection)actions).isEmpty() || !(collection = (Collection)args).isEmpty())) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.getUNNAMED_DESTINATION(), position);
            return this.context.createStubDestination();
        }
        return new Destination(id, className, type, args, actions, nested, included);
    }

    private final IncludedDestination parseIncludeDestination() {
        XmlPosition xmlPosition = this.parser.xmlPosition();
        String graphValue = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "graph");
        if (graphValue == null) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.getMISSING_GRAPH_ATTR(), xmlPosition);
            return this.context.createStubIncludedDestination();
        }
        ResReference graphRef = NavParserKt.parseReference(graphValue, this.rFilePackage);
        if (graphRef == null || Intrinsics.areEqual((Object)graphRef.getResType(), (Object)"navigation") ^ true) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.invalidNavReference(graphValue), xmlPosition);
            return this.context.createStubIncludedDestination();
        }
        return new IncludedDestination(graphRef, null, 2, null);
    }

    private final Argument parseArgument() {
        Object object;
        WriteableValue writeableValue;
        boolean nullable;
        boolean bl;
        XmlPosition xmlPosition = this.parser.xmlPosition();
        String name = this.parser.attrValueOrError("http://schemas.android.com/apk/res/android", "name");
        String defaultValue = this.parser.attrValue("http://schemas.android.com/apk/res/android", "defaultValue");
        String typeString = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "argType");
        String string = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "nullable");
        if (string != null) {
            String string2;
            String it = string2 = string;
            bl = Intrinsics.areEqual((Object)it, (Object)"true");
        } else {
            bl = nullable = false;
        }
        if (name == null) {
            return this.context.createStubArg();
        }
        if (this.parser.attrValue("http://schemas.android.com/apk/res-auto", "type") != null) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.deprecatedTypeAttrUsed(name), xmlPosition);
            return this.context.createStubArg();
        }
        if (typeString == null && defaultValue != null) {
            return NavParserKt.inferArgument(name, defaultValue, this.rFilePackage);
        }
        NavType type = NavType.Companion.from(typeString);
        if (nullable && !type.allowsNullable()) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.typeIsNotNullable(typeString), xmlPosition);
            return this.context.createStubArg();
        }
        if (defaultValue == null) {
            return new Argument(name, type, null, nullable);
        }
        NavType $i$a$1$let = type;
        if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)IntType.INSTANCE)) {
            writeableValue = NavParserKt.parseIntValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)LongType.INSTANCE)) {
            writeableValue = NavParserKt.parseLongValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)FloatType.INSTANCE)) {
            writeableValue = NavParserKt.access$parseFloatValue(defaultValue);
        } else if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)BoolType.INSTANCE)) {
            writeableValue = NavParserKt.access$parseBoolean(defaultValue);
        } else if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)ReferenceType.INSTANCE)) {
            ReferenceValue referenceValue;
            ResReference resReference = NavParserKt.parseReference(defaultValue, this.rFilePackage);
            if (resReference != null) {
                Object it = object = resReference;
                referenceValue = new ReferenceValue((ResReference)it);
            } else {
                referenceValue = null;
            }
            writeableValue = referenceValue;
        } else if (Intrinsics.areEqual((Object)$i$a$1$let, (Object)StringType.INSTANCE)) {
            writeableValue = Intrinsics.areEqual((Object)defaultValue, (Object)"@null") ? (WriteableValue)NullValue.INSTANCE : (WriteableValue)new StringValue(defaultValue);
        } else if ($i$a$1$let instanceof ParcelableType) {
            if (!Intrinsics.areEqual((Object)defaultValue, (Object)"@null")) {
                this.context.getLogger().error(NavParserErrors.INSTANCE.defaultValueParcelable(typeString), xmlPosition);
                return this.context.createStubArg();
            }
            writeableValue = NullValue.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        WriteableValue defaultTypedValue = writeableValue;
        if (defaultTypedValue == null) {
            object = type;
            String errorMessage = Intrinsics.areEqual((Object)object, (Object)ReferenceType.INSTANCE) ? NavParserErrors.INSTANCE.invalidDefaultValueReference(defaultValue) : NavParserErrors.INSTANCE.invalidDefaultValue(defaultValue, type);
            this.context.getLogger().error(errorMessage, xmlPosition);
            return this.context.createStubArg();
        }
        if (!nullable && Intrinsics.areEqual((Object)defaultTypedValue, (Object)NullValue.INSTANCE)) {
            this.context.getLogger().error(NavParserErrors.INSTANCE.defaultNullButNotNullable(name), xmlPosition);
            return this.context.createStubArg();
        }
        return new Argument(name, type, defaultTypedValue, nullable);
    }

    private final Action parseAction() {
        ResReference resReference;
        Object $receiver$iv$iv;
        String idValue = this.parser.attrValueOrError("http://schemas.android.com/apk/res/android", "id");
        String destValue = this.parser.attrValue("http://schemas.android.com/apk/res-auto", "destination");
        List args = new ArrayList();
        XmlPosition position = this.parser.xmlPosition();
        this.parser.traverseInnerStartTags((Function0<Unit>)((Function0)new Function0<Unit>(this, args){
            final /* synthetic */ NavParser this$0;
            final /* synthetic */ List $args;

            public final void invoke() {
                if (Intrinsics.areEqual((Object)NavParser.access$getParser$p(this.this$0).name(), (Object)"argument")) {
                    this.$args.add(NavParser.access$parseArgument(this.this$0));
                }
            }
            {
                this.this$0 = navParser;
                this.$args = list;
                super(0);
            }
        }));
        Object $receiver$iv = args;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            Argument it = (Argument)element$iv$iv;
            String key$iv$iv = it.getSanitizedName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Object object = $receiver$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $sanitizedName_args;
            Map.Entry entry = $sanitizedName_args = (element$iv = object.next());
            String sanitizedName = (String)entry.getKey();
            entry = $sanitizedName_args;
            List args2 = (List)entry.getValue();
            if (args2.size() <= 1) continue;
            this.context.getLogger().error(NavParserErrors.INSTANCE.sameSanitizedNameArguments(sanitizedName, args2), position);
        }
        ResReference id = idValue != null ? this.parseId(idValue, this.rFilePackage, position) : this.context.createStubId();
        String string = destValue;
        if (string != null) {
            Object it = object = string;
            resReference = this.parseId(destValue, this.rFilePackage, position);
        } else {
            resReference = null;
        }
        ResReference destination = resReference;
        return new Action(id, destination, args);
    }

    private final ResReference parseId(String xmlId, String rFilePackage, XmlPosition xmlPosition) {
        ResReference ref;
        ResReference resReference = ref = NavParserKt.parseReference(xmlId, rFilePackage);
        if (resReference != null) {
            if (resReference.isId()) {
                return ref;
            }
        }
        this.context.getLogger().error(NavParserErrors.INSTANCE.invalidId(xmlId), xmlPosition);
        return this.context.createStubId();
    }

    public NavParser(@NotNull XmlPositionParser parser, @NotNull Context context, @NotNull String rFilePackage, @NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        this.parser = parser;
        this.context = context;
        this.rFilePackage = rFilePackage;
        this.applicationId = applicationId;
    }

    @NotNull
    public static final /* synthetic */ XmlPositionParser access$getParser$p(NavParser $this) {
        return $this.parser;
    }

    @NotNull
    public static final /* synthetic */ Action access$parseAction(NavParser $this) {
        return $this.parseAction();
    }

    @NotNull
    public static final /* synthetic */ Argument access$parseArgument(NavParser $this) {
        return $this.parseArgument();
    }

    @NotNull
    public static final /* synthetic */ IncludedDestination access$parseIncludeDestination(NavParser $this) {
        return $this.parseIncludeDestination();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Landroidx/navigation/safe/args/generator/NavParser$Companion;", "", "()V", "parseNavigationFile", "Landroidx/navigation/safe/args/generator/models/Destination;", "navigationXml", "Ljava/io/File;", "rFilePackage", "", "applicationId", "context", "Landroidx/navigation/safe/args/generator/Context;", "navigation-safe-args-generator"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Destination parseNavigationFile(@NotNull File navigationXml, @NotNull String rFilePackage, @NotNull String applicationId, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)navigationXml, (String)"navigationXml");
            Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
            Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Closeable closeable = new FileReader(navigationXml);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                String string = navigationXml.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"navigationXml.path");
                XmlPositionParser parser = new XmlPositionParser(string, reader, context.getLogger());
                parser.traverseStartTags((Function0<Boolean>)((Function0)parseNavigationFile.1.1.INSTANCE));
                Destination destination = new NavParser(parser, context, rFilePackage, applicationId).parseDestination$navigation_safe_args_generator();
                return destination;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

