/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.AsyncPagedListDiffer;
import android.arch.paging.PagedList;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.recyclerview.extensions.AsyncDifferConfig;
import android.support.v7.util.AdapterListUpdateCallback;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;

public abstract class PagedListAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private final AsyncPagedListDiffer<T> mDiffer;
    private final AsyncPagedListDiffer.PagedListListener<T> mListener = new AsyncPagedListDiffer.PagedListListener<T>(){

        @Override
        public void onCurrentListChanged(@Nullable PagedList<T> currentList) {
            PagedListAdapter.this.onCurrentListChanged(currentList);
        }
    };

    protected PagedListAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this.mDiffer = new AsyncPagedListDiffer<T>(this, diffCallback);
        this.mDiffer.mListener = this.mListener;
    }

    protected PagedListAdapter(@NonNull AsyncDifferConfig<T> config) {
        this.mDiffer = new AsyncPagedListDiffer<T>((ListUpdateCallback)new AdapterListUpdateCallback((RecyclerView.Adapter)this), config);
        this.mDiffer.mListener = this.mListener;
    }

    public void submitList(PagedList<T> pagedList) {
        this.mDiffer.submitList(pagedList);
    }

    @Nullable
    protected T getItem(int position) {
        return this.mDiffer.getItem(position);
    }

    public int getItemCount() {
        return this.mDiffer.getItemCount();
    }

    @Nullable
    public PagedList<T> getCurrentList() {
        return this.mDiffer.getCurrentList();
    }

    public void onCurrentListChanged(@Nullable PagedList<T> currentList) {
    }
}

