/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.ProcessorErrors;
import android.arch.persistence.room.solver.TypeAdapterStore;
import android.arch.persistence.room.solver.query.parameter.QueryParameterAdapter;
import android.arch.persistence.room.vo.QueryParameter;
import com.google.auto.common.MoreTypes;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroid/arch/persistence/room/processor/QueryParameterProcessor;", "", "baseContext", "Landroid/arch/persistence/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "element", "Ljavax/lang/model/element/VariableElement;", "(Landroid/arch/persistence/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/VariableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/VariableElement;", "process", "Landroid/arch/persistence/room/vo/QueryParameter;", "compiler"})
public final class QueryParameterProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final VariableElement element;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final QueryParameter process() {
        TypeMirror asMember = MoreTypes.asMemberOf((Types)this.context.getProcessingEnv().getTypeUtils(), (DeclaredType)this.containing, (VariableElement)this.element);
        TypeAdapterStore typeAdapterStore2 = this.context.getTypeAdapterStore();
        TypeMirror typeMirror = asMember;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"asMember");
        QueryParameterAdapter parameterAdapter = typeAdapterStore2.findQueryParameterAdapter(typeMirror);
        this.context.getChecker().check(parameterAdapter != null, this.element, ProcessorErrors.INSTANCE.getCANNOT_BIND_QUERY_PARAMETER_INTO_STMT(), new Object[0]);
        String name = this.element.getSimpleName().toString();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        return new QueryParameter(name, asMember, parameterAdapter);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final VariableElement getElement() {
        return this.element;
    }

    public QueryParameterProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull VariableElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.containing = containing;
        this.element = element;
        this.context = baseContext.fork(this.element);
    }
}

