/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RxRoom {
    public static final Object NOTHING = new Object();
    private static Scheduler sAppToolkitIOScheduler = new Scheduler(){

        public Scheduler.Worker createWorker() {
            final AtomicBoolean mDisposed = new AtomicBoolean(false);
            return new Scheduler.Worker(){

                public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
                    DisposableRunnable disposable = new DisposableRunnable(run, mDisposed);
                    ArchTaskExecutor.getInstance().executeOnDiskIO(run);
                    return disposable;
                }

                public void dispose() {
                    mDisposed.set(true);
                }

                public boolean isDisposed() {
                    return mDisposed.get();
                }
            };
        }
    };

    public static Flowable<Object> createFlowable(final RoomDatabase database, final String ... tableNames) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Object>(){

            public void subscribe(final FlowableEmitter<Object> emitter) throws Exception {
                final InvalidationTracker.Observer observer = new InvalidationTracker.Observer(tableNames){

                    public void onInvalidated(@android.support.annotation.NonNull Set<String> tables) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(NOTHING);
                        }
                    }
                };
                if (!emitter.isCancelled()) {
                    database.getInvalidationTracker().addObserver(observer);
                    emitter.setDisposable(Disposables.fromAction((Action)new Action(){

                        public void run() throws Exception {
                            database.getInvalidationTracker().removeObserver(observer);
                        }
                    }));
                }
                if (!emitter.isCancelled()) {
                    emitter.onNext(NOTHING);
                }
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static <T> Flowable<T> createFlowable(RoomDatabase database, String[] tableNames, final Callable<T> callable) {
        return RxRoom.createFlowable(database, tableNames).observeOn(sAppToolkitIOScheduler).map(new Function<Object, Optional<T>>(){

            public Optional<T> apply(@NonNull Object o) throws Exception {
                Object data = callable.call();
                return new Optional(data);
            }
        }).filter(new Predicate<Optional<T>>(){

            public boolean test(@NonNull Optional<T> optional) throws Exception {
                return optional.mValue != null;
            }
        }).map(new Function<Optional<T>, T>(){

            public T apply(@NonNull Optional<T> optional) throws Exception {
                return optional.mValue;
            }
        });
    }

    static class Optional<T> {
        @Nullable
        final T mValue;

        Optional(@Nullable T value) {
            this.mValue = value;
        }
    }

    private static class DisposableRunnable
    implements Disposable,
    Runnable {
        private final Runnable mActual;
        private volatile boolean mDisposed = false;
        private final AtomicBoolean mGlobalDisposed;

        DisposableRunnable(Runnable actual, AtomicBoolean globalDisposed) {
            this.mActual = actual;
            this.mGlobalDisposed = globalDisposed;
        }

        public void dispose() {
            this.mDisposed = true;
        }

        public boolean isDisposed() {
            return this.mDisposed || this.mGlobalDisposed.get();
        }

        @Override
        public void run() {
            if (!this.isDisposed()) {
                this.mActual.run();
            }
        }
    }
}

