/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import androidx.work.Data;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class WorkInfo {
    @NonNull
    private UUID mId;
    @NonNull
    private State mState;
    @NonNull
    private Data mOutputData;
    @NonNull
    private Set<String> mTags;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public WorkInfo(@NonNull UUID id, @NonNull State state, @NonNull Data outputData, @NonNull List<String> tags) {
        this.mId = id;
        this.mState = state;
        this.mOutputData = outputData;
        this.mTags = new HashSet<String>(tags);
    }

    @NonNull
    public UUID getId() {
        return this.mId;
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    @NonNull
    public Data getOutputData() {
        return this.mOutputData;
    }

    @NonNull
    public Set<String> getTags() {
        return this.mTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkInfo that = (WorkInfo)o;
        if (this.mId != null ? !this.mId.equals(that.mId) : that.mId != null) {
            return false;
        }
        if (this.mState != that.mState) {
            return false;
        }
        if (this.mOutputData != null ? !this.mOutputData.equals(that.mOutputData) : that.mOutputData != null) {
            return false;
        }
        return this.mTags != null ? this.mTags.equals(that.mTags) : that.mTags == null;
    }

    public int hashCode() {
        int result = this.mId != null ? this.mId.hashCode() : 0;
        result = 31 * result + (this.mState != null ? this.mState.hashCode() : 0);
        result = 31 * result + (this.mOutputData != null ? this.mOutputData.hashCode() : 0);
        result = 31 * result + (this.mTags != null ? this.mTags.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkInfo{mId='" + this.mId + '\'' + ", mState=" + (Object)((Object)this.mState) + ", mOutputData=" + this.mOutputData + ", mTags=" + this.mTags + '}';
    }

    public static enum State {
        ENQUEUED,
        RUNNING,
        SUCCEEDED,
        FAILED,
        BLOCKED,
        CANCELLED;


        public boolean isFinished() {
            return this == SUCCEEDED || this == FAILED || this == CANCELLED;
        }
    }
}

