/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.controllers;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import androidx.work.NetworkType;
import androidx.work.impl.constraints.NetworkState;
import androidx.work.impl.constraints.controllers.ConstraintController;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;

public class NetworkConnectedController
extends ConstraintController<NetworkState> {
    public NetworkConnectedController(Context context) {
        super(Trackers.getInstance(context).getNetworkStateTracker());
    }

    @Override
    boolean hasConstraint(@NonNull WorkSpec workSpec) {
        return workSpec.constraints.getRequiredNetworkType() == NetworkType.CONNECTED;
    }

    @Override
    boolean isConstrained(@NonNull NetworkState state) {
        if (Build.VERSION.SDK_INT >= 26) {
            return !state.isConnected() || !state.isValidated();
        }
        return !state.isConnected();
    }
}

