/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import androidx.work.impl.constraints.trackers.BatteryChargingTracker;
import androidx.work.impl.constraints.trackers.BatteryNotLowTracker;
import androidx.work.impl.constraints.trackers.NetworkStateTracker;
import androidx.work.impl.constraints.trackers.StorageNotLowTracker;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Trackers {
    private static Trackers sInstance;
    private BatteryChargingTracker mBatteryChargingTracker;
    private BatteryNotLowTracker mBatteryNotLowTracker;
    private NetworkStateTracker mNetworkStateTracker;
    private StorageNotLowTracker mStorageNotLowTracker;

    public static synchronized Trackers getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new Trackers(context);
        }
        return sInstance;
    }

    @VisibleForTesting
    public static synchronized void setInstance(@NonNull Trackers trackers) {
        sInstance = trackers;
    }

    private Trackers(Context context) {
        Context appContext = context.getApplicationContext();
        this.mBatteryChargingTracker = new BatteryChargingTracker(appContext);
        this.mBatteryNotLowTracker = new BatteryNotLowTracker(appContext);
        this.mNetworkStateTracker = new NetworkStateTracker(appContext);
        this.mStorageNotLowTracker = new StorageNotLowTracker(appContext);
    }

    public BatteryChargingTracker getBatteryChargingTracker() {
        return this.mBatteryChargingTracker;
    }

    public BatteryNotLowTracker getBatteryNotLowTracker() {
        return this.mBatteryNotLowTracker;
    }

    public NetworkStateTracker getNetworkStateTracker() {
        return this.mNetworkStateTracker;
    }

    public StorageNotLowTracker getStorageNotLowTracker() {
        return this.mStorageNotLowTracker;
    }
}

