/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;

public class SystemIdInfoDao_Impl
implements SystemIdInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfSystemIdInfo;
    private final SharedSQLiteStatement __preparedStmtOfRemoveSystemIdInfo;

    public SystemIdInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSystemIdInfo = new EntityInsertionAdapter<SystemIdInfo>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `SystemIdInfo`(`work_spec_id`,`system_id`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SystemIdInfo value) {
                if (value.workSpecId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.workSpecId);
                }
                stmt.bindLong(2, (long)value.systemId);
            }
        };
        this.__preparedStmtOfRemoveSystemIdInfo = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM SystemIdInfo where work_spec_id=?";
                return "DELETE FROM SystemIdInfo where work_spec_id=?";
            }
        };
    }

    @Override
    public void insertSystemIdInfo(SystemIdInfo systemIdInfo) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSystemIdInfo.insert((Object)systemIdInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSystemIdInfo(String workSpecId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveSystemIdInfo.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (workSpecId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, workSpecId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveSystemIdInfo.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemIdInfo getSystemIdInfo(String workSpecId) {
        String _sql = "SELECT * FROM SystemIdInfo WHERE work_spec_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SystemIdInfo WHERE work_spec_id=?", (int)1);
        int _argIndex = 1;
        if (workSpecId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, workSpecId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            SystemIdInfo _result;
            int _cursorIndexOfWorkSpecId = _cursor.getColumnIndexOrThrow("work_spec_id");
            int _cursorIndexOfSystemId = _cursor.getColumnIndexOrThrow("system_id");
            if (_cursor.moveToFirst()) {
                String _tmpWorkSpecId = _cursor.getString(_cursorIndexOfWorkSpecId);
                int _tmpSystemId = _cursor.getInt(_cursorIndexOfSystemId);
                _result = new SystemIdInfo(_tmpWorkSpecId, _tmpSystemId);
            } else {
                _result = null;
            }
            SystemIdInfo systemIdInfo = _result;
            return systemIdInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

