/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import androidx.work.Logger;

public class PackageManagerHelper {
    private static final String TAG = Logger.tagWithPrefix("PackageManagerHelper");

    private PackageManagerHelper() {
    }

    public static void setComponentEnabled(@NonNull Context context, @NonNull Class klazz, boolean enabled) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ComponentName componentName = new ComponentName(context, klazz.getName());
            packageManager.setComponentEnabledSetting(componentName, enabled ? 1 : 2, 1);
            Logger.get().debug(TAG, String.format("%s %s", klazz.getName(), enabled ? "enabled" : "disabled"), new Throwable[0]);
        }
        catch (Exception exception) {
            Logger.get().debug(TAG, String.format("%s could not be %s", klazz.getName(), enabled ? "enabled" : "disabled"), exception);
        }
    }

    public static boolean isComponentExplicitlyEnabled(Context context, Class klazz) {
        return PackageManagerHelper.isComponentExplicitlyEnabled(context, klazz.getName());
    }

    public static boolean isComponentExplicitlyEnabled(Context context, String className) {
        ComponentName componentName;
        PackageManager packageManager = context.getPackageManager();
        int state = packageManager.getComponentEnabledSetting(componentName = new ComponentName(context, className));
        return state == 1;
    }
}

