/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import androidx.work.Logger;
import java.util.HashMap;
import java.util.WeakHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WakeLocks {
    private static final String TAG = Logger.tagWithPrefix("WakeLocks");
    private static final WeakHashMap<PowerManager.WakeLock, String> sWakeLocks = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerManager.WakeLock newWakeLock(@NonNull Context context, @NonNull String tag) {
        PowerManager powerManager = (PowerManager)context.getApplicationContext().getSystemService("power");
        String tagWithPrefix = "WorkManager: " + tag;
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, tagWithPrefix);
        WeakHashMap<PowerManager.WakeLock, String> weakHashMap = sWakeLocks;
        synchronized (weakHashMap) {
            sWakeLocks.put(wakeLock, tagWithPrefix);
        }
        return wakeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkWakeLocks() {
        HashMap<PowerManager.WakeLock, String> wakeLocksCopy = new HashMap<PowerManager.WakeLock, String>();
        WeakHashMap<PowerManager.WakeLock, String> weakHashMap = sWakeLocks;
        synchronized (weakHashMap) {
            wakeLocksCopy.putAll(sWakeLocks);
        }
        for (PowerManager.WakeLock wakeLock : wakeLocksCopy.keySet()) {
            if (wakeLock == null || !wakeLock.isHeld()) continue;
            String message = String.format("WakeLock held for %s", wakeLocksCopy.get(wakeLock));
            Logger.get().warning(TAG, message, new Throwable[0]);
        }
    }

    private WakeLocks() {
    }
}

